/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api.energy.fe;

import com.hbm.api.energy.fe.IHBMEnergyStorage;
import com.hbm.registries.ModTags;
import com.hbm.utils.MthHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;

public class TransmitHelper {
    public static int conductCond = 5;

    public static void machineTransmit(Level level, BlockPos pPos, BlockState pState, BlockEntity pBlockEntity) {
        if (pBlockEntity == null || pBlockEntity.m_58901_()) {
            return;
        }
        pBlockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(cap -> {
            IHBMEnergyStorage energyStorage = (IHBMEnergyStorage)cap;
            long amountNeed = energyStorage.getMaxInput();
            HashMap energySources = new HashMap();
            for (Direction direction : Direction.values()) {
                pBlockEntity.getCapability(ForgeCapabilities.ENERGY, direction).ifPresent(sideCap -> {
                    BlockEntity neighbourEntity = level.m_7702_(pPos.m_121945_(direction));
                    if (neighbourEntity == null) {
                        return;
                    }
                    neighbourEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).ifPresent(neighbourCap -> {
                        if (!neighbourCap.canExtract()) {
                            return;
                        }
                        long extractPotential = 0L;
                        if (neighbourCap instanceof IHBMEnergyStorage) {
                            IHBMEnergyStorage hbmNeighbourCap = (IHBMEnergyStorage)neighbourCap;
                            extractPotential = hbmNeighbourCap.extractEnergy(amountNeed, true);
                        } else {
                            extractPotential = neighbourCap.extractEnergy(MthHelper.long2int(amountNeed), true);
                        }
                        energySources.put(neighbourCap, extractPotential);
                    });
                });
            }
            if (energySources.isEmpty()) {
                return;
            }
            long extractPotentialSum = energySources.values().stream().reduce(Long::sum).orElse(0L);
            long realExtract = 0L;
            double restrictRatio = energySources.size() == 1 ? 1.0 : 1.6 / (double)energySources.size();
            for (Map.Entry entry : energySources.entrySet()) {
                IEnergyStorage energySource = (IEnergyStorage)entry.getKey();
                Long amount = (Long)entry.getValue();
                amount = (long)((double)amountNeed * Math.min((double)amount.longValue() / (double)extractPotentialSum, restrictRatio));
                if (energySource instanceof IHBMEnergyStorage) {
                    IHBMEnergyStorage hbmEnergySource = (IHBMEnergyStorage)energySource;
                    realExtract += hbmEnergySource.extractEnergy(amount, false);
                    continue;
                }
                realExtract += (long)energySource.extractEnergy(MthHelper.long2int(amount), false);
            }
            energyStorage.receiveEnergy(realExtract, false);
        });
    }

    public static void generatorTransmit(Level level, BlockPos pPos, BlockState pState, BlockEntity pBlockEntity) {
        if (pBlockEntity == null || pBlockEntity.m_58901_()) {
            return;
        }
        pBlockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(cap -> {
            IHBMEnergyStorage energyStorage = (IHBMEnergyStorage)cap;
            long amountToOutput = energyStorage.getMaxOutput();
            HashMap energyDests = new HashMap();
            for (Direction direction : Direction.values()) {
                pBlockEntity.getCapability(ForgeCapabilities.ENERGY, direction).ifPresent(sideCap -> {
                    BlockEntity neighbourEntity = level.m_7702_(pPos.m_121945_(direction));
                    if (neighbourEntity == null) {
                        return;
                    }
                    neighbourEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).ifPresent(neighbourCap -> {
                        if (!neighbourCap.canReceive()) {
                            return;
                        }
                        long receivePotential = 0L;
                        if (neighbourCap instanceof IHBMEnergyStorage) {
                            IHBMEnergyStorage hbmNeighbourCap = (IHBMEnergyStorage)neighbourCap;
                            receivePotential = hbmNeighbourCap.receiveEnergy(amountToOutput, true);
                        } else {
                            receivePotential = neighbourCap.receiveEnergy(MthHelper.long2int(amountToOutput), true);
                        }
                        energyDests.put(neighbourCap, receivePotential);
                    });
                });
            }
            if (energyDests.isEmpty()) {
                return;
            }
            long receivePotentialSum = energyDests.values().stream().reduce(Long::sum).orElse(0L);
            long realReceive = 0L;
            double restrictRatio = energyDests.size() == 1 ? 1.0 : 1.6 / (double)energyDests.size();
            for (Map.Entry entry : energyDests.entrySet()) {
                IEnergyStorage energySource = (IEnergyStorage)entry.getKey();
                Long amount = (Long)entry.getValue();
                amount = (long)((double)amountToOutput * Math.min((double)amount.longValue() / (double)receivePotentialSum, restrictRatio));
                if (energySource instanceof IHBMEnergyStorage) {
                    IHBMEnergyStorage hbmEnergySource = (IHBMEnergyStorage)energySource;
                    realReceive += hbmEnergySource.receiveEnergy(amount, false);
                    continue;
                }
                realReceive += (long)energySource.receiveEnergy(MthHelper.long2int(amount), false);
            }
            energyStorage.receiveEnergy(realReceive, false);
        });
    }

    public static void cableTransmit(Level level, BlockPos pPos, BlockState pState, BlockEntity pBlockEntity) {
        pBlockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(cap -> {
            IHBMEnergyStorage energyStorage = (IHBMEnergyStorage)cap;
            long amountOutput = energyStorage.getMaxOutput();
            HashMap energyDests = new HashMap();
            for (Direction direction : Direction.values()) {
                pBlockEntity.getCapability(ForgeCapabilities.ENERGY, direction).ifPresent(sideCap -> {
                    BlockEntity neighbourEntity = level.m_7702_(pPos.m_121945_(direction));
                    if (neighbourEntity == null) {
                        return;
                    }
                    neighbourEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).ifPresent(neighbourCap -> {
                        long receivePotential;
                        if (!neighbourCap.canReceive()) {
                            return;
                        }
                        if (neighbourCap.getEnergyStored() >= energyStorage.getEnergyStored() - conductCond) {
                            return;
                        }
                        if (neighbourCap instanceof IHBMEnergyStorage) {
                            IHBMEnergyStorage hbmNeighbourCap = (IHBMEnergyStorage)neighbourCap;
                            receivePotential = energyStorage.getLongStore() - hbmNeighbourCap.getLongStore();
                        } else {
                            receivePotential = neighbourCap.getEnergyStored() - energyStorage.getEnergyStored();
                        }
                        energyDests.put(neighbourCap, receivePotential);
                    });
                });
            }
            if (energyDests.isEmpty()) {
                return;
            }
            long receivePotentialSum = energyDests.values().stream().reduce(Long::sum).orElse(0L);
            amountOutput = Math.min(amountOutput, energyDests.values().stream().min(Long::compareTo).orElse(0L));
            long realReceive = 0L;
            double restrictRatio = energyDests.size() == 1 ? 1.0 : 1.6 / (double)energyDests.size();
            for (Map.Entry entry : energyDests.entrySet()) {
                IEnergyStorage energySource = (IEnergyStorage)entry.getKey();
                Long amount = (Long)entry.getValue();
                amount = (long)((double)amountOutput * Math.min((double)amount.longValue() / (double)receivePotentialSum, restrictRatio));
                if (energySource instanceof IHBMEnergyStorage) {
                    IHBMEnergyStorage hbmEnergySource = (IHBMEnergyStorage)energySource;
                    realReceive += hbmEnergySource.receiveEnergy(amount, false);
                    continue;
                }
                realReceive += (long)energySource.receiveEnergy(MthHelper.long2int(amount), false);
            }
            energyStorage.extractEnergy(realReceive, false);
        });
    }

    public static void batteryTransmit(Level level, BlockPos pPos, BlockState pState, BlockEntity pBlockEntity) {
        if (pBlockEntity == null || pBlockEntity.m_58901_()) {
            return;
        }
        double priorityRatio = 1.0;
        double stableRatio = 0.4;
        pBlockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(cap -> {
            IHBMEnergyStorage energyStorage = (IHBMEnergyStorage)cap;
            long amountInput = energyStorage.getMaxInput();
            long amountOutput = energyStorage.getMaxOutput();
            HashMap energyInteract = new HashMap();
            for (Direction direction : Direction.values()) {
                long finalAmountOutput = amountOutput;
                long finalAmountInput = amountInput;
                pBlockEntity.getCapability(ForgeCapabilities.ENERGY, direction).ifPresent(sideCap -> {
                    BlockEntity neighbourEntity = level.m_7702_(pPos.m_121945_(direction));
                    if (neighbourEntity == null) {
                        return;
                    }
                    neighbourEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).ifPresent(neighbourCap -> {
                        long extractPotential = 0L;
                        long receivePotential = 0L;
                        long energyDiff = 0L;
                        long partialDiff = 0L;
                        double batteryPartial = 0.0;
                        double neighbourPartial = 0.0;
                        if (neighbourCap.canReceive() && neighbourCap.canExtract()) {
                            if (neighbourCap instanceof IHBMEnergyStorage) {
                                IHBMEnergyStorage hbmNeighbourCap = (IHBMEnergyStorage)neighbourCap;
                                if (hbmNeighbourCap.getLongStore() <= energyStorage.getLongStore()) {
                                    batteryPartial = (double)energyStorage.getLongStore() / (double)energyStorage.getLongCapacity();
                                    partialDiff = (long)((double)hbmNeighbourCap.getLongCapacity() * batteryPartial / priorityRatio - (double)hbmNeighbourCap.getLongStore());
                                    if (partialDiff > 0L) {
                                        receivePotential = hbmNeighbourCap.receiveEnergy(finalAmountOutput, true);
                                        receivePotential = Math.min(partialDiff, receivePotential);
                                    } else if (partialDiff < 0L) {
                                        extractPotential = hbmNeighbourCap.extractEnergy(finalAmountInput, true);
                                        extractPotential = Math.min(-partialDiff, extractPotential);
                                    } else if (hbmNeighbourCap.getLongStore() == 0L) {
                                        receivePotential = hbmNeighbourCap.receiveEnergy(finalAmountOutput, true);
                                        long idealPartial = (long)((double)energyStorage.getLongStore() * ((double)energyStorage.getLongStore() / (double)(hbmNeighbourCap.getLongCapacity() + energyStorage.getLongCapacity())));
                                        receivePotential = Math.min(idealPartial, receivePotential);
                                    }
                                } else {
                                    energyDiff = hbmNeighbourCap.getLongStore() - energyStorage.getLongStore();
                                    extractPotential = hbmNeighbourCap.extractEnergy(finalAmountInput, true);
                                    extractPotential = Math.min(energyDiff / 2L, extractPotential);
                                }
                            } else if (neighbourCap.getEnergyStored() <= energyStorage.getEnergyStored()) {
                                batteryPartial = (double)energyStorage.getEnergyStored() / (double)energyStorage.getEnergyStored();
                                partialDiff = (long)((double)neighbourCap.getMaxEnergyStored() * batteryPartial / priorityRatio - (double)neighbourCap.getMaxEnergyStored());
                                if (partialDiff > 0L) {
                                    receivePotential = neighbourCap.receiveEnergy(MthHelper.long2int(finalAmountOutput), true);
                                    receivePotential = Math.min(partialDiff, receivePotential);
                                } else if (partialDiff < 0L) {
                                    extractPotential = neighbourCap.extractEnergy(MthHelper.long2int(finalAmountInput), true);
                                    extractPotential = Math.min(-partialDiff, extractPotential);
                                } else if (neighbourCap.getEnergyStored() == 0) {
                                    receivePotential = neighbourCap.receiveEnergy(MthHelper.long2int(finalAmountInput), true);
                                    long idealPartial = (long)((double)energyStorage.getEnergyStored() * ((double)energyStorage.getMaxEnergyStored() / (double)(neighbourCap.getMaxEnergyStored() + energyStorage.getMaxEnergyStored())));
                                    receivePotential = Math.min(idealPartial, receivePotential);
                                }
                            } else {
                                energyDiff = (long)neighbourCap.getEnergyStored() - energyStorage.getLongStore();
                                extractPotential = neighbourCap.extractEnergy(MthHelper.long2int(finalAmountInput), true);
                                extractPotential = Math.min(energyDiff / 2L, extractPotential);
                            }
                        }
                        energyInteract.put(neighbourCap, new Tuple((Object)extractPotential, (Object)receivePotential));
                    });
                });
            }
            if (energyInteract.isEmpty()) {
                return;
            }
            long extractPotentialSum = energyInteract.values().stream().mapToLong(Tuple::m_14418_).reduce(Long::sum).orElse(0L);
            long receivePotentialSum = energyInteract.values().stream().mapToLong(Tuple::m_14419_).reduce(Long::sum).orElse(0L);
            amountInput = Math.min(amountInput, extractPotentialSum);
            amountOutput = Math.min(amountOutput, receivePotentialSum);
            long realExtract = 0L;
            long realReceive = 0L;
            for (Map.Entry entry : energyInteract.entrySet()) {
                IHBMEnergyStorage hbmEnergySource;
                long amount;
                IEnergyStorage energySource = (IEnergyStorage)entry.getKey();
                Tuple tuple = (Tuple)entry.getValue();
                if ((Long)tuple.m_14418_() > 0L) {
                    if (extractPotentialSum == 0L) continue;
                    amount = amountInput * (Long)tuple.m_14418_() / extractPotentialSum;
                    if (energySource instanceof IHBMEnergyStorage) {
                        hbmEnergySource = (IHBMEnergyStorage)energySource;
                        realExtract += hbmEnergySource.extractEnergy(amount, false);
                        continue;
                    }
                    realExtract += (long)energySource.extractEnergy(MthHelper.long2int(amount), false);
                    continue;
                }
                if (receivePotentialSum == 0L) continue;
                amount = amountOutput * (Long)tuple.m_14419_() / receivePotentialSum;
                if (energySource instanceof IHBMEnergyStorage) {
                    hbmEnergySource = (IHBMEnergyStorage)energySource;
                    realReceive += hbmEnergySource.receiveEnergy(amount, false);
                    continue;
                }
                realReceive += (long)energySource.receiveEnergy(MthHelper.long2int(amount), false);
            }
            if (realReceive > realExtract) {
                energyStorage.extractEnergy(realReceive, false);
            } else {
                energyStorage.receiveEnergy(realExtract, false);
            }
        });
    }

    public static void dischargeItem(BlockEntity pBlockEntity, ItemStack itemStack) {
        if (itemStack.m_204117_(ModTags.Items.BATTERY)) {
            pBlockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(cap -> itemStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(itemCap -> {
                long amountCharge;
                IHBMEnergyStorage energyStorage = (IHBMEnergyStorage)cap;
                long amountInput = energyStorage.getMaxInput();
                if (itemCap instanceof IHBMEnergyStorage) {
                    IHBMEnergyStorage hbmItemCap = (IHBMEnergyStorage)itemCap;
                    amountCharge = hbmItemCap.extractEnergy(amountInput, true);
                } else {
                    amountCharge = itemCap.extractEnergy(MthHelper.long2int(amountInput), true);
                }
                itemCap.extractEnergy(MthHelper.long2int(energyStorage.receiveEnergy(amountCharge, false)), false);
            }));
        }
    }

    public static void chargeItem(BlockEntity pBlockEntity, ItemStack itemStack) {
        if (itemStack.m_204117_(ModTags.Items.CHARGEABLE)) {
            pBlockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(cap -> itemStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(itemCap -> {
                long amountCharge;
                IHBMEnergyStorage energyStorage = (IHBMEnergyStorage)cap;
                long amountOutput = energyStorage.getMaxOutput();
                if (itemCap instanceof IHBMEnergyStorage) {
                    IHBMEnergyStorage hbmItemCap = (IHBMEnergyStorage)itemCap;
                    amountCharge = hbmItemCap.receiveEnergy(amountOutput, true);
                } else {
                    amountCharge = itemCap.receiveEnergy(MthHelper.long2int(amountOutput), true);
                }
                itemCap.receiveEnergy(MthHelper.long2int(energyStorage.extractEnergy(amountCharge, false)), false);
            }));
        }
    }
}

