/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api.fluid;

import com.hbm.api.Mode;
import com.hbm.api.fluid.IExtendedFluidHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class BasicFluidHandler
implements IExtendedFluidHandler,
INBTSerializable<CompoundTag> {
    List<FluidTank> tanks = new ArrayList<FluidTank>();
    List<Mode> tankModes = new ArrayList<Mode>();

    public BasicFluidHandler() {
    }

    public BasicFluidHandler(int tankNum, int capacity) {
        for (int i = 0; i < tankNum; ++i) {
            this.tanks.add(new FluidTank(capacity));
            this.tankModes.add(Mode.BOTH);
        }
    }

    public BasicFluidHandler setMode(int tank, Mode mode) {
        if (tank >= 0 && tank <= this.tanks.size()) {
            this.tankModes.set(tank, mode);
        }
        return this;
    }

    public BasicFluidHandler setModes(Mode mode, int ... tankCodes) {
        for (int tankCode : tankCodes) {
            this.setMode(tankCode, mode);
        }
        return this;
    }

    public BasicFluidHandler addTank(int capacity, Mode mode) {
        this.tanks.add(new FluidTank(capacity));
        this.tankModes.add(mode);
        return this;
    }

    public BasicFluidHandler addTanks(int num, int capacity, Mode mode) {
        for (int i = 0; i < num; ++i) {
            this.addTank(capacity, mode);
        }
        return this;
    }

    @Override
    public List<FluidTank> getFluidTanks() {
        return this.tanks;
    }

    @Override
    public Mode getMode(int tank) {
        return this.tankModes.get(tank);
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        int length = this.tanks.size();
        compoundTag.m_128405_("nums", length);
        for (int i = 0; i < length; ++i) {
            CompoundTag tag = this.tanks.get(i).writeToNBT(new CompoundTag());
            tag.m_128405_("mode", this.tankModes.get(i).ordinal());
            compoundTag.m_128365_(String.valueOf(i), (Tag)tag);
        }
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        int length = nbt.m_128451_("nums");
        for (int i = 0; i < length; ++i) {
            CompoundTag tag = nbt.m_128469_(String.valueOf(i));
            this.tanks.get(i).readFromNBT(tag);
            this.tankModes.set(i, Mode.values()[nbt.m_128451_("mode")]);
        }
    }

    public ItemStack drainItem(int tank, ItemStack itemStack) {
        if (itemStack.m_41619_() || !this.allowInput(0)) {
            return itemStack;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)item;
            int bucketVolume = 1000;
            FluidStack fluidStack = new FluidStack(bucketItem.getFluid(), bucketVolume);
            if (this.isFluidValid(tank, fluidStack) && this.tanks.get(tank).fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) == bucketVolume) {
                this.tanks.get(tank).fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                return Items.f_42446_.m_7968_();
            }
            return itemStack;
        }
        return itemStack;
    }

    public ItemStack fillItem(int tank, ItemStack itemStack) {
        if (itemStack.m_41619_() || !this.allowOutput(0)) {
            return itemStack;
        }
        if (itemStack.m_150930_(Items.f_42446_)) {
            int bucketVolume = 1000;
            if (this.tanks.get(tank).drain(bucketVolume, IFluidHandler.FluidAction.SIMULATE).getAmount() == bucketVolume) {
                FluidStack fluidStack = this.tanks.get(tank).drain(bucketVolume, IFluidHandler.FluidAction.EXECUTE);
                return fluidStack.getFluid().m_6859_().m_7968_();
            }
        }
        return itemStack;
    }
}

