/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api.fluid;

import com.hbm.api.fluid.IExtendedFluidTank;
import com.hbm.api.fluid.ISidedFluidHandler;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidUtils {
    public static ItemStack absorbFromItem(BlockEntity pBlockEntity, int tank, ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return itemStack;
        }
        IFluidHandler fluidHandler = (IFluidHandler)pBlockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (fluidHandler != null) {
            if (fluidHandler instanceof ISidedFluidHandler) {
                ISidedFluidHandler sidedFluidHandler = (ISidedFluidHandler)fluidHandler;
                Item item = itemStack.m_41720_();
                if (item instanceof BucketItem) {
                    BucketItem bucket = (BucketItem)item;
                    IExtendedFluidTank fluidTank = sidedFluidHandler.getFluidTank(tank, null);
                    if (fluidTank.fill(new FluidStack(bucket.getFluid(), 1000), IFluidHandler.FluidAction.SIMULATE) == 1000) {
                        fluidTank.fill(new FluidStack(bucket.getFluid(), 1000), IFluidHandler.FluidAction.SIMULATE);
                        return Items.f_42446_.m_7968_();
                    }
                    return ItemStack.f_41583_;
                }
            } else {
                Item fluidTank = itemStack.m_41720_();
                if (fluidTank instanceof BucketItem) {
                    BucketItem bucket = (BucketItem)fluidTank;
                    FluidStack fluidInTank = fluidHandler.getFluidInTank(tank);
                    if (fluidInTank.getFluid().m_6212_(bucket.getFluid()) || fluidInTank.isEmpty()) {
                        if (fluidHandler.fill(new FluidStack(bucket.getFluid(), 1000), IFluidHandler.FluidAction.SIMULATE) == 1000) {
                            fluidHandler.fill(new FluidStack(bucket.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
                            return Items.f_42446_.m_7968_();
                        }
                        return ItemStack.f_41583_;
                    }
                    return ItemStack.f_41583_;
                }
            }
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack pourToItem(BlockEntity pBlockEntity, int tank, ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return itemStack;
        }
        IFluidHandler fluidHandler = (IFluidHandler)pBlockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (fluidHandler != null) {
            if (fluidHandler instanceof ISidedFluidHandler) {
                ISidedFluidHandler sidedFluidHandler = (ISidedFluidHandler)fluidHandler;
                if (itemStack.m_150930_(Items.f_42446_) && sidedFluidHandler.drain(tank, 1000, IFluidHandler.FluidAction.SIMULATE).getAmount() == 1000) {
                    FluidStack fluidStack = sidedFluidHandler.drain(tank, 1000, IFluidHandler.FluidAction.EXECUTE);
                    return fluidStack.getFluid().m_6859_().m_7968_();
                }
            } else if (itemStack.m_150930_(Items.f_42446_) && fluidHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE).getAmount() == 1000) {
                FluidStack fluidStack = fluidHandler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                return fluidStack.getFluid().m_6859_().m_7968_();
            }
        }
        return itemStack;
    }

    public static int getAmount(ICapabilityProvider provider) {
        return FluidUtils.getFluid(provider).getAmount();
    }

    public static FluidStack getFluid(ICapabilityProvider provider) {
        IFluidHandler fluidHandler = (IFluidHandler)provider.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (fluidHandler != null) {
            return fluidHandler.getFluidInTank(0);
        }
        return FluidStack.EMPTY;
    }

    public static FluidStack absorbOnly(ICapabilityProvider provider, int amount) {
        return FluidUtils.absorbOnly(provider, amount, true);
    }

    public static FluidStack absorbOnly(ICapabilityProvider provider, int amount, boolean allowPartial) {
        IFluidHandler fluidHandler = (IFluidHandler)provider.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (fluidHandler != null) {
            if (allowPartial) {
                return fluidHandler.drain(amount, IFluidHandler.FluidAction.EXECUTE);
            }
            if (!allowPartial && fluidHandler.drain(amount, IFluidHandler.FluidAction.SIMULATE).getAmount() == amount) {
                return fluidHandler.drain(amount, IFluidHandler.FluidAction.EXECUTE);
            }
        }
        return FluidStack.EMPTY;
    }
}

