/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api.fluid;

import com.hbm.api.Mode;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public interface IExtendedFluidHandler
extends IFluidHandler {
    public List<FluidTank> getFluidTanks();

    public Mode getMode(int var1);

    default public boolean allowInput(int tank) {
        Mode mode = this.getMode(tank);
        return tank >= 0 && tank < this.getTanks() && (mode == Mode.INPUT || mode == Mode.BOTH);
    }

    default public boolean allowOutput(int tank) {
        Mode mode = this.getMode(tank);
        return tank >= 0 && tank < this.getTanks() && (mode == Mode.OUTPUT || mode == Mode.BOTH);
    }

    default public int getTanks() {
        return this.getFluidTanks().size();
    }

    @NotNull
    default public FluidStack getFluidInTank(int tank) {
        return tank >= 0 && tank < this.getTanks() ? this.getFluidTanks().get(tank).getFluid() : FluidStack.EMPTY;
    }

    default public int getTankCapacity(int tank) {
        return tank >= 0 && tank < this.getTanks() ? this.getFluidTanks().get(tank).getCapacity() : 0;
    }

    default public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        if (!this.allowInput(tank)) {
            return false;
        }
        FluidTank fluidTank = this.getFluidTanks().get(tank);
        return fluidTank.isFluidValid(stack) && (fluidTank.isEmpty() || fluidTank.getFluid().isFluidEqual(stack)) && fluidTank.getSpace() != 0;
    }

    default public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int amount = resource.getAmount();
        List<FluidTank> tanks = this.getFluidTanks();
        IntArrayList typeMatchedTanks = new IntArrayList();
        IntArrayList emptyTanks = new IntArrayList();
        for (int i = 0; i < tanks.size(); ++i) {
            if (!this.isFluidValid(i, resource)) continue;
            if (tanks.get(i).isEmpty()) {
                emptyTanks.add(i);
                continue;
            }
            if (!tanks.get(i).isFluidValid(resource)) continue;
            typeMatchedTanks.add(i);
        }
        for (Integer tank : typeMatchedTanks) {
            if (resource.isEmpty()) continue;
            resource.shrink(tanks.get(tank).fill(resource, action));
        }
        for (Integer tank : emptyTanks) {
            if (resource.isEmpty()) continue;
            resource.shrink(tanks.get(tank).fill(resource, action));
        }
        return amount - resource.getAmount();
    }

    @NotNull
    default public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int drainAmount = 0;
        List<FluidTank> tanks = this.getFluidTanks();
        for (int i = 0; i < tanks.size(); ++i) {
            FluidTank tank = tanks.get(i);
            if (tank != null && this.allowOutput(i) && tank.getFluid().isFluidEqual(resource)) {
                drainAmount += tank.drain(resource.getAmount() - drainAmount, action).getAmount();
            }
            if (drainAmount == resource.getAmount()) break;
        }
        FluidStack resultStack = resource.copy();
        resultStack.setAmount(drainAmount);
        return resultStack;
    }

    @NotNull
    default public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack resultStack = FluidStack.EMPTY;
        List<FluidTank> tanks = this.getFluidTanks();
        for (int i = 0; i < tanks.size(); ++i) {
            FluidTank tank = tanks.get(i);
            if (tank == null || !this.allowOutput(i) || tank.isEmpty() || !resultStack.isEmpty() && !tank.getFluid().isFluidEqual(resultStack)) continue;
            FluidStack drainStack = tank.drain(maxDrain, action);
            if (resultStack.isEmpty()) {
                resultStack = drainStack;
            } else {
                resultStack.grow(drainStack.getAmount());
            }
            if ((maxDrain -= drainStack.getAmount()) == 0) break;
        }
        return resultStack;
    }
}

