/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api.fluid;

import com.hbm.api.fluid.IExtendedFluidTank;
import com.hbm.api.interferences.IDefaultFacing;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ISidedFluidHandler<T extends IExtendedFluidTank>
extends IFluidHandler,
IDefaultFacing {
    default public boolean canHandleFluid() {
        return true;
    }

    public List<T> getFluidTanks(@Nullable Direction var1);

    default public int getTanks() {
        return this.getFluidTanks(null).size();
    }

    @Nullable
    default public IExtendedFluidTank getFluidTank(int tank, @Nullable Direction side) {
        List<T> tanks = this.getFluidTanks(side);
        return tank >= 0 && tank < tanks.size() ? (IExtendedFluidTank)tanks.get(tank) : null;
    }

    @NotNull
    default public FluidStack getFluidInTank(int tank, @Nullable Direction side) {
        List<T> tanks = this.getFluidTanks(side);
        return tank >= 0 && tank < tanks.size() ? ((IExtendedFluidTank)tanks.get(tank)).getFluid() : FluidStack.EMPTY;
    }

    @NotNull
    default public FluidStack getFluidInTank(int tank) {
        return this.getFluidInTank(tank, null);
    }

    default public void setFluidInTank(int tank, FluidStack stack, @Nullable Direction side) {
        IExtendedFluidTank fluidTank = this.getFluidTank(tank, side);
        if (fluidTank != null) {
            fluidTank.setStack(stack);
        }
    }

    default public void setFluidInTank(int tank, FluidStack stack) {
        this.setFluidInTank(tank, stack, null);
    }

    default public int getTankCapacity(int tank, @Nullable Direction side) {
        IExtendedFluidTank fluidTank = this.getFluidTank(tank, side);
        return fluidTank != null ? fluidTank.getCapacity() : 0;
    }

    default public int getTankCapacity(int tank) {
        return this.getTankCapacity(tank, null);
    }

    default public boolean isFluidValid(int tank, @NotNull FluidStack stack, @Nullable Direction side) {
        IExtendedFluidTank fluidTank = this.getFluidTank(tank, side);
        return fluidTank != null && fluidTank.isFluidValid(stack);
    }

    default public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.isFluidValid(tank, stack, null);
    }

    default public int fill(int tank, FluidStack resource, IFluidHandler.FluidAction action, @Nullable Direction side) {
        IExtendedFluidTank fluidTank = this.getFluidTank(tank, side);
        return fluidTank == null ? 0 : fluidTank.fill(resource, action);
    }

    default public int fill(int tank, FluidStack resource, IFluidHandler.FluidAction action) {
        return this.fill(tank, resource, action, null);
    }

    default public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int amount = resource.getAmount();
        List<T> tanks = this.getFluidTanks(null);
        IntArrayList typeMatchTanks = new IntArrayList();
        IntArrayList emptyTanks = new IntArrayList();
        for (int i = 0; i < tanks.size(); ++i) {
            Object tank = (IExtendedFluidTank)tanks.get(i);
            if (tank == null) continue;
            if (tank.getFluid().isEmpty()) {
                emptyTanks.add(i);
                continue;
            }
            if (!tank.isFluidValid(resource)) continue;
            typeMatchTanks.add(i);
        }
        for (Object tank : typeMatchTanks) {
            if (resource.isEmpty()) continue;
            resource.shrink(((IExtendedFluidTank)tanks.get((Integer)tank)).fill(resource, action));
        }
        for (Object tank : emptyTanks) {
            if (resource.isEmpty()) continue;
            resource.shrink(((IExtendedFluidTank)tanks.get((Integer)tank)).fill(resource, action));
        }
        return amount - resource.getAmount();
    }

    default public FluidStack drain(int tank, int maxDrain, IFluidHandler.FluidAction action, @Nullable Direction side) {
        IExtendedFluidTank fluidTank = this.getFluidTank(tank, side);
        return fluidTank == null ? FluidStack.EMPTY : fluidTank.drain(maxDrain, action);
    }

    default public FluidStack drain(int tank, int maxDrain, IFluidHandler.FluidAction action) {
        return this.drain(tank, maxDrain, action, null);
    }

    @NotNull
    default public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack resultStack = FluidStack.EMPTY;
        List<T> tanks = this.getFluidTanks(null);
        for (IExtendedFluidTank tank : tanks) {
            if (tank == null || tank.getFluid().isEmpty() || !resultStack.isEmpty() && !tank.isFluidValid(resultStack)) continue;
            FluidStack drainStack = tank.drain(maxDrain, action);
            if (resultStack.isEmpty()) {
                resultStack = drainStack;
            } else {
                resultStack.grow(drainStack.getAmount());
            }
            if ((maxDrain -= drainStack.getAmount()) != 0) continue;
            break;
        }
        return resultStack;
    }

    @NotNull
    default public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int drainAmount = 0;
        List<T> tanks = this.getFluidTanks(null);
        for (IExtendedFluidTank tank : tanks) {
            if (tank != null && tank.isFluidValid(resource)) {
                drainAmount += tank.drain(resource.getAmount() - drainAmount, action).getAmount();
            }
            if (drainAmount != resource.getAmount()) continue;
            break;
        }
        FluidStack resultStack = resource.copy();
        resultStack.setAmount(drainAmount);
        return resultStack;
    }
}

