/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api.fluid;

import com.hbm.api.IContentsListener;
import com.hbm.api.Mode;
import com.hbm.api.fluid.BasicFluidTank;
import com.hbm.api.fluid.SingleFluidHandler;
import com.hbm.capabilities.ItemCapabilityWrapper;
import com.hbm.capabilities.resolver.BasicCapabilityResolver;
import com.hbm.capabilities.resolver.ICapabilityResolver;
import com.hbm.utils.ItemDataUtils;
import java.util.function.Consumer;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class ItemStackFluidHandler
extends ItemCapabilityWrapper.ItemCapability
implements IContentsListener {
    protected BasicFluidTank fluidTank = null;

    public ItemStackFluidHandler(int capacity, int input, int output) {
        this(capacity, input, output, null);
    }

    public ItemStackFluidHandler(int capacity, int input, int output, @Nullable Fluid fluid) {
        this(new BasicFluidTank(capacity, input, output));
        if (fluid != null) {
            this.fluidTank.setFluid(new FluidStack(fluid, capacity));
        }
    }

    public ItemStackFluidHandler(BasicFluidTank fluidTank) {
        this.fluidTank = fluidTank;
        this.fluidTank.setListener(this);
    }

    @Override
    protected void gatherCapabilityResolvers(Consumer<ICapabilityResolver> consumer) {
        consumer.accept(new BasicCapabilityResolver(() -> new SingleFluidHandler(this.fluidTank, Mode.BOTH), ForgeCapabilities.FLUID_HANDLER));
    }

    @Override
    protected void load() {
        super.load();
        ItemDataUtils.readContainers(this.getStack(), "fluids", this.fluidTank);
        this.saveDamageValue();
    }

    @Override
    public void onContentsChanged() {
        ItemDataUtils.writeContainers(this.getStack(), "fluids", this.fluidTank);
        this.saveDamageValue();
    }

    private void saveDamageValue() {
        if (this.getStack().m_41763_()) {
            this.getStack().m_41721_((int)((1.0f - this.fluidTank.getPercent()) * (float)this.getStack().m_41776_()));
        }
    }
}

