/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api.fluid;

import com.hbm.api.Mode;
import com.hbm.api.fluid.BasicFluidTank;
import com.hbm.api.fluid.IExtendedFluidHandler;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class SingleFluidHandler
implements IExtendedFluidHandler,
INBTSerializable<CompoundTag> {
    FluidTank tank;
    Mode mode;

    public SingleFluidHandler(int capacity) {
        this(capacity, Mode.BOTH);
    }

    public SingleFluidHandler(int capacity, Mode mode) {
        this(new BasicFluidTank(capacity), mode);
    }

    public SingleFluidHandler(FluidTank tank, Mode mode) {
        this.tank = tank;
        this.mode = mode;
    }

    @Override
    public List<FluidTank> getFluidTanks() {
        return List.of(this.tank);
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public Mode getMode(int tank) {
        return tank == 0 ? this.mode : Mode.NONE;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = this.tank.writeToNBT(new CompoundTag());
        tag.m_128405_("mode", this.mode.ordinal());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.tank.readFromNBT(nbt);
        this.mode = Mode.values()[nbt.m_128451_("mode")];
    }

    public ItemStack drainItem(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return itemStack;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)item;
            int bucketVolume = 1000;
            FluidStack fluidStack = new FluidStack(bucketItem.getFluid(), bucketVolume);
            if (this.tank.isFluidValid(0, fluidStack) && this.tank.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) == bucketVolume) {
                this.tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                return Items.f_42446_.m_7968_();
            }
            return itemStack;
        }
        return itemStack;
    }

    public ItemStack fillItem(ItemStack itemStack) {
        int bucketVolume;
        if (itemStack.m_41619_()) {
            return itemStack;
        }
        if (itemStack.m_150930_(Items.f_42446_) && this.tank.drain(bucketVolume = 1000, IFluidHandler.FluidAction.SIMULATE).getAmount() == bucketVolume) {
            FluidStack fluidStack = this.tank.drain(bucketVolume, IFluidHandler.FluidAction.EXECUTE);
            return fluidStack.getFluid().m_6859_().m_7968_();
        }
        return itemStack;
    }
}

