/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api.fluid;

import com.hbm.api.Mode;
import com.hbm.api.fluid.IExtendedFluidHandler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class VisitRestrictWrapper
implements IExtendedFluidHandler {
    IExtendedFluidHandler fluidHandler;
    Set<Integer> accessibleTanks = new HashSet<Integer>();

    public VisitRestrictWrapper(IExtendedFluidHandler fluidHandler, boolean inputNoCheck, int ... tanks) {
        this.fluidHandler = fluidHandler;
        if (inputNoCheck) {
            for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                if (!this.fluidHandler.allowInput(i)) continue;
                this.accessibleTanks.add(i);
            }
            this.accessibleTanks.addAll(Arrays.stream(tanks).boxed().collect(Collectors.toSet()));
        } else {
            this.accessibleTanks = Arrays.stream(tanks).boxed().collect(Collectors.toSet());
        }
    }

    public VisitRestrictWrapper(IExtendedFluidHandler fluidHandler, int ... tanks) {
        this(fluidHandler, true, tanks);
    }

    @Override
    public List<FluidTank> getFluidTanks() {
        return this.fluidHandler.getFluidTanks();
    }

    @Override
    public Mode getMode(int tank) {
        return this.accessibleTanks.contains(tank) ? this.fluidHandler.getMode(tank) : Mode.NONE;
    }
}

