/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api.inventory;

import com.hbm.api.Mode;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public interface IExtendedItemHandler
extends IItemHandlerModifiable {
    public List<ItemStack> getItems();

    public Mode getMode(int var1);

    default public int getSlots() {
        return this.getItems().size();
    }

    default public boolean allowInput(int slot) {
        Mode mode = this.getMode(slot);
        return slot >= 0 && slot < this.getSlots() && (mode == Mode.INPUT || mode == Mode.BOTH);
    }

    default public boolean allowOutput(int slot) {
        Mode mode = this.getMode(slot);
        return slot >= 0 && slot < this.getSlots() && (mode == Mode.OUTPUT || mode == Mode.BOTH);
    }

    @NotNull
    default public ItemStack getStackInSlot(int slot) {
        return slot >= 0 && slot < this.getSlots() ? this.getItems().get(slot) : ItemStack.f_41583_;
    }

    default public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        if (slot >= 0 && slot < this.getSlots()) {
            this.getItems().set(slot, stack);
        }
    }

    default public int getSlotLimit(int slot) {
        return this.getStackInSlot(slot).m_41741_();
    }

    default public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        ItemStack itemStack = this.getItems().get(slot);
        return itemStack.m_41619_() || ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)stack) && itemStack.m_41613_() < this.getSlotLimit(slot);
    }

    @NotNull
    default public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return this.insertNoCheck(slot, stack, simulate);
    }

    @NotNull
    default public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.extractNoCheck(slot, amount, simulate);
    }

    @NotNull
    default public ItemStack insertNoCheck(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        ItemStack beforeStack = this.getStackInSlot(slot);
        int toAdd = Math.min(stack.m_41613_(), this.getSlotLimit(slot) - beforeStack.m_41613_());
        if (!simulate) {
            if (beforeStack.m_41619_()) {
                beforeStack = stack;
            } else {
                beforeStack.m_41769_(toAdd);
            }
            this.setStackInSlot(slot, beforeStack);
        }
        return stack.m_41613_() - toAdd == 0 ? ItemStack.f_41583_ : stack.m_255036_(stack.m_41613_() - toAdd);
    }

    @NotNull
    default public ItemStack extractNoCheck(int slot, int amount, boolean simulate) {
        if (this.getStackInSlot(slot).m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack beforeStack = this.getStackInSlot(slot);
        int toSubtract = Math.min(amount, beforeStack.m_41613_());
        if (!simulate) {
            beforeStack.m_41774_(toSubtract);
        }
        return toSubtract == 0 ? ItemStack.f_41583_ : beforeStack.m_255036_(toSubtract);
    }
}

