/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api.inventory;

import com.hbm.api.annotations.NothingNullByDefault;
import com.hbm.api.interferences.IDefaultFacing;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface ISidedItemHandler
extends IItemHandlerModifiable,
IDefaultFacing {
    default public List<ItemStack> getItems() {
        return List.of();
    }

    default public boolean slotIOCtl(int slot, @Nullable ItemStack pStack, boolean isInput) {
        return true;
    }

    default public int getSlots(@Nullable Direction side) {
        return this.getSlots();
    }

    default public int getSlots() {
        return this.getItems().size();
    }

    default public ItemStack getStackInSlot(int slot, @Nullable Direction side) {
        return this.getStackInSlot(slot);
    }

    default public ItemStack getStackInSlot(int slot) {
        return slot >= 0 && slot < this.getSlots() ? this.getItems().get(slot) : ItemStack.f_41583_;
    }

    default public ItemStack setStackInSlot(int slot, ItemStack stack, @Nullable Direction side) {
        if (slot >= 0 && slot < this.getSlots()) {
            ItemStack beforeStack = this.getItems().get(slot);
            this.getItems().set(slot, stack);
            return beforeStack;
        }
        return ItemStack.f_41583_;
    }

    default public void setStackInSlot(int slot, ItemStack stack) {
        this.setStackInSlot(slot, stack, null);
    }

    default public ItemStack insertItem(int slot, ItemStack stack, @Nullable Direction side, boolean simulate) {
        if (side != null && this.slotIOCtl(slot, stack, true)) {
            return stack;
        }
        ItemStack beforeStack = this.getStackInSlot(slot);
        boolean sameType = false;
        if (stack.m_41619_() || !(sameType = ItemHandlerHelper.canItemStacksStack((ItemStack)beforeStack, (ItemStack)stack))) {
            return stack;
        }
        int needed = this.getSlotLimit(slot) - beforeStack.m_41613_();
        if (needed <= 0) {
            return stack;
        }
        int toAdd = Math.min(stack.m_41613_(), needed);
        if (!simulate) {
            beforeStack.m_41769_(toAdd);
        }
        return stack.m_255036_(stack.m_41613_() - toAdd);
    }

    default public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.insertItem(slot, stack, null, simulate);
    }

    default public ItemStack extractItem(int slot, int amount, @Nullable Direction side, boolean simulate) {
        ItemStack result = ItemStack.f_41583_;
        if (side != null && this.slotIOCtl(slot, null, false) || amount <= 0) {
            return result;
        }
        ItemStack originStack = this.getStackInSlot(slot);
        if (originStack.m_41619_()) {
            return result;
        }
        int extAmount = Math.min(amount, originStack.m_41613_());
        result = originStack.m_255036_(extAmount);
        if (!simulate) {
            originStack.m_41774_(extAmount);
            if (originStack.m_41619_()) {
                this.setStackInSlot(slot, ItemStack.f_41583_);
            } else {
                this.setStackInSlot(slot, originStack);
            }
        }
        return result;
    }

    default public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.extractItem(slot, amount, null, simulate);
    }

    default public int getSlotLimit(int slot, @Nullable Direction side) {
        if (slot < 0 || slot >= this.getSlots()) {
            return 0;
        }
        return Math.min(64, this.getStackInSlot(slot).m_41741_());
    }

    default public int getSlotLimit(int slot) {
        return this.getSlotLimit(slot, null);
    }

    default public boolean isItemValid(int slot, ItemStack stack, @Nullable Direction side) {
        if (side != null && this.slotIOCtl(slot, stack, true)) {
            return false;
        }
        if (slot < 0 || slot >= this.getSlots()) {
            return false;
        }
        return this.getStackInSlot(slot).m_150930_(stack.m_41720_());
    }

    default public boolean isItemValid(int slot, ItemStack stack) {
        return this.isItemValid(slot, stack, null);
    }

    default public boolean inventoryEmpty() {
        for (ItemStack itemStack : this.getItems()) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }
}

