/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api.inventory;

public interface SlotAccCtl {
    public static final SlotAccCtl EMPTY = new SlotAccCtl(){

        @Override
        public int getSlot() {
            return -1;
        }
    };

    public int getSlot();

    default public boolean allowIn() {
        return true;
    }

    default public boolean allowOut() {
        return true;
    }

    default public int in() {
        return this.allowIn() ? Integer.MAX_VALUE : 0;
    }

    default public int out() {
        return this.allowOut() ? Integer.MAX_VALUE : 0;
    }

    default public boolean isTrafficLimit() {
        return false;
    }

    public static class SlotAccCtlBase
    implements SlotAccCtl {
        int slot;
        int in = Integer.MAX_VALUE;
        int out = Integer.MAX_VALUE;
        boolean trafficLimit = false;

        SlotAccCtlBase(int slot) {
            this.slot = slot;
        }

        SlotAccCtlBase(int slot, boolean in, boolean out) {
            this.slot = slot;
            if (!in) {
                this.in = 0;
            }
            if (!out) {
                this.out = 0;
            }
        }

        SlotAccCtlBase(int slot, int in, int out) {
            this.slot = slot;
            this.in = in;
            this.out = out;
            this.trafficLimit = true;
        }

        @Override
        public int getSlot() {
            return this.slot;
        }

        @Override
        public boolean allowIn() {
            return this.in > 0;
        }

        @Override
        public boolean allowOut() {
            return this.out > 0;
        }

        @Override
        public int in() {
            return this.in;
        }

        @Override
        public int out() {
            return this.out;
        }

        @Override
        public boolean isTrafficLimit() {
            return this.trafficLimit;
        }
    }
}

