/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.block;

import com.hbm.HBM;
import com.hbm.block.HBMMachine;
import com.hbm.block.decoriate.BlockOre;
import com.hbm.block.env.BedRockOre;
import com.hbm.block.env.WasteEarth;
import com.hbm.block.env.WasteLeaves;
import com.hbm.datagen.LanguageProvider;
import com.hbm.datagen.loot.BlockLootGen;
import com.hbm.datagen.model.BlockStateGen;
import com.hbm.registries.ModBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class HBMBlockComponent {
    private static final List<RegistryObject<Block>> matherialList = new ArrayList<RegistryObject<Block>>();
    private static final Set<RegistryObject<Block>> modelSpecialSet = new HashSet<RegistryObject<Block>>();
    public static RegistryObject<Block> STEEL_BLOCK;
    public static RegistryObject<Block> PLASTIC_BARREL;
    public static RegistryObject<Block> SELLAFIELD_SLAKED;
    public static RegistryObject<Block> WAST_LEAVES;
    public static RegistryObject<Block> WAST_EARTH;
    public static RegistryObject<Block> URANIUM_ORE;
    public static RegistryObject<Block> DEEPSLATE_URANIUM_ORE;
    public static RegistryObject<Block> SCORCHED_URANIUM_ORE;
    public static RegistryObject<Block> TITANIUM_ORE;
    public static RegistryObject<Block> THORIUM_ORE;
    public static RegistryObject<Block> NITER_ORE;
    public static RegistryObject<Block> TUNGSTEN_ORE;
    public static RegistryObject<Block> ALUMINIUM_ORE;
    public static RegistryObject<Block> FLUORITE_ORE;
    public static RegistryObject<Block> LEAD_ORE;
    public static RegistryObject<Block> BERYLLIUM_ORE;
    public static RegistryObject<Block> SA326_ORE;
    public static RegistryObject<Block> ASBESTOS_BLOCK;
    public static RegistryObject<Block> ASBESTOS_ORE;
    public static RegistryObject<Block> BASALT_ASBESTOS_ORE;
    public static RegistryObject<Block> OIL_ORE;
    public static RegistryObject<Block> OIL_ORE_EMPTY;
    public static RegistryObject<Block> OIL_ORE_SAND;
    public static RegistryObject<Block> RARE_EARTH_ORE;
    public static RegistryObject<Block> DEEPSLATE_RARE_EARTH_ORE;
    public static RegistryObject<Block> LITHIUM_ORE;
    public static RegistryObject<Block> COBALT_ORE;
    public static RegistryObject<Block> COLTAN_ORE;
    public static RegistryObject<Block> GENISS_GAS_ORE;
    public static RegistryObject<Block> SMOLDER_ORE_NETHER;
    public static RegistryObject<Block> PLUTONIUM_ORE_NETHER;
    public static RegistryObject<Block> FIRE_ORE_NETHER;
    public static RegistryObject<Block> TIKITE_ORE_END;
    public static RegistryObject<Block> BEDROCK_ORE;
    public static RegistryObject<Block> DEPTH_STONE;

    public static void register(DeferredRegister<Block> BLOCKS) {
        STEEL_BLOCK = HBMBlockComponent.registerWithItem("block_steel", () -> new Block(BlockBehaviour.Properties.m_284310_()));
        SELLAFIELD_SLAKED = HBMBlockComponent.registerWithItem("sellafield_slaked", () -> new Block(BlockBehaviour.Properties.m_284310_().m_155956_(5.0f)));
        WAST_LEAVES = HBMBlockComponent.registerWithItem("wast_leaves", () -> new WasteLeaves(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50054_).m_222994_()), true);
        WAST_EARTH = HBMBlockComponent.registerWithItem("wast_earth", () -> new WasteEarth(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50493_)), true);
        URANIUM_ORE = HBMBlockComponent.registerWithItem("ore_uranium", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_)), true);
        DEEPSLATE_URANIUM_ORE = HBMBlockComponent.registerWithItem("ore_deepslate_uranium", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152468_)), true);
        SCORCHED_URANIUM_ORE = HBMBlockComponent.registerWithItem("ore_scorched_uranium", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_)), true);
        TITANIUM_ORE = HBMBlockComponent.registerWithItem("ore_titanium", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_)), true);
        THORIUM_ORE = HBMBlockComponent.registerWithItem("ore_thorium", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_)), true);
        NITER_ORE = HBMBlockComponent.registerWithItem("ore_niter", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_)), true);
        TUNGSTEN_ORE = HBMBlockComponent.registerWithItem("ore_tungsten", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_)), true);
        ALUMINIUM_ORE = HBMBlockComponent.registerWithItem("ore_aluminium", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_)), true);
        FLUORITE_ORE = HBMBlockComponent.registerWithItem("ore_fluorite", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_)), true);
        LEAD_ORE = HBMBlockComponent.registerWithItem("ore_lead", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_)), true);
        BERYLLIUM_ORE = HBMBlockComponent.registerWithItem("ore_beryllium", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_)), true);
        SA326_ORE = HBMBlockComponent.registerWithItem("ore_sa326", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152474_), 0.1f), true);
        ASBESTOS_BLOCK = HBMBlockComponent.registerWithItem("asbestos_block", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_)), true);
        ASBESTOS_ORE = HBMBlockComponent.registerWithItem("ore_asbestos", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_)), true);
        BASALT_ASBESTOS_ORE = HBMBlockComponent.registerWithItem("ore_basalt_asbestos", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50137_)), true);
        OIL_ORE = HBMBlockComponent.registerWithItem("ore_oil", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49995_)), true);
        OIL_ORE_EMPTY = HBMBlockComponent.registerWithItem("oil_ore_empty", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49995_)), true);
        OIL_ORE_SAND = HBMBlockComponent.registerWithItem("oil_ore_sand", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_)), true);
        RARE_EARTH_ORE = HBMBlockComponent.registerWithItem("rare_earth", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49995_)), true);
        DEEPSLATE_RARE_EARTH_ORE = HBMBlockComponent.registerWithItem("ore_deepslate_rare", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152467_)), true);
        LITHIUM_ORE = HBMBlockComponent.registerWithItem("ore_lithium", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_)), true);
        COBALT_ORE = HBMBlockComponent.registerWithItem("ore_cobalt", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_)), true);
        COLTAN_ORE = HBMBlockComponent.registerWithItem("ore_coltan", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_)), true);
        GENISS_GAS_ORE = HBMBlockComponent.registerWithItem("ore_geniss_gas", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_)), true);
        SMOLDER_ORE_NETHER = HBMBlockComponent.registerWithItem("smolder_ore_nether", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50331_)), true);
        PLUTONIUM_ORE_NETHER = HBMBlockComponent.registerWithItem("plutonium_ore_nether", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50331_)), true);
        FIRE_ORE_NETHER = HBMBlockComponent.registerWithItem("fire_ore_nether", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50610_)), true);
        TIKITE_ORE_END = HBMBlockComponent.registerWithItem("tikite_ore_end", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50259_)), true);
        BEDROCK_ORE = HBMBlockComponent.registerWithItem("ore_bedrock", () -> new BedRockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50752_)), true);
        DEPTH_STONE = HBMBlockComponent.registerWithItem("depth_stone", () -> new BlockOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_220863_)), true);
    }

    private static RegistryObject<Block> registerWithItem(String name, Supplier<? extends Block> blocksup) {
        return HBMBlockComponent.registerWithItem(name, blocksup, false);
    }

    private static RegistryObject<Block> registerWithItem(String name, Supplier<? extends Block> blocksup, boolean isModelSpecial) {
        RegistryObject<Block> blockRegistryObject = HBMMachine.registerBlockWithItem(ModBlocks.BLOCKS, name, blocksup);
        matherialList.add(blockRegistryObject);
        if (isModelSpecial) {
            modelSpecialSet.add(blockRegistryObject);
        }
        return blockRegistryObject;
    }

    public static void creativeTab(CreativeModeTab.Output pOutput) {
        matherialList.forEach(blockRegistryObject -> pOutput.m_246326_((ItemLike)blockRegistryObject.get()));
    }

    public static void genModel(BlockStateGen provider) {
        matherialList.forEach(blockRegistryObject -> {
            if (!modelSpecialSet.contains(blockRegistryObject)) {
                provider.simpleBlock((Block)blockRegistryObject.get());
            }
        });
        provider.simpleBlockWithItem((Block)WAST_EARTH.get(), (ModelFile)provider.models().cubeBottomTop(provider.path((Block)WAST_EARTH.get()), HBM.rl("block/env/waste_earth_side"), HBM.rl("block/env/waste_earth_bottom"), HBM.rl("block/env/waste_earth_top")));
        provider.simpleBlockWithItem((Block)WAST_LEAVES.get(), (ModelFile)provider.models().leaves(provider.path((Block)WAST_LEAVES.get()), HBM.rl("block/env/waste_leaves")));
        provider.simpleBlockWithItem((Block)URANIUM_ORE.get(), (ModelFile)provider.models().cubeAll(provider.path((Block)URANIUM_ORE.get()), HBM.rl("block/env/ore_uranium")));
        provider.simpleBlockWithItem((Block)DEEPSLATE_URANIUM_ORE.get(), (ModelFile)provider.models().cubeAll(provider.path((Block)DEEPSLATE_URANIUM_ORE.get()), HBM.rl("block/env/ore_uranium_deepslate")));
        provider.addEnumStateBlock((Block)BEDROCK_ORE.get(), BedRockOre.TYPE, value -> provider.enumModelFileFunction_BedRockOreType((BedRockOre.BedRockOreType)((Object)value)));
        provider.simpleBlockItem((Block)BEDROCK_ORE.get(), (ModelFile)provider.models().cubeAll(provider.path((Block)BEDROCK_ORE.get()), new ResourceLocation("block/bedrock")));
        provider.simpleBlockWithItem((Block)RARE_EARTH_ORE.get(), (ModelFile)provider.models().cubeAll(provider.path((Block)RARE_EARTH_ORE.get()), HBM.rl("block/env/ore_rare")));
        provider.simpleBlockWithItem((Block)DEEPSLATE_RARE_EARTH_ORE.get(), (ModelFile)provider.models().cubeAll(provider.path((Block)DEEPSLATE_RARE_EARTH_ORE.get()), HBM.rl("block/env/ore_rare_deepslate")));
        provider.simpleBlockWithItem((Block)ASBESTOS_BLOCK.get(), (ModelFile)provider.models().cubeAll(provider.path((Block)ASBESTOS_BLOCK.get()), HBM.rl("block/env/block_asbestos")));
        provider.simpleBlockWithItem((Block)ASBESTOS_ORE.get(), (ModelFile)provider.models().cubeAll(provider.path((Block)ASBESTOS_ORE.get()), HBM.rl("block/env/ore_asbestos")));
        provider.simpleBlockWithItem((Block)BASALT_ASBESTOS_ORE.get(), (ModelFile)provider.models().cubeTop(provider.path((Block)BASALT_ASBESTOS_ORE.get()), HBM.rl("block/env/ore_asbestos_basalt"), HBM.rl("block/env/ore_asbestos_basalt_top")));
        provider.simpleBlockWithItem((Block)SA326_ORE.get(), (ModelFile)provider.models().cubeAll(provider.path((Block)SA326_ORE.get()), HBM.rl("block/env/ore_schrabidium")));
        provider.simpleBlockWithItem((Block)LITHIUM_ORE.get(), (ModelFile)provider.models().cubeAll(provider.path((Block)LITHIUM_ORE.get()), HBM.rl("block/env/ore_lithium")));
        provider.simpleBlockWithItem((Block)DEPTH_STONE.get(), (ModelFile)provider.models().cubeAll(provider.path((Block)DEPTH_STONE.get()), HBM.rl("block/env/stone_depth")));
    }

    public static void languageSupport(LanguageProvider provider) {
        matherialList.forEach(blockRegistryObject -> provider.add((Block)blockRegistryObject.get(), Arrays.stream(blockRegistryObject.getId().m_135815_().split("_")).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).reduce("", (r, id) -> r + " " + id)));
    }

    public static void lootable(BlockLootGen provider) {
        provider.m_245724_((Block)STEEL_BLOCK.get());
        provider.m_245724_((Block)SELLAFIELD_SLAKED.get());
        provider.m_246125_((Block)WAST_EARTH.get(), (ItemLike)Blocks.f_50493_);
        provider.m_245724_((Block)URANIUM_ORE.get());
        provider.m_245724_((Block)DEEPSLATE_URANIUM_ORE.get());
        provider.m_245724_((Block)SCORCHED_URANIUM_ORE.get());
        provider.m_245724_((Block)TITANIUM_ORE.get());
        provider.m_245724_((Block)THORIUM_ORE.get());
        provider.m_245724_((Block)NITER_ORE.get());
        provider.m_245724_((Block)TUNGSTEN_ORE.get());
        provider.m_245724_((Block)ALUMINIUM_ORE.get());
        provider.m_245724_((Block)FLUORITE_ORE.get());
        provider.m_245724_((Block)LEAD_ORE.get());
        provider.m_245724_((Block)BERYLLIUM_ORE.get());
        provider.m_245724_((Block)SA326_ORE.get());
        provider.m_245724_((Block)ASBESTOS_BLOCK.get());
        provider.m_245724_((Block)ASBESTOS_ORE.get());
        provider.m_245724_((Block)BASALT_ASBESTOS_ORE.get());
        provider.m_245724_((Block)OIL_ORE.get());
        provider.m_245724_((Block)OIL_ORE_EMPTY.get());
        provider.m_245724_((Block)OIL_ORE_SAND.get());
        provider.m_245724_((Block)RARE_EARTH_ORE.get());
        provider.m_245724_((Block)DEEPSLATE_RARE_EARTH_ORE.get());
        provider.m_245724_((Block)LITHIUM_ORE.get());
        provider.m_245724_((Block)COBALT_ORE.get());
        provider.m_245724_((Block)COLTAN_ORE.get());
        provider.m_245724_((Block)GENISS_GAS_ORE.get());
        provider.m_245724_((Block)SMOLDER_ORE_NETHER.get());
        provider.m_245724_((Block)PLUTONIUM_ORE_NETHER.get());
        provider.m_245724_((Block)FIRE_ORE_NETHER.get());
        provider.m_245724_((Block)TIKITE_ORE_END.get());
        provider.m_245724_((Block)BEDROCK_ORE.get());
        provider.m_245724_((Block)DEPTH_STONE.get());
    }
}

