/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.block.base;

import com.hbm.block.base.BaseMachineBlock;
import com.hbm.blockentity.base.BedLikeBlockEntity;
import com.hbm.blockentity.base.DummibleBlockEntity;
import com.hbm.registries.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class BedLikeBlock
extends BaseMachineBlock {
    int[] offset;

    protected BedLikeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)super.m_5573_(pContext).m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    @Override
    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            List<Vec3i> offsets = BedLikeBlock.transOffsets(this.getOffsets(), (Direction)pState.m_61143_((Property)FACING));
            for (Vec3i offset : offsets) {
                BlockPos pos = pPos.m_121955_(offset);
                if (!pLevel.m_8055_(pos).m_60713_((Block)ModBlocks.DUMMIBLE.get())) continue;
                pLevel.m_7471_(pos, false);
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
        }
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        if (!pLevel.f_46443_) {
            Direction direction = (Direction)pState.m_61143_((Property)FACING);
            if (!this.checkRequirement(pLevel, pPos, direction, this.getOffsets())) {
                pLevel.m_7471_(pPos, false);
                Containers.m_18992_((Level)pLevel, (double)pPos.m_252807_().f_82479_, (double)pPos.m_252807_().f_82480_, (double)pPos.m_252807_().f_82481_, (ItemStack)pStack.m_41720_().m_7968_());
                return;
            }
            this.fillSpace(pLevel, pPos, ((Block)ModBlocks.DUMMIBLE.get()).m_49966_(), direction, this.getOffsets());
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof BedLikeBlockEntity) {
                BedLikeBlockEntity entity = (BedLikeBlockEntity)blockEntity;
                entity.flagFormed = true;
            }
        }
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
    }

    public List<Vec3i> getOffsets() {
        return List.of(new Vec3i(0, 0, 0));
    }

    public int[] getOffset() {
        return new int[]{1, 0, 0, 1, 0, 1};
    }

    protected boolean checkRequirement(Level level, BlockPos blockPos, Direction dir, List<Vec3i> offsets) {
        List<Vec3i> offsets2 = BedLikeBlock.transOffsets(offsets, dir);
        for (Vec3i offset : offsets2) {
            if (level.m_8055_(blockPos.m_121955_(offset)).m_247087_()) continue;
            return false;
        }
        return true;
    }

    protected void fillSpace(Level level, BlockPos blockPos, BlockState blockState, Direction dir, List<Vec3i> offsets) {
        List<Vec3i> offsets2 = BedLikeBlock.transOffsets(offsets, dir);
        for (Vec3i offset : offsets2) {
            level.m_7731_(blockPos.m_121955_(offset), blockState, 3);
            BlockEntity blockEntity = level.m_7702_(blockPos.m_121955_(offset));
            if (!(blockEntity instanceof DummibleBlockEntity)) continue;
            DummibleBlockEntity dummibleBlockEntity = (DummibleBlockEntity)blockEntity;
            dummibleBlockEntity.corePos = new BlockPos((Vec3i)blockPos);
        }
    }

    protected void clearSpace(Level level, BlockPos blockPos, Direction dir, List<Vec3i> offsets) {
        List<Vec3i> offsets2 = BedLikeBlock.transOffsets(offsets, dir);
        for (Vec3i offset : offsets2) {
            level.m_46597_(blockPos.m_121955_(offset), Blocks.f_50016_.m_49966_());
        }
    }

    public static List<Vec3i> transOffsets(List<Vec3i> offsets, Direction dir) {
        ArrayList<Vec3i> result = new ArrayList<Vec3i>(offsets);
        int[] trans = switch (dir) {
            case Direction.NORTH -> new int[]{-1, 0, 0, -1};
            case Direction.EAST -> new int[]{0, -1, 1, 0};
            case Direction.SOUTH -> new int[]{1, 0, 0, 1};
            case Direction.WEST -> new int[]{0, 1, -1, 0};
            default -> new int[]{1, 0, 0, 1};
        };
        for (int i = 0; i < result.size(); ++i) {
            Vec3i v1 = (Vec3i)result.get(i);
            Vec3i v2 = new Vec3i(v1.m_123341_() * trans[0] + v1.m_123343_() * trans[2], v1.m_123342_(), v1.m_123341_() * trans[1] + v1.m_123343_() * trans[3]);
            result.set(i, v2);
        }
        return result;
    }

    @Override
    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public static List<Vec3i> square(int[] dim) {
        ArrayList<Vec3i> offsets = new ArrayList<Vec3i>();
        for (int i = -dim[4]; i <= dim[5]; ++i) {
            for (int j = -dim[1]; j <= dim[0]; ++j) {
                for (int k = -dim[2]; k <= dim[3]; ++k) {
                    if (i == 0 && j == 0 && k == 0) continue;
                    offsets.add(new Vec3i(i, j, k));
                }
            }
        }
        return offsets;
    }

    public static Vec3i square(int n) {
        return new Vec3i(n, n, n);
    }

    public static Vec3i pillar(int width, int height) {
        return new Vec3i(width, height, width);
    }

    public int getHeightOffset() {
        return 0;
    }
}

