/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.block.base;

import com.hbm.HBM;
import com.hbm.block.HBMBlockProperties;
import com.hbm.block.base.BlockMachineBase;
import com.hbm.block.interfaces.ICustomBlockHighlight;
import com.hbm.blockentity.base2.DummyableBlockEntity;
import com.hbm.blockentity.base2.TileProxyBase;
import com.hbm.blockentity.base2.TileProxyCombo;
import com.hbm.utils.DirectionUtils;
import com.hbm.utils.multiblock.DummableHelper;
import com.hbm.utils.multiblock.MultiblockData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHighlightEvent;
import org.jetbrains.annotations.Nullable;

public abstract class BlockDummyable
extends BlockMachineBase
implements ICustomBlockHighlight {
    public static boolean doShapeRot = false;
    public static VoxelShape SHAPE;
    public static final BooleanProperty IS_CORE;

    public BlockDummyable(BlockBehaviour.Properties pProperties) {
        super(pProperties.m_60955_().m_60971_(BlockDummyable::never));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)IS_CORE, (Comparable)Boolean.TRUE));
    }

    protected int placementOffset() {
        return 0;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{IS_CORE});
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        if (!pLevel.f_46443_) {
            BlockPos corePos;
            List<Vec3i> offsets = MultiblockData.mapping.get((Object)this).offsets;
            Direction direction = (Direction)pState.m_61143_((Property)FACING);
            int offset = this.placementOffset();
            BlockPos blockPos = corePos = offset == 0 ? pPos : pPos.m_5484_(direction, offset);
            if (!DummableHelper.checkRequirement(pLevel, corePos, direction, offsets, pPos)) {
                pLevel.m_7471_(pPos, false);
                Containers.m_18992_((Level)pLevel, (double)pPos.m_252807_().f_82479_, (double)pPos.m_252807_().f_82480_, (double)pPos.m_252807_().f_82481_, (ItemStack)pStack.m_41720_().m_7968_());
                return;
            }
            if (!corePos.equals((Object)pPos)) {
                pLevel.m_7471_(pPos, false);
                pLevel.m_7731_(corePos, pState, 3);
            }
            DummableHelper.fillSpace(pLevel, corePos, pState, direction, offsets);
        }
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
    }

    @Override
    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            DummableHelper.clearSpace(pLevel, pPos, pState, (Direction)pState.m_61143_((Property)FACING));
            super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
        }
    }

    public BlockPos getCore(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockEntity blockEntity;
        if (!((Boolean)pState.m_61143_((Property)IS_CORE)).booleanValue() && (blockEntity = pLevel.m_7702_(pPos)) instanceof TileProxyBase) {
            TileProxyBase tileProxy = (TileProxyBase)blockEntity;
            return tileProxy.cachedPos;
        }
        return pPos;
    }

    @Override
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity;
        BlockPos core;
        BlockState coreState;
        if (!pLevel.f_46443_ && !pPlayer.m_20089_().equals((Object)Pose.CROUCHING)) {
            coreState = pState;
            core = this.getCore(pState, (LevelReader)pLevel, pPos);
            blockEntity = pLevel.m_7702_(core);
            if (!(blockEntity instanceof DummyableBlockEntity)) {
                if (((Boolean)coreState.m_61143_((Property)IS_CORE)).booleanValue()) {
                    return coreState.m_60734_().m_6227_(coreState, pLevel, core, pPlayer, pHand, pHit);
                }
                HBM.LOGGER.warn("Dummy block's core lost, at " + pPos.m_123344_());
                return InteractionResult.CONSUME;
            }
        } else {
            return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
        }
        DummyableBlockEntity entity = (DummyableBlockEntity)blockEntity;
        coreState = pLevel.m_8055_(core);
        entity.onLeftClick(pState, pLevel, pPos, pPlayer, pHand, pHit);
        super.m_6227_(coreState, pLevel, core, pPlayer, pHand, pHit);
        return InteractionResult.SUCCESS;
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        if (!pLevel.f_46443_) {
            if (((Boolean)pState.m_61143_((Property)IS_CORE)).booleanValue()) {
                super.m_6861_(pState, pLevel, pPos, pNeighborBlock, pNeighborPos, pMovedByPiston);
            } else {
                BlockPos corePos = this.getCore(pState, (LevelReader)pLevel, pPos);
                if (corePos.equals((Object)pPos)) {
                    return;
                }
                BlockState coreState = pLevel.m_8055_(corePos);
                if (!coreState.m_60713_((Block)this) || !((Boolean)coreState.m_61143_((Property)IS_CORE)).booleanValue()) {
                    return;
                }
                coreState.m_60690_(pLevel, corePos, pNeighborBlock, pNeighborPos, pMovedByPiston);
            }
        }
    }

    @Override
    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.INVISIBLE;
    }

    public int[] getDimensions() {
        return MultiblockData.mapping.get((Object)this).dirOffsets;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return (Boolean)pState.m_61143_((Property)IS_CORE) != false ? this.mainBlockEntity(pPos, pState) : new TileProxyCombo(pPos, pState);
    }

    protected BlockEntity mainBlockEntity(BlockPos pPos, BlockState pState) {
        return null;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return ((Boolean)pState.m_61143_((Property)IS_CORE)).booleanValue() ? (doShapeRot ? DirectionUtils.voxelShapeRot(SHAPE, (Direction)pState.m_61143_((Property)FACING)) : SHAPE) : Shapes.m_83144_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDrawHighlight(Level world, BlockPos pPos) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawHighlight(RenderHighlightEvent event, Level world, BlockPos pPos) {
    }

    private static boolean never(BlockState p_50806_, BlockGetter p_50807_, BlockPos p_50808_) {
        return false;
    }

    static {
        IS_CORE = HBMBlockProperties.IS_CORE;
    }
}

