/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.block.env;

import com.hbm.block.HBMBlockProperties;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.config.MobConfig;
import com.hbm.entity.mob.EntityGlyphid;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.handler.pollution.PollutionType;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GlyphidSpawner
extends BaseEntityBlock {
    public static final IntegerProperty VARIANT = HBMBlockProperties.VARIANT3;
    private static final ArrayList<Pair<Function<Level, EntityGlyphid>, int[]>> spawnMap = new ArrayList();

    public GlyphidSpawner(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{VARIANT});
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return GlyphidSpawnerEntity::tick;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new GlyphidSpawnerEntity(pPos, pState);
    }

    static {
        spawnMap.add((Pair<Function<Level, EntityGlyphid>, int[]>)new Pair(EntityGlyphid::new, (Object)MobConfig.glyphidChance));
    }

    public static class GlyphidSpawnerEntity
    extends BlockEntity {
        boolean initialSpawn = true;

        public GlyphidSpawnerEntity(BlockPos pPos, BlockState pBlockState) {
            super((BlockEntityType)ModBlockEntityType.GLYPHID_SPAWNER.get(), pPos, pBlockState);
        }

        public static <T extends Entity> void tick(Level level, BlockPos pPos, BlockState pState, BlockEntity pBlockEntity) {
            if (!level.m_5776_() && level.m_46469_().m_46207_(GameRules.f_46134_) && pBlockEntity instanceof GlyphidSpawnerEntity) {
                GlyphidSpawnerEntity spawner = (GlyphidSpawnerEntity)pBlockEntity;
                if (spawner.initialSpawn || level.f_46441_.m_188503_(MobConfig.swarmCooldown) == 0) {
                    spawner.initialSpawn = false;
                    int count = 0;
                    for (EntityGlyphid entity2 : level.m_6443_(EntityGlyphid.class, spawner.getRenderBoundingBox().m_82377_(64.0, 64.0, 64.0), entity -> true)) {
                        if (!((double)(++count) >= MobConfig.spawnMax)) continue;
                        return;
                    }
                    float soot = PollutionHandler.getPollution(level, spawner.m_58899_(), PollutionType.SOOT);
                    int subtype = (Integer)spawner.m_58900_().m_61143_((Property)VARIANT);
                    if (count <= 3 || subtype == 2) {
                        ArrayList<EntityGlyphid> currentSwarm = spawner.createSwarm(soot, subtype);
                        for (EntityGlyphid glyphid : currentSwarm) {
                            spawner.trySpawnEntity(glyphid);
                        }
                        if (!spawner.initialSpawn && level.f_46441_.m_188503_(MobConfig.scoutSwarmSpawnChance + 1) == 0 && (double)soot >= MobConfig.scoutThreshold && subtype != 2) {
                            EntityGlyphid scout = new EntityGlyphid(level);
                            if ((Integer)spawner.m_58900_().m_61143_((Property)VARIANT) == 1) {
                                scout.m_20088_().m_135381_(EntityGlyphid.DATA_SUBTYPE, (Object)1);
                            }
                            spawner.trySpawnEntity(scout);
                        }
                    }
                }
            }
        }

        public void trySpawnEntity(EntityGlyphid glyphid) {
            double offsetX = glyphid.m_217043_().m_188583_() * 3.0;
            double offsetZ = glyphid.m_217043_().m_188583_() * 3.0;
            Vec3 center = this.m_58899_().m_252807_();
            for (int i = 0; i < 7; ++i) {
                glyphid.m_6034_(center.f_82479_ + 0.5 + offsetX, center.f_82480_ - 2.0 + (double)i, center.f_82481_ + 0.5 + offsetZ);
                glyphid.m_146922_(this.f_58857_.f_46441_.m_188501_() * 360.0f);
                if (!glyphid.getCanSpawnHere()) continue;
                this.f_58857_.m_7967_((Entity)glyphid);
                return;
            }
        }

        public ArrayList<EntityGlyphid> createSwarm(float soot, int meta) {
            Random rand = new Random();
            ArrayList<EntityGlyphid> currentSpawns = new ArrayList<EntityGlyphid>();
            int swarmAmount = (int)Math.min((double)MobConfig.baseSwarmSize * Math.max(MobConfig.swarmScalingMult * (double)(soot / (float)MobConfig.sootStep), 1.0), 10.0);
            for (int cap = 100; currentSpawns.size() <= swarmAmount && cap >= 0; --cap) {
                for (Pair<Function<Level, EntityGlyphid>, int[]> glyphid : spawnMap) {
                    int[] chance = (int[])glyphid.getSecond();
                    int adjustedChance = (int)((float)chance[0] + ((float)chance[1] - (float)chance[1] / Math.max((soot + 1.0f) / 3.0f, 1.0f)));
                    if (!(soot >= (float)chance[2]) || rand.nextInt(100) > adjustedChance) continue;
                    EntityGlyphid entity = (EntityGlyphid)((Function)glyphid.getFirst()).apply(this.f_58857_);
                    if (meta == 1) {
                        entity.m_20088_().m_135381_(EntityGlyphid.DATA_SUBTYPE, (Object)1);
                    }
                    if (meta == 2) {
                        entity.m_20088_().m_135381_(EntityGlyphid.DATA_SUBTYPE, (Object)2);
                    }
                    currentSpawns.add(entity);
                }
            }
            return currentSpawns;
        }

        protected void m_183515_(CompoundTag pTag) {
            super.m_183515_(pTag);
            pTag.m_128379_("initialSpawn", this.initialSpawn);
        }

        public void m_142466_(CompoundTag pTag) {
            super.m_142466_(pTag);
            this.initialSpawn = pTag.m_128471_("initialSpawn");
        }
    }
}

