/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.block.logistic;

import com.hbm.api.Mode;
import com.hbm.block.logistic.AbstractPipeBlock;
import com.hbm.blockentity.machine.PipeEntity;
import com.hbm.utils.EnumUtils;
import com.hbm.utils.WorldUtils;
import com.hbm.utils.transport_net.FluidNetworkSystem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.Nullable;

public class BlockFluidPipe
extends AbstractPipeBlock
implements EntityBlock {
    public BlockFluidPipe(BlockBehaviour.Properties pProperties) {
        super(pProperties, 0.1875f);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new PipeEntity(pPos, pState);
    }

    @Override
    public boolean connectsTo(BlockPos clickedPos, LevelAccessor pLevel, Direction direction) {
        BlockPos neighbourPos = clickedPos.m_121945_(direction);
        PipeEntity clickPipe = WorldUtils.getTileEntity(PipeEntity.class, (BlockGetter)pLevel, clickedPos);
        if (clickPipe != null && clickPipe.connLimit[direction.ordinal()] != Mode.BOTH) {
            return false;
        }
        BlockEntity neighbourEntity = pLevel.m_7702_(neighbourPos);
        if (neighbourEntity instanceof PipeEntity) {
            PipeEntity pipe = (PipeEntity)neighbourEntity;
            if (pipe.connLimit[direction.m_122424_().ordinal()] != Mode.BOTH) {
                return false;
            }
            Fluid selfFluid = clickPipe != null ? clickPipe.getFluid() : Fluids.f_76191_;
            Fluid otherFluid = pipe.getFluid();
            return selfFluid == Fluids.f_76191_ || otherFluid == Fluids.f_76191_ || selfFluid.m_6212_(otherFluid);
        }
        return neighbourEntity != null && neighbourEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_()).isPresent();
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pMovedByPiston);
        if (pLevel.f_46443_) {
            return;
        }
        FluidNetworkSystem.getOrCreate(pLevel).rebuildNetwork(pPos);
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        Level serverLevel;
        block7: {
            block6: {
                super.onBlockStateChange(level, pos, oldState, newState);
                if (!(level instanceof Level)) break block6;
                serverLevel = (Level)level;
                if (!serverLevel.f_46443_) break block7;
            }
            return;
        }
        PipeEntity pipe1 = WorldUtils.getTileEntity(PipeEntity.class, (BlockGetter)level, pos);
        if (pipe1 == null) {
            return;
        }
        FluidNetworkSystem fluidNetworkSystem = FluidNetworkSystem.getOrCreate(serverLevel);
        for (Direction direction : EnumUtils.DIRECTIONS) {
            boolean newValue;
            BooleanProperty property = (BooleanProperty)f_55154_.get(direction);
            boolean oldValue = oldState.m_61138_((Property)property) && (Boolean)oldState.m_61143_((Property)property) != false;
            boolean bl = newValue = newState.m_61138_((Property)property) && (Boolean)newState.m_61143_((Property)property) != false;
            if (!oldValue && newValue) {
                fluidNetworkSystem.rebuildNetwork(pos);
                continue;
            }
            if (!oldValue || newValue || pipe1.network == null) continue;
            fluidNetworkSystem.split(pipe1.network);
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (!pLevel.f_46443_) {
            FluidNetworkSystem fluidNetworkSystem = FluidNetworkSystem.getOrCreate(pLevel);
            fluidNetworkSystem.leave(pPos);
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }
}

