/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.block.machine;

import com.hbm.api.energy.fe.IHBMEnergyStorage;
import com.hbm.block.base.BaseMachineBlock;
import com.hbm.blockentity.machine.BatteryEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.Nullable;

public class BlockBattery
extends BaseMachineBlock {
    public final BatteryType type;

    public BlockBattery(BlockBehaviour.Properties pProperties, BatteryType type) {
        super(pProperties);
        this.type = type;
    }

    @Override
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof BatteryEntity) {
            pPlayer.m_5893_((MenuProvider)blockEntity);
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return pState.m_60734_() instanceof BlockBattery ? new BatteryEntity(pPos, pState) : null;
    }

    @Override
    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            pLevel.m_46747_(pPos);
            super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof BatteryEntity) {
            BatteryEntity battery = (BatteryEntity)blockEntity;
            if (!player.m_7500_()) {
                ItemStack itemStack = new ItemStack((ItemLike)state.m_60734_());
                battery.getCapability(ForgeCapabilities.ENERGY).ifPresent(cap -> itemStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(iEnergyStorage -> {
                    long stored = ((IHBMEnergyStorage)cap).getLongStore();
                    ((IHBMEnergyStorage)iEnergyStorage).setEnergy(stored);
                }));
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemStack);
            }
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((Container)blockEntity));
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pParams) {
        return List.of();
    }

    public static enum BatteryType {
        BASIC(1000000L, 10000L),
        LITHIUM(50000000L, 500000L),
        SCHRABIDIUM(25000000000L, 2500000000L),
        DINEUTRONIUM(1000000000000L, 1000000000L),
        CREATIVE(Long.MAX_VALUE, Long.MAX_VALUE);

        private final long baseMaxEnergy;
        private final long baseOutput;

        private BatteryType(long maxEnergy, long maxOutput) {
            this.baseMaxEnergy = maxEnergy;
            this.baseOutput = maxOutput;
        }

        public long getMaxEnergy() {
            return this.baseMaxEnergy;
        }

        public long getOutput() {
            return this.baseOutput;
        }
    }
}

