/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.block.machine.generator;

import com.hbm.block.base.BlockMachineBase;
import com.hbm.block.machine.generator.BlockPWR;
import com.hbm.blockentity.machine.PWRBlockEntity;
import com.hbm.blockentity.machine.PWRControllerBlockEntity;
import com.hbm.registries.ModBlocks;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class BlockPWRController
extends BlockMachineBase {
    private static final int MAX_SIZE = 4096;

    public BlockPWRController(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new PWRControllerBlockEntity(pPos, pState);
    }

    @Override
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (pPlayer.m_20089_().equals((Object)Pose.CROUCHING)) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof PWRControllerBlockEntity)) {
            return InteractionResult.CONSUME;
        }
        PWRControllerBlockEntity controller = (PWRControllerBlockEntity)blockEntity;
        if (!controller.isAssembled()) {
            this.assemble(pLevel, pPos, controller, pPlayer);
            return InteractionResult.CONSUME;
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)controller, buf -> buf.m_130064_(pPos));
        return InteractionResult.CONSUME;
    }

    private void assemble(Level level, BlockPos pos, PWRControllerBlockEntity controller, Player player) {
        HashMap<BlockPos, Block> assembly = new HashMap<BlockPos, Block>();
        HashMap<BlockPos, Block> rods = new HashMap<BlockPos, Block>();
        HashMap<BlockPos, Block> sources = new HashMap<BlockPos, Block>();
        boolean errored = false;
        assembly.put(pos, this);
        Direction dir = ((Direction)level.m_8055_(pos).m_61143_((Property)FACING)).m_122424_();
        if (!this.floodFill(level, pos.m_121945_(dir), player, assembly, rods, sources)) {
            errored = true;
        }
        if (rods.isEmpty()) {
            this.sendError(player, "Fuel rods required");
            errored = true;
        }
        if (sources.isEmpty()) {
            this.sendError(player, "Neutron sources required");
            errored = true;
        }
        if (!errored) {
            for (Map.Entry entry : assembly.entrySet()) {
                BlockPos partPos = (BlockPos)entry.getKey();
                Block block = (Block)entry.getValue();
                if (block == ModBlocks.pwr_controller.get()) continue;
                boolean port = block == ModBlocks.pwr_port.get();
                BlockState newState = (BlockState)((Block)ModBlocks.pwr_block.get()).m_49966_().m_61124_((Property)BlockPWR.PORT, (Comparable)Boolean.valueOf(port));
                level.m_7731_(partPos, newState, 3);
                BlockEntity blockEntity = level.m_7702_(partPos);
                if (!(blockEntity instanceof PWRBlockEntity)) continue;
                PWRBlockEntity pwr = (PWRBlockEntity)blockEntity;
                pwr.setStoredBlock(block);
                pwr.setCorePos(pos);
            }
            controller.setup(assembly, rods);
        }
        controller.setAssembled(!errored);
        controller.sendUpdatePacket();
    }

    private boolean floodFill(Level level, BlockPos start, Player player, Map<BlockPos, Block> assembly, Map<BlockPos, Block> rods, Map<BlockPos, Block> sources) {
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(start);
        while (!queue.isEmpty()) {
            BlockPos current = (BlockPos)queue.pollLast();
            if (assembly.containsKey(current)) continue;
            if (assembly.size() >= 4096) {
                this.sendError(player, "Max size exceeded");
                return false;
            }
            Block block = level.m_8055_(current).m_60734_();
            if (this.isValidCasing(block)) {
                assembly.put(current, block);
                continue;
            }
            if (this.isValidCore(block)) {
                assembly.put(current, block);
                if (block == ModBlocks.pwr_fuel_block.get()) {
                    rods.put(current, block);
                }
                if (block == ModBlocks.pwr_neutron_source.get()) {
                    sources.put(current, block);
                }
                for (Direction dir : Direction.values()) {
                    queue.add(current.m_121945_(dir));
                }
                continue;
            }
            this.sendError(player, "Non-reactor block");
            return false;
        }
        return true;
    }

    private boolean isValidCore(Block block) {
        return block == ModBlocks.pwr_fuel_block.get() || block == ModBlocks.pwr_control.get() || block == ModBlocks.pwr_channel.get() || block == ModBlocks.pwr_heatex.get() || block == ModBlocks.pwr_heatsink.get() || block == ModBlocks.pwr_neutron_source.get();
    }

    private boolean isValidCasing(Block block) {
        return block == ModBlocks.pwr_casing.get() || block == ModBlocks.pwr_reflector.get() || block == ModBlocks.pwr_port.get();
    }

    private void sendError(Player player, String message) {
        player.m_5661_((Component)Component.m_237113_((String)message), true);
    }
}

