/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.block.machine.pile;

import com.hbm.block.machine.pile.ChicagoInsertableBlock;
import com.hbm.blockentity.machine.pile.ChicagoBreederBlockEntity;
import com.hbm.blockentity.machine.pile.ChicagoDetectorBlockEntity;
import com.hbm.blockentity.machine.pile.ChicagoFuelBlockEntity;
import com.hbm.blockentity.machine.pile.ChicagoSourceBlockEntity;
import com.hbm.item.HBMItems;
import com.hbm.registries.ModBlocks;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class ChicagoGraphiteDrilledBlock
extends ChicagoInsertableBlock {
    public ChicagoGraphiteDrilledBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult shield = this.handleShieldUse(state, level, pos, player, hand);
        if (shield.m_19077_()) {
            return shield;
        }
        ItemStack held = player.m_21120_(hand);
        if (held.m_41619_()) {
            return InteractionResult.PASS;
        }
        if (held.m_150930_((Item)HBMItems.PILE_ROD_URANIUM.get())) {
            return this.placeFuel(state, level, pos, player, held, ChicagoFuelBlockEntity.FuelVariant.URANIUM);
        }
        if (held.m_150930_((Item)HBMItems.PILE_ROD_PU239.get())) {
            return this.placeFuel(state, level, pos, player, held, ChicagoFuelBlockEntity.FuelVariant.PU239);
        }
        if (held.m_150930_((Item)HBMItems.PILE_ROD_SOURCE.get())) {
            return this.placeSource(state, level, pos, player, held, ChicagoSourceBlockEntity.SourceType.SOURCE);
        }
        if (held.m_150930_((Item)HBMItems.PILE_ROD_PLUTONIUM.get())) {
            return this.placeSource(state, level, pos, player, held, ChicagoSourceBlockEntity.SourceType.PLUTONIUM);
        }
        if (held.m_150930_((Item)HBMItems.PILE_ROD_BORON.get())) {
            return this.placeSimple(state, level, pos, player, held, ((Block)ModBlocks.chicago_graphite_rod.get()).m_49966_(), null);
        }
        if (held.m_150930_((Item)HBMItems.PILE_ROD_LITHIUM.get())) {
            return this.placeBreeder(state, level, pos, player, held);
        }
        if (held.m_150930_((Item)HBMItems.PILE_ROD_DETECTOR.get())) {
            return this.placeDetector(state, level, pos, player, held);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult placeFuel(BlockState state, Level level, BlockPos pos, Player player, ItemStack held, ChicagoFuelBlockEntity.FuelVariant variant) {
        BlockState target = this.copyAxisShield(state, ((Block)ModBlocks.chicago_graphite_fuel.get()).m_49966_());
        return this.placeSimple(state, level, pos, player, held, target, be -> {
            if (be instanceof ChicagoFuelBlockEntity) {
                ChicagoFuelBlockEntity fuel = (ChicagoFuelBlockEntity)be;
                fuel.loadFromItem(variant, held);
            }
        });
    }

    private InteractionResult placeSource(BlockState state, Level level, BlockPos pos, Player player, ItemStack held, ChicagoSourceBlockEntity.SourceType type) {
        BlockState target = this.copyAxisShield(state, ((Block)ModBlocks.chicago_graphite_source.get()).m_49966_());
        return this.placeSimple(state, level, pos, player, held, target, be -> {
            if (be instanceof ChicagoSourceBlockEntity) {
                ChicagoSourceBlockEntity source = (ChicagoSourceBlockEntity)be;
                source.setType(type);
            }
        });
    }

    private InteractionResult placeBreeder(BlockState state, Level level, BlockPos pos, Player player, ItemStack held) {
        BlockState target = this.copyAxisShield(state, ((Block)ModBlocks.chicago_graphite_breeder.get()).m_49966_());
        return this.placeSimple(state, level, pos, player, held, target, be -> {
            if (be instanceof ChicagoBreederBlockEntity) {
                ChicagoBreederBlockEntity breeder = (ChicagoBreederBlockEntity)be;
                breeder.setBaseItem(held);
            }
        });
    }

    private InteractionResult placeDetector(BlockState state, Level level, BlockPos pos, Player player, ItemStack held) {
        BlockState target = this.copyAxisShield(state, ((Block)ModBlocks.chicago_graphite_detector.get()).m_49966_());
        return this.placeSimple(state, level, pos, player, held, target, be -> {
            if (be instanceof ChicagoDetectorBlockEntity) {
                ChicagoDetectorBlockEntity detector = (ChicagoDetectorBlockEntity)be;
                detector.insertRod(held);
            }
        });
    }

    private InteractionResult placeSimple(BlockState previousState, Level level, BlockPos pos, Player player, ItemStack held, BlockState targetState, Consumer<BlockEntity> initializer) {
        BlockEntity be;
        if (level.f_46443_) {
            return InteractionResult.m_19078_((boolean)true);
        }
        level.m_7731_(pos, targetState, 3);
        if (initializer != null && (be = level.m_7702_(pos)) != null) {
            initializer.accept(be);
        }
        if (!player.m_150110_().f_35937_) {
            held.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }
}

