/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.block.machine.rbmk;

import com.hbm.block.base.BlockDummyable;
import com.hbm.blockentity.machine.rbmk.RBMKBaseEntity;
import com.hbm.blockentity.machine.rbmk.RBMKFuelChannelEntity;
import com.hbm.item.HBMItems;
import com.hbm.reactor.rbmk.RBMKColumnState;
import com.hbm.reactor.rbmk.RBMKLevelContext;
import com.hbm.reactor.rbmk.RBMKLidType;
import com.hbm.reactor.rbmk.RBMKManager;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class BlockRBMKBase
extends BlockDummyable {
    public static final EnumProperty<RBMKLidType> LID = EnumProperty.m_61587_((String)"lid", RBMKLidType.class);

    public BlockRBMKBase(BlockBehaviour.Properties properties) {
        super(properties);
        SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(LID, (Comparable)((Object)RBMKLidType.NONE)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LID});
    }

    @Override
    protected BlockEntity mainBlockEntity(BlockPos pPos, BlockState pState) {
        return new RBMKBaseEntity(pPos, pState);
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return (Boolean)state.m_61143_((Property)IS_CORE) != false ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos corePos = this.getCore(state, (LevelReader)level, pos);
        BlockEntity blockEntity = level.m_7702_(corePos);
        if (!(blockEntity instanceof RBMKBaseEntity)) {
            player.m_5661_((Component)Component.m_237113_((String)("RBMK \u6838\u5fc3\u4e22\u5931: " + corePos.m_123344_())), true);
            return InteractionResult.CONSUME;
        }
        RBMKBaseEntity baseEntity = (RBMKBaseEntity)blockEntity;
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.CONSUME;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!player.m_6144_()) {
            player.m_5893_((MenuProvider)baseEntity);
            return InteractionResult.CONSUME;
        }
        RBMKLevelContext context = RBMKManager.context(serverLevel);
        Optional<RBMKColumnState> column = context.column(corePos);
        if (column.isEmpty()) {
            player.m_5661_((Component)Component.m_237113_((String)("RBMK \u672a\u6ce8\u518c: " + corePos.m_123344_())), true);
            return InteractionResult.CONSUME;
        }
        RBMKColumnState columnState = column.get();
        player.m_5661_((Component)Component.m_237113_((String)String.format(Locale.ROOT, "RBMK %s | heat=%.2f | ctrl=%.2f | gctrl=%.2f | lid=%s | height=%d | cooling=%.2f | flow=%.2f", corePos.m_123344_(), columnState.heat(), columnState.controlRodInsertion(), context.controlRodAverage(), columnState.lidType().m_7912_(), columnState.columnHeight(), columnState.settings().passiveCooling(), columnState.settings().columnHeatFlow())), true);
        BlockEntity aboveEntity = level.m_7702_(corePos.m_7494_());
        if (aboveEntity instanceof RBMKFuelChannelEntity) {
            RBMKFuelChannelEntity fuelChannel = (RBMKFuelChannelEntity)aboveEntity;
            ItemStack fuelStack = fuelChannel.fuelStack();
            ItemStack spentStack = fuelChannel.spentFuelStack();
            int remaining = fuelChannel.burnTimeRemaining();
            int total = fuelChannel.burnTimeTotal();
            double percent = total > 0 ? (double)remaining * 100.0 / (double)total : 0.0;
            player.m_5661_((Component)Component.m_237113_((String)String.format(Locale.ROOT, "Fuel %s -> %s | burn=%d/%d (%.0f%%) | burning=%s | rs=%d | cmp=%d", fuelStack.m_41619_() ? "<empty>" : fuelStack.m_41786_().getString(), spentStack.m_41619_() ? "<empty>" : spentStack.m_41786_().getString(), remaining, total, percent, fuelChannel.isBurning(), fuelChannel.redstoneSignal(), fuelChannel.comparatorSignal())), true);
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        RBMKLidType lid;
        if (!state.m_60713_(newState.m_60734_()) && (lid = (RBMKLidType)((Object)state.m_61143_(LID))).isPresent()) {
            BlockRBMKBase.dropLidItem(level, pos, lid);
        }
        super.m_6810_(state, level, pos, newState, moved);
    }

    public static void dropLidItem(Level level, BlockPos pos, RBMKLidType lid) {
        ItemStack stack = ItemStack.f_41583_;
        if (lid == RBMKLidType.GLASS) {
            stack = ((Item)HBMItems.rbmk_lid_glass.get()).m_7968_();
        } else if (lid == RBMKLidType.SOLID) {
            stack = ((Item)HBMItems.rbmk_lid.get()).m_7968_();
        }
        if (!stack.m_41619_()) {
            Containers.m_18992_((Level)level, (double)((double)pos.m_123341_() + 0.5), (double)(pos.m_123342_() + 1), (double)((double)pos.m_123343_() + 0.5), (ItemStack)stack);
        }
    }
}

