/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.block.weapon;

import com.hbm.block.base.BlockDummyable;
import com.hbm.block.weapon.IBomb;
import com.hbm.blockentity.weapon.EntityNukeBomb;
import com.hbm.entity.effect.EntityNukeTorex;
import com.hbm.entity.logic.EntityNukeExplosionMK5;
import com.hbm.procedures.AtomicExplosionHelper;
import com.hbm.procedures.ThermobaricExplosionHelper;
import com.hbm.registries.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public abstract class NukeBomb
extends BlockDummyable
implements IBomb {
    public boolean explode = true;
    public int range = 0;

    public NukeBomb(BlockBehaviour.Properties pProperties, int range) {
        super(pProperties);
        this.range = range;
        doShapeRot = true;
    }

    @Override
    public IBomb.BombReturnCode explode(Level pLevel, BlockPos pPos) {
        if (!pLevel.f_46443_) {
            pLevel.m_5594_((Player)null, pPos, (SoundEvent)ModSounds.WEAPON_NUCLEAR_EXPLOSION.get(), SoundSource.RECORDS, 1.0f, 1.0f);
            pLevel.m_7967_((Entity)EntityNukeExplosionMK5.statFac(pLevel, this.range, pPos.m_252807_()));
            pLevel.m_7967_((Entity)new EntityNukeTorex(pLevel, pPos.m_252807_().m_82520_(0.0, 4.5, 0.0), this.range));
            pLevel.m_46961_(pPos, false);
            this.triggerExplosionVisual(pLevel, pPos);
            return IBomb.BombReturnCode.DETONATED;
        }
        return IBomb.BombReturnCode.UNDEFINED;
    }

    @Override
    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        if (!pLevel.f_46443_) {
            if (((Boolean)pState.m_61143_((Property)IS_CORE)).booleanValue()) {
                BlockEntity blockEntity = pLevel.m_7702_(pPos);
                if (blockEntity instanceof EntityNukeBomb) {
                    EntityNukeBomb bomb = (EntityNukeBomb)blockEntity;
                    if (pLevel.m_276867_(pPos)) {
                        pLevel.m_7471_(pPos, false);
                        this.explode(pLevel, pPos);
                    }
                }
            } else {
                super.m_6861_(pState, pLevel, pPos, pNeighborBlock, pNeighborPos, pMovedByPiston);
            }
        }
    }

    protected ExplosionVisual getExplosionVisual() {
        return ExplosionVisual.ATOMIC;
    }

    protected void triggerExplosionVisual(Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return;
        }
        Vec3 center = pos.m_252807_();
        switch (this.getExplosionVisual()) {
            case ATOMIC: {
                AtomicExplosionHelper.triggerEffects(level, center);
                break;
            }
            case THERMOBARIC: {
                ThermobaricExplosionHelper.triggerEffects(level, center);
                break;
            }
        }
    }

    protected static enum ExplosionVisual {
        ATOMIC,
        THERMOBARIC,
        NONE;

    }
}

