/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.base;

import com.hbm.api.energy.IEnergyContainer;
import com.hbm.api.fluid.IExtendedFluidTank;
import com.hbm.blockentity.base2.BaseMachineBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class RecipeProcessBlockEntity<R extends Recipe<Container>>
extends BaseMachineBlockEntity {
    protected static int maxProgress;
    protected static long maxPower;
    public int progress = 0;
    public int cooldown = 0;
    protected R recipeNow = null;
    protected IEnergyContainer energyContainer = null;
    protected List<IExtendedFluidTank> tanks = new ArrayList<IExtendedFluidTank>();
    protected RecipeManager.CachedCheck<Container, R> quickCheck;

    protected RecipeProcessBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.canProcess()) {
            ++this.progress;
            this.onProcess();
            if (this.progress >= maxProgress) {
                this.progress = 0;
                this.onEndRunning();
            } else if (this.progress == 1) {
                this.onStartRunning();
            }
        } else {
            this.progress = 0;
            this.onNotRunning();
        }
    }

    protected abstract boolean canProcess();

    protected abstract void onProcess();

    protected abstract void onEndRunning();

    protected abstract void onStartRunning();

    protected abstract void onNotRunning();

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128425_("recipe_now", 8)) {
            ResourceLocation resourceLocation = new ResourceLocation(pTag.m_128461_("recipe_now"));
            this.recipeNow = this.f_58857_.m_7465_().m_44043_(resourceLocation).orElse(null);
        }
        this.progress = pTag.m_128451_("progress");
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.recipeNow != null) {
            pTag.m_128359_("recipe_now", this.recipeNow.m_6423_().toString());
        }
        pTag.m_128405_("progress", this.progress);
    }
}

