/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.base;

import com.hbm.api.providers.IBlockProvider;
import com.hbm.block.interfaces.IHasTileEntity;
import com.hbm.block.states.TransmitterType;
import com.hbm.blockentity.base2.CapabilityBlockEntity;
import com.hbm.capabilities.network.ConnType;
import com.hbm.capabilities.network.TransmitterNetworkRegistry;
import com.hbm.capabilities.network.transmitter.Transmitter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TransmitterBlockEntity
extends CapabilityBlockEntity {
    private final Transmitter<?, ?, ?> transmitter;
    private boolean forceUpdate = true;
    private boolean loaded = false;

    public TransmitterBlockEntity(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(((IHasTileEntity)blockProvider.getBlock()).getTileType(), pos, state);
        this.transmitter = this.createTransmitter(blockProvider);
        this.cacheCoord();
    }

    protected abstract Transmitter<?, ?, ?> createTransmitter(IBlockProvider var1);

    public Transmitter<?, ?, ?> getTransmitter() {
        return this.transmitter;
    }

    public void setForceUpdate() {
        this.forceUpdate = true;
    }

    public abstract TransmitterType getTransmitterType();

    protected void onUpdateServer() {
        if (this.forceUpdate) {
            this.getTransmitter().refreshConnections();
            this.forceUpdate = false;
        }
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, TransmitterBlockEntity transmitter) {
        transmitter.onUpdateServer();
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag() {
        return this.getTransmitter().getReducedUpdateTag(super.getReducedUpdateTag());
    }

    public void handleUpdateTag(@NotNull CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.getTransmitter().handleUpdateTag(tag);
    }

    @Override
    public void handleUpdatePacket(@NotNull CompoundTag tag) {
        super.handleUpdatePacket(tag);
        this.updateModelData();
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.getTransmitter().read(nbt);
    }

    @Override
    public void m_183515_(@NotNull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        this.getTransmitter().write(nbtTags);
    }

    public void onNeighborTileChange(Direction side) {
        this.getTransmitter().onNeighborTileChange(side);
    }

    public void onNeighborBlockChange(Direction side) {
        this.getTransmitter().onNeighborBlockChange(side);
    }

    public void m_6339_() {
        super.m_6339_();
        this.onWorldJoin(false);
    }

    public void onChunkUnloaded() {
        if (!this.isRemote()) {
            this.getTransmitter().takeShare();
        }
        super.onChunkUnloaded();
    }

    public void m_7651_() {
        super.m_7651_();
        this.onWorldSeparate(false);
        this.getTransmitter().remove();
    }

    public void onAdded() {
        this.onWorldJoin(false);
        this.getTransmitter().refreshConnections();
    }

    private void onWorldJoin(boolean wasPresent) {
        if (!this.isRemote() && !wasPresent) {
            TransmitterNetworkRegistry.trackTransmitter(this.getTransmitter());
        }
        if (!this.loaded) {
            this.loaded = true;
            if (!this.isRemote()) {
                TransmitterNetworkRegistry.registerOrphanTransmitter(this.getTransmitter());
            }
        }
    }

    private void onWorldSeparate(boolean stillPresent) {
        if (!this.isRemote() && !stillPresent) {
            TransmitterNetworkRegistry.untrackTransmitter(this.getTransmitter());
        }
        if (this.loaded) {
            this.loaded = false;
            if (this.isRemote()) {
                this.getTransmitter().setTransmitterNetwork(null);
            } else {
                TransmitterNetworkRegistry.invalidateTransmitter(this.getTransmitter());
            }
        }
    }

    public void chunkAccessibilityChange(boolean loaded) {
        if (loaded) {
            this.onWorldJoin(true);
        } else {
            this.getTransmitter().validateAndTakeShare();
            this.onWorldSeparate(true);
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    protected InteractionResult onConfigure(Player player, Direction side) {
        return this.getTransmitter().onConfigure(player, side);
    }

    @NotNull
    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_, this.f_58858_.m_7918_(1, 1, 1));
    }

    public void sideChanged(@NotNull Direction side, @NotNull ConnType old, @NotNull ConnType type) {
    }

    public void redstoneChanged(boolean powered) {
    }

    protected InteractPredicate getExtractPredicate() {
        return (tank, side) -> {
            if (side == null) {
                return true;
            }
            ConnType connectionType = this.getTransmitter().getConnType(side);
            return connectionType == ConnType.NORMAL || connectionType == ConnType.OUT;
        };
    }

    protected InteractPredicate getInsertPredicate() {
        return (tank, side) -> {
            if (side == null) {
                return true;
            }
            ConnType connectionType = this.getTransmitter().getConnType(side);
            return connectionType == ConnType.NORMAL || connectionType == ConnType.IN;
        };
    }

    @FunctionalInterface
    public static interface InteractPredicate {
        public static final InteractPredicate ALWAYS_TRUE = (tank, side) -> true;

        public boolean test(int var1, @Nullable Direction var2);
    }
}

