/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.base2;

import com.hbm.api.Mode;
import com.hbm.blockentity.base2.HBMBlockEntity;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMachineBlockEntity
extends HBMBlockEntity
implements WorldlyContainer,
MenuProvider {
    private LockCode lockKey = LockCode.f_19102_;
    public NonNullList<ItemStack> items;
    public List<Mode> slotModes;
    public boolean running = false;

    protected BaseMachineBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.capabilitiesContent.addCapability(ForgeCapabilities.ITEM_HANDLER, this);
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        this.lockKey.m_19109_(pTag);
        if (this.items != null) {
            ContainerHelper.m_18973_((CompoundTag)pTag, this.items);
        }
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.lockKey = LockCode.m_19111_((CompoundTag)pTag);
        if (this.items != null) {
            this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)pTag, this.items);
        }
    }

    protected void onUpdateClient() {
    }

    protected void onUpdateServer() {
    }

    public static void clientTicker(Level level, BlockPos pPos, BlockState pState, BlockEntity pBlockEntity) {
        if (pBlockEntity instanceof BaseMachineBlockEntity) {
            ((BaseMachineBlockEntity)pBlockEntity).onUpdateClient();
        }
    }

    public static void serverTicker(Level level, BlockPos pPos, BlockState pState, BlockEntity pBlockEntity) {
        if (pBlockEntity instanceof BaseMachineBlockEntity) {
            ((BaseMachineBlockEntity)pBlockEntity).onUpdateServer();
        }
    }

    public boolean canOpen(Player pPlayer) {
        return BaseMachineBlockEntity.canUnlock(pPlayer, this.lockKey, this.m_5446_());
    }

    public static boolean canUnlock(Player pPlayer, LockCode pCode, Component pDisplayName) {
        if (!pPlayer.m_5833_() && !pCode.m_19107_(pPlayer.m_21205_())) {
            pPlayer.m_5661_((Component)Component.m_237110_((String)"container.isLocked", (Object[])new Object[]{pDisplayName}), true);
            pPlayer.m_6330_(SoundEvents.f_11748_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return false;
        }
        return true;
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return this.canOpen(pPlayer) ? this.createMenu(pContainerId, pPlayerInventory) : null;
    }

    public abstract AbstractContainerMenu createMenu(int var1, Inventory var2);

    @NotNull
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public Mode getMode(int tank) {
        if (this.items == null || tank < 0 || tank >= this.items.size()) {
            return Mode.NONE;
        }
        if (this.slotModes == null || this.slotModes.isEmpty()) {
            return Mode.BOTH;
        }
        if (tank >= this.slotModes.size()) {
            return Mode.BOTH;
        }
        return this.slotModes.get(tank);
    }

    @Override
    public long getStored() {
        return super.getStored();
    }

    public int @NotNull [] m_7071_(Direction pSide) {
        if (this.items == null || this.items.isEmpty()) {
            return new int[0];
        }
        return IntStream.range(0, this.items.size()).toArray();
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return this.allowInput(pIndex) && this.isItemValid(pIndex, pItemStack) && this.getCapability(ForgeCapabilities.ITEM_HANDLER, pDirection).isPresent();
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return this.allowOutput(pIndex) && this.getCapability(ForgeCapabilities.ITEM_HANDLER, pDirection).isPresent();
    }

    public int m_6643_() {
        return this.getSlots();
    }

    public boolean m_7983_() {
        if (this.items == null || this.items.isEmpty()) {
            return true;
        }
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int pSlot) {
        return this.getStackInSlot(pSlot);
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        return ContainerHelper.m_18969_(this.items, (int)pSlot, (int)pAmount);
    }

    public ItemStack m_8016_(int pSlot) {
        return ContainerHelper.m_18966_(this.items, (int)pSlot);
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        this.setStackInSlot(pSlot, pStack);
        this.m_6596_();
    }

    public boolean m_6542_(Player pPlayer) {
        return Container.m_272074_((BlockEntity)this, (Player)pPlayer);
    }

    public void m_6211_() {
        this.items.clear();
    }
}

