/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.base2;

import com.hbm.HBM;
import com.hbm.api.Chunk3D;
import com.hbm.api.Coord4D;
import com.hbm.api.interferences.ITileWrapper;
import com.hbm.network.ModMessages;
import com.hbm.network.packet.toclient.S2CSyncTileMessage;
import com.hbm.utils.WorldUtils;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UpdateableBlockEntity
extends BlockEntity
implements ITileWrapper {
    @Nullable
    private Coord4D cachedCoord;
    private boolean cacheCoord;
    private long lastSave;
    public boolean muffled;
    S2CSyncTileMessage lastUpdateMsg;

    public UpdateableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag;
        if (this.isRemote() && net.getDirection() == PacketFlow.CLIENTBOUND && (tag = pkt.m_131708_()) != null) {
            this.handleUpdatePacket(tag);
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.getReducedUpdateTag();
    }

    @NotNull
    public CompoundTag getReducedUpdateTag() {
        return super.m_5995_();
    }

    public void handleUpdatePacket(@NotNull CompoundTag tag) {
        this.handleUpdateTag(tag);
    }

    public CompoundTag getClientSyncTag() {
        return new CompoundTag();
    }

    public void handleClientPacket(@NotNull CompoundTag tag) {
    }

    public void sendUpdatePacket() {
        this.sendUpdatePacket(this);
    }

    public void sendUpdatePacket(BlockEntity tracking) {
        if (this.isRemote()) {
            HBM.LOGGER.warn("Update packet call requested from client side", (Throwable)new IllegalStateException());
        } else if (this.m_58901_()) {
            HBM.LOGGER.warn("Update packet call requested for removed tile", (Throwable)new IllegalStateException());
        } else {
            ModMessages.sendToAll(new S2CSyncTileMessage(this));
        }
    }

    public void networkPackNT(int range) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        S2CSyncTileMessage updateMsg = new S2CSyncTileMessage(this);
        if (!updateMsg.equals(this.lastUpdateMsg) || this.f_58857_.m_46467_() % 20L != 0L) {
            return;
        }
        this.lastUpdateMsg = updateMsg.copy();
        ModMessages.sendToAllAround(updateMsg, new PacketDistributor.TargetPoint((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (double)range, this.f_58857_.m_46472_()));
    }

    @NotNull
    protected Level getWorldNN() {
        return Objects.requireNonNull(this.m_58904_(), "getWorldNN called before world set");
    }

    public boolean isRemote() {
        return this.getWorldNN().m_5776_();
    }

    @Override
    public Level getTileWorld() {
        return this.f_58857_;
    }

    @Override
    public BlockPos getTilePos() {
        return this.f_58858_;
    }

    protected void updateModelData() {
        this.requestModelDataUpdate();
        WorldUtils.updateBlock(this.m_58904_(), this.m_58899_(), this.m_58900_());
    }

    public void blockRemoved() {
    }

    public void markDirtyComparator() {
    }

    public final void m_6596_() {
        this.setChanged(true);
    }

    public final void markForSave() {
        this.setChanged(false);
    }

    protected void setChanged(boolean updateComparator) {
        if (this.f_58857_ != null) {
            long time = this.f_58857_.m_46467_();
            if (this.lastSave != time) {
                WorldUtils.markChunkDirty(this.f_58857_, this.f_58858_);
                this.lastSave = time;
            }
            if (updateComparator && !this.isRemote()) {
                this.markDirtyComparator();
            }
        }
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.updateCoord();
        this.muffled = nbt.m_128441_("muffled");
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.muffled) {
            pTag.m_128344_("muffled", (byte)0);
        }
    }

    public void m_142339_(@NotNull Level world) {
        super.m_142339_(world);
        this.updateCoord();
    }

    protected void cacheCoord() {
        this.cacheCoord = true;
        this.updateCoord();
    }

    private void updateCoord() {
        if (this.cacheCoord && this.f_58857_ != null) {
            this.cachedCoord = new Coord4D((Vec3i)this.f_58858_, this.f_58857_);
        }
    }

    @Override
    public Coord4D getTileCoord() {
        return this.cacheCoord && this.cachedCoord != null ? this.cachedCoord : ITileWrapper.super.getTileCoord();
    }

    @Override
    public Chunk3D getTileChunk() {
        if (this.cacheCoord && this.cachedCoord != null) {
            return new Chunk3D(this.cachedCoord);
        }
        BlockPos pos = this.getTilePos();
        return new Chunk3D((ResourceKey<Level>)this.getTileWorld().m_46472_(), SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()));
    }

    public float getVolume(float baseVolume) {
        return this.muffled ? baseVolume * 0.1f : baseVolume;
    }
}

