/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.interfaces;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;

public interface IRecipeProcess<R extends Recipe<Container>> {
    public static final int maxProgress = 1000;

    public int getProgress();

    public void setProgress(int var1);

    public R getRecipeNow();

    public void setRecipeNow(R var1);

    public Level getLevel();

    default public void addProgress() {
        this.setProgress(this.getProgress() + 1);
    }

    default public void updateServer() {
        if (this.canProcess()) {
            this.addProgress();
            this.onProcess();
            if (this.getProgress() >= 1000) {
                this.setProgress(0);
                this.onEndRunning();
            } else if (this.getProgress() == 1) {
                this.onStartRunning();
            }
        } else {
            this.setProgress(0);
            this.onNotRunning();
        }
    }

    public boolean canProcess();

    public void onProcess();

    public void onEndRunning();

    default public void onStartRunning() {
    }

    default public void onNotRunning() {
    }

    default public void loadData(CompoundTag pTag) {
        if (pTag.m_128425_("recipe_now", 8)) {
            ResourceLocation resourceLocation = new ResourceLocation(pTag.m_128461_("recipe_now"));
            this.setRecipeNow(this.getLevel().m_7465_().m_44043_(resourceLocation).orElse(null));
        }
        this.setProgress(pTag.m_128451_("progress"));
    }

    default public void saveData(CompoundTag pTag) {
        if (this.getRecipeNow() != null) {
            pTag.m_128359_("recipe_now", this.getRecipeNow().m_6423_().toString());
        }
        pTag.m_128405_("progress", this.getProgress());
    }
}

