/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.interfaces;

import com.hbm.HBMLang;
import com.hbm.api.IIncrementalEnum;
import com.hbm.api.annotations.NothingNullByDefault;
import com.hbm.api.math.MathUtils;
import com.hbm.api.text.IHasTextComponent;
import com.hbm.api.text.ILangEntry;
import net.minecraft.network.chat.Component;

public interface IRedstoneControl {
    public RedstoneControl getControlType();

    public void setControlType(RedstoneControl var1);

    public boolean isPowered();

    public boolean wasPowered();

    public boolean canPulse();

    @NothingNullByDefault
    public static enum RedstoneControl implements IIncrementalEnum<RedstoneControl>,
    IHasTextComponent
    {
        DISABLED(HBMLang.REDSTONE_CONTROL_DISABLED),
        HIGH(HBMLang.REDSTONE_CONTROL_HIGH),
        LOW(HBMLang.REDSTONE_CONTROL_LOW),
        PULSE(HBMLang.REDSTONE_CONTROL_PULSE);

        private static final RedstoneControl[] MODES;
        private final ILangEntry langEntry;

        private RedstoneControl(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        @Override
        public Component getTextComponent() {
            return this.langEntry.translate(new Object[0]);
        }

        @Override
        public RedstoneControl byIndex(int index) {
            return RedstoneControl.byIndexStatic(index);
        }

        public static RedstoneControl byIndexStatic(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        static {
            MODES = RedstoneControl.values();
        }
    }
}

