/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine;

import com.hbm.Inventory.recipe.AssemblerRecipe;
import com.hbm.Inventory.recipe.ModRecipes;
import com.hbm.api.energy.BasicEnergyContainer;
import com.hbm.api.energy.HybridEnergyStorage;
import com.hbm.api.energy.ProxyEnergyHandler;
import com.hbm.api.energy.fe.TransmitHelper;
import com.hbm.block.machine.BlockAssembler;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base.BedLikeBlockEntity;
import com.hbm.capabilities.HBMCaps;
import com.hbm.gui.menu.AssemblerMenu;
import com.hbm.utils.InventoryUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssemblerEntity
extends BedLikeBlockEntity {
    int power = 100;
    int energyCapacity = 100000;
    int countdown = 0;
    AssemblerRecipe recipeNow;
    public ItemStack showItem;
    public static final int[] ASSEMBLE_SLOTS = new int[]{5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    public static final RecipeManager.CachedCheck<Container, AssemblerRecipe> quickCheck = RecipeManager.m_220267_((RecipeType)((RecipeType)ModRecipes.ASSEMBLER.type().get()));
    static final int[] INPUT_SLOTS = IntStream.range(5, 17).toArray();
    static final int[] OUTPUT_SLOTS = new int[]{4};
    public final BasicEnergyContainer energyContainer = new BasicEnergyContainer(this.energyCapacity, this.energyCapacity, 0L);
    private final HybridEnergyStorage forgeEnergy = new HybridEnergyStorage(this.energyContainer);
    protected final ContainerData containerData = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> AssemblerEntity.this.getProgress();
                case 1 -> AssemblerEntity.this.getEnergy().getEnergyStored();
                case 2 -> AssemblerEntity.this.getEnergy().getMaxEnergyStored();
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
        }

        public int m_6499_() {
            return 3;
        }
    };

    public AssemblerEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntityType.ASSEMBLER_ENTITY.get(), pPos, pBlockState);
        this.items = NonNullList.m_122780_((int)17, (Object)ItemStack.f_41583_);
        this.capabilitiesContent.addCapability(HBMCaps.LONG_ENERGY, new ProxyEnergyHandler(this.energyContainer));
        this.capabilitiesContent.addCapability(ForgeCapabilities.ENERGY, this.forgeEnergy);
        this.multiblockData.put(ForgeCapabilities.ENERGY, -1, 0, 1, Direction.SOUTH, 0, 0, 1, Direction.SOUTH, -1, 0, -2, Direction.NORTH, 0, 0, -2, Direction.NORTH).put(ForgeCapabilities.ITEM_HANDLER, 1, 0, -1, Direction.EAST, -2, 0, 0, Direction.WEST);
        this.multiblockData.transDirection(pPos, (Direction)pBlockState.m_61143_((Property)BlockAssembler.FACING));
    }

    public IEnergyStorage getEnergy() {
        return this.forgeEnergy;
    }

    @Override
    protected void onUpdateServer() {
        AssemblerRecipe recipe;
        super.onUpdateServer();
        if (this.flagFormed) {
            this.setDummyCaps();
            this.flagFormed = false;
        }
        AssemblerEntity.runDummyCaps(this.f_58857_, this.m_58899_(), this.m_58900_(), this);
        AssemblerEntity.absorbBatteryItem(this);
        AssemblerEntity.transportItem(this);
        boolean flagEmpty = this.craftSlotEmpty();
        if (this.running) {
            if (this.recipeNow == null) {
                AssemblerEntity.stopMachine(this);
            } else if (this.countdown == 0) {
                this.running = false;
                ItemStack resultItem = this.recipeNow.m_5874_((Container)this, this.f_58857_.m_9598_());
                AssemblerEntity.processOutput(this, resultItem);
            } else if (this.checkRecipe() && this.consumeEnergy(this.power, true)) {
                --this.countdown;
                this.consumeEnergy(this.power, false);
            } else {
                AssemblerEntity.stopMachine(this);
            }
        } else if (!flagEmpty && this.canProcess(recipe = (AssemblerRecipe)quickCheck.m_213657_((Container)this, this.f_58857_).orElse(null), this)) {
            AssemblerEntity.startMachine(this, recipe);
        }
        this.sendUpdatePacket();
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("running", this.running);
        if (this.recipeNow != null) {
            tag.m_128365_("resultItem", (Tag)this.recipeNow.m_8043_(this.m_58904_().m_9598_()).serializeNBT());
        }
        return super.getReducedUpdateTag().m_128391_(tag);
    }

    @Override
    public void handleUpdatePacket(@NotNull CompoundTag tag) {
        super.handleUpdatePacket(tag);
        this.running = tag.m_128471_("running");
        if (tag.m_128441_("resultItem")) {
            this.showItem = ItemStack.m_41712_((CompoundTag)((CompoundTag)tag.m_128423_("resultItem")));
        }
    }

    public static void startMachine(AssemblerEntity entity, AssemblerRecipe recipe) {
        entity.countdown = recipe.getProcessingTime();
        entity.recipeNow = recipe;
        entity.running = true;
    }

    public static void stopMachine(AssemblerEntity entity) {
        entity.running = false;
        entity.countdown = 0;
    }

    public static void processOutput(AssemblerEntity entity, ItemStack itemStack) {
        ItemStack resultStack = (ItemStack)entity.items.get(4);
        if (resultStack.m_41619_()) {
            entity.items.set(4, (Object)itemStack);
        } else {
            resultStack.m_41764_(resultStack.m_41613_() + itemStack.m_41613_());
            entity.items.set(4, (Object)resultStack);
        }
    }

    public static void absorbBatteryItem(AssemblerEntity entity) {
        ItemStack itemStack = (ItemStack)entity.items.get(0);
        TransmitHelper.dischargeItem(entity, itemStack);
    }

    public static void transportItem(AssemblerEntity entity) {
        if (entity.m_58898_()) {
            List<Tuple<BlockPos, Direction>> tuples = entity.multiblockData.afterTrans.get(ForgeCapabilities.ITEM_HANDLER);
            if (entity.recipeNow != null) {
                InventoryUtils.extractItem(entity.f_58857_, entity, (BlockPos)tuples.get(0).m_14418_(), Arrays.stream(INPUT_SLOTS).boxed().toList(), (Direction)tuples.get(0).m_14419_(), itemStack -> entity.recipeNow.checkItem((ItemStack)itemStack));
            }
            InventoryUtils.insertItem(entity, (BlockPos)tuples.get(1).m_14418_(), Arrays.stream(OUTPUT_SLOTS).boxed().toList(), (Direction)tuples.get(1).m_14419_());
        }
    }

    public static void runDummyCaps(Level level, BlockPos pPos, BlockState pState, BlockEntity pBlockEntity) {
        AssemblerEntity assemblerEntity = (AssemblerEntity)pBlockEntity;
        List<Tuple<BlockPos, Direction>> tupleList = assemblerEntity.multiblockData.afterTrans.get(ForgeCapabilities.ENERGY);
        for (Tuple<BlockPos, Direction> tuple : tupleList) {
            BlockPos dummyPos = (BlockPos)tuple.m_14418_();
            TransmitHelper.machineTransmit(level, dummyPos, level.m_8055_(dummyPos), level.m_7702_(dummyPos));
        }
    }

    private boolean craftSlotEmpty() {
        for (int i = 5; i < 17; ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            return false;
        }
        return true;
    }

    private int getProgress() {
        return this.running && this.recipeNow != null ? (int)Math.ceil((1.0 - (double)this.countdown / (double)this.recipeNow.getProcessingTime()) * 83.0) : 0;
    }

    public boolean checkRecipe() {
        return this.recipeNow != null && this.recipeNow.m_5818_((Container)this, this.f_58857_);
    }

    public boolean canProcess(@Nullable AssemblerRecipe recipe, AssemblerEntity entity) {
        if (recipe == null) {
            return false;
        }
        ItemStack resultStack = (ItemStack)entity.items.get(4);
        ItemStack resultItem = recipe.m_8043_(this.f_58857_.m_9598_());
        int energyToUse = recipe.getProcessingTime() * entity.power;
        return (resultStack.m_41619_() || resultStack.m_150930_(resultItem.m_41720_()) && resultStack.m_41613_() + resultItem.m_41613_() < resultStack.m_41741_()) && entity.consumeEnergy(energyToUse, true);
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)"hbm.machine.assembler");
    }

    @Override
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory) {
        return new AssemblerMenu(pContainerId, pInventory, (Container)this, this.containerData);
    }

    @Override
    public int[] m_7071_(Direction pSide) {
        return new int[0];
    }

    @Override
    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return false;
    }

    @Override
    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return false;
    }

    public void onLoad() {
        super.onLoad();
        this.setDummyCaps();
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.capabilitiesContent.invalidateAll();
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("countDown", this.countdown);
        pTag.m_128365_("energy", (Tag)this.energyContainer.serializeNBT());
        if (this.recipeNow != null) {
            pTag.m_128359_("recipeNow", this.recipeNow.m_6423_().toString());
        }
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.countdown = pTag.m_128451_("countDown");
        if (pTag.m_128441_("energy")) {
            this.energyContainer.deserializeNBT(pTag.m_128469_("energy"));
        }
        if (pTag.m_128441_("recipeNow")) {
            ResourceLocation resourceLocation = new ResourceLocation(pTag.m_128461_("recipeNow"));
            this.recipeNow = this.f_58857_.m_7465_().m_44043_(resourceLocation).orElse(null);
        }
    }

    public void setDummyCaps() {
        if (!this.m_58898_() || !this.f_58857_.m_5776_()) {
            // empty if block
        }
    }

    private boolean consumeEnergy(long amount, boolean simulate) {
        if (amount <= 0L) {
            return true;
        }
        long stored = this.energyContainer.getEnergy();
        if (stored < amount) {
            return false;
        }
        if (!simulate) {
            this.energyContainer.setEnergy(stored - amount);
            this.energyContainer.onContentsChanged();
        }
        return true;
    }
}

