/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine;

import com.hbm.HBMLang;
import com.hbm.api.Mode;
import com.hbm.api.fluid.SingleFluidHandler;
import com.hbm.block.machine.BlockFluidBarrel;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.BaseMachineBlockEntity;
import com.hbm.gui.menu.BarrelMenu;
import com.hbm.gui.menu.IPacketUpdate;
import com.hbm.utils.EnumUtils;
import com.hbm.utils.InventoryUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BarrelEntity
extends BaseMachineBlockEntity
implements IPacketUpdate,
MenuProvider {
    BlockFluidBarrel.BarrelProperties properties;
    private final SingleFluidHandler fluidHandler;
    public int[] slotIn = new int[]{0, 2};
    public int[] slotOut = new int[]{1, 3};
    private final ContainerData containerData = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> BarrelEntity.this.fluidHandler.getMode().ordinal();
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
        }

        public int m_6499_() {
            return 1;
        }
    };

    public BarrelEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntityType.BARREL_ENTITY.get(), pPos, pBlockState);
        this.items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
        this.properties = ((BlockFluidBarrel)pBlockState.m_60734_()).barrelProperties;
        this.fluidHandler = new SingleFluidHandler(this.properties.capacity, Mode.OUTPUT);
        this.capabilitiesContent.addCapability(ForgeCapabilities.FLUID_HANDLER, this.fluidHandler);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        InventoryUtils.handleItems(this, this.fluidHandler::drainItem, 0, 1);
        InventoryUtils.handleItems(this, this.fluidHandler::fillItem, 2, 3);
        if (this.fluidHandler.allowOutput(0)) {
            for (Direction direction : EnumUtils.DIRECTIONS) {
                BlockEntity neighbour;
                if (!this.m_58898_() || (neighbour = this.m_58904_().m_7702_(this.m_58899_().m_121945_(direction))) == null) continue;
                neighbour.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_()).ifPresent(handler -> {
                    int maxDrain = this.fluidHandler.getFluidInTank(0).getAmount() / 10;
                    FluidStack fluidStack = this.fluidHandler.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE);
                    int filled = handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    this.fluidHandler.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                });
            }
        }
        this.sendUpdatePacket();
    }

    boolean allowContainerTrans(ItemStack item1, ItemStack item2) {
        if (item2.m_41619_()) {
            return true;
        }
        if (item1.m_41619_() || item2.m_41613_() == item2.m_41741_()) {
            return false;
        }
        if (item1.m_41720_() instanceof BucketItem && item2.m_150930_(Items.f_42446_)) {
            return true;
        }
        return true;
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128365_("fluids", (Tag)this.fluidHandler.serializeNBT());
        return super.getReducedUpdateTag().m_128391_(compoundTag);
    }

    @Override
    public void handleUpdatePacket(@NotNull CompoundTag tag) {
        super.handleUpdatePacket(tag);
        this.fluidHandler.deserializeNBT(tag.m_128469_("fluids"));
    }

    @Override
    public void handleClientPacket(@NotNull CompoundTag tag) {
        super.handleClientPacket(tag);
        this.fluidHandler.setMode(Mode.values()[tag.m_128451_("mode")]);
    }

    public List<FluidTank> getFluidTanks() {
        return this.fluidHandler.getFluidTanks();
    }

    public Mode getMode() {
        return this.fluidHandler.getMode();
    }

    public void setMode(Mode mode) {
        this.fluidHandler.setMode(mode);
    }

    @Override
    public int[] m_7071_(Direction pSide) {
        return pSide == Direction.DOWN ? this.slotOut : this.slotIn;
    }

    @Override
    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        if (pDirection == null) {
            return true;
        }
        return (pIndex == 0 || pIndex == 2) && pDirection != Direction.DOWN;
    }

    @Override
    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        if (pDirection == null) {
            return true;
        }
        return (pIndex == 1 || pIndex == 3) && pDirection == Direction.DOWN;
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)HBMLang.BARREL.key());
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory) {
        return new BarrelMenu(pContainerId, pPlayerInventory, (Container)this, this.containerData);
    }

    public int getRate() {
        return Integer.MAX_VALUE;
    }
}

