/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine;

import com.hbm.HBMLang;
import com.hbm.api.energy.BasicEnergyContainer;
import com.hbm.api.energy.HybridEnergyStorage;
import com.hbm.api.energy.ProxyEnergyHandler;
import com.hbm.api.energy.TransmitUtils;
import com.hbm.block.machine.BlockBattery;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.BaseMachineBlockEntity;
import com.hbm.capabilities.HBMCaps;
import com.hbm.gui.menu.BatteryMenu;
import com.hbm.registries.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatteryEntity
extends BaseMachineBlockEntity {
    public final BlockBattery.BatteryType type;
    public int redLow = 0;
    public int redHeight = 2;
    public int connPriority = 0;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    private BasicEnergyContainer energyContainer;
    protected final ContainerData containerData = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> BatteryEntity.this.redLow;
                case 1 -> BatteryEntity.this.redHeight;
                case 2 -> BatteryEntity.this.connPriority;
                case 3 -> (int)BatteryEntity.this.energyContainer.getEnergy();
                case 4 -> (int)(BatteryEntity.this.energyContainer.getEnergy() >> 32);
                case 5 -> (int)BatteryEntity.this.energyContainer.getCapacity();
                case 6 -> (int)(BatteryEntity.this.energyContainer.getCapacity() >> 32);
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    BatteryEntity.this.redLow = pValue;
                    break;
                }
                case 1: {
                    BatteryEntity.this.redHeight = pValue;
                    break;
                }
                case 2: {
                    BatteryEntity.this.connPriority = pValue;
                }
            }
        }

        public int m_6499_() {
            return 7;
        }
    };
    private double[] powerWeight = new double[]{0.8, 0.5, 0.2};

    public BatteryEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntityType.BATTERY_ENTITY.get(), pPos, pBlockState);
        this.items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
        BlockBattery block = (BlockBattery)pBlockState.m_60734_();
        this.type = block.type;
        this.energyContainer = new BasicEnergyContainer(this.type.getMaxEnergy(), this.type.getOutput());
        ProxyEnergyHandler handler = new ProxyEnergyHandler(this.energyContainer);
        this.capabilitiesContent.addCapability(HBMCaps.LONG_ENERGY, handler);
        this.capabilitiesContent.addCapability(ForgeCapabilities.ENERGY, new HybridEnergyStorage(this.energyContainer));
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        BlockState blockState = this.m_58900_();
        TransmitUtils.outputOnly(this);
        ItemStack itemStack0 = this.getStackInSlot(0);
        ItemStack itemStack1 = this.getStackInSlot(1);
        TransmitUtils.dischargeItem(this, itemStack0);
        TransmitUtils.chargeItem(this, itemStack1);
        this.f_58857_.m_7260_(this.f_58858_, blockState, blockState, 2);
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.items != null) {
            ContainerHelper.m_18973_((CompoundTag)pTag, (NonNullList)this.items);
        }
        pTag.m_128365_("energy", (Tag)this.energyContainer.serializeNBT());
        pTag.m_128405_("redLow", this.redLow);
        pTag.m_128405_("redHeight", this.redHeight);
        pTag.m_128405_("connPriority", this.connPriority);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (this.items != null) {
            this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)pTag, (NonNullList)this.items);
        }
        this.energyContainer.deserializeNBT(pTag.m_128469_("energy"));
        this.redLow = pTag.m_128451_("redLow");
        this.redHeight = pTag.m_128451_("redHeight");
        this.connPriority = pTag.m_128451_("connPriority");
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        return updateTag;
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)HBMLang.BARREL.key());
    }

    @Override
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory) {
        return new BatteryMenu(pContainerId, pInventory, (Container)this, this.containerData);
    }

    @Override
    public int[] m_7071_(Direction pSide) {
        if (pSide == Direction.UP) {
            return SLOTS_FOR_UP;
        }
        if (pSide == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return SLOTS_FOR_SIDES;
    }

    @Override
    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return ((ItemStack)this.items.get(pIndex)).m_41619_() && pItemStack.m_204117_(ModTags.Items.BATTERY);
    }

    @Override
    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        if (pIndex == 1 && pDirection == Direction.DOWN) {
            return pStack.m_204117_(ModTags.Items.BATTERY);
        }
        return true;
    }
}

