/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine;

import com.hbm.HBMLang;
import com.hbm.Inventory.UpgradeManagerNT;
import com.hbm.Inventory.recipe.ChemplantRecipe;
import com.hbm.Inventory.recipe.HBMRecipeMatcher;
import com.hbm.Inventory.recipe.ModRecipes;
import com.hbm.api.Mode;
import com.hbm.api.energy.BasicEnergyContainer;
import com.hbm.api.energy.HybridEnergyStorage;
import com.hbm.api.energy.ProxyEnergyHandler;
import com.hbm.api.energy.TransmitUtils;
import com.hbm.api.fluid.BasicFluidHandler;
import com.hbm.api.fluid.IExtendedFluidHandler;
import com.hbm.api.fluid.VisitRestrictWrapper;
import com.hbm.api.inventory.ModeBuilder;
import com.hbm.api.math.MathUtils;
import com.hbm.block.HBMMachine;
import com.hbm.block.machine.BlockChemplant;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.DummyableBlockEntity;
import com.hbm.blockentity.base2.TileProxyBase;
import com.hbm.capabilities.HBMCaps;
import com.hbm.gui.menu.ChemplantMenu;
import com.hbm.item.machine.ItemMachineUpgrade;
import com.hbm.registries.ModSounds;
import com.hbm.utils.DirectionUtils;
import com.hbm.utils.InventoryUtils;
import com.hbm.utils.multiblock.MultiblockData;
import com.hbm.utils.sound.AudioWrapper;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChemplantEntity
extends DummyableBlockEntity {
    private static final int maxFluid = 24000;
    public int maxProgress = 100;
    public int progress = 0;
    int consumption = 100;
    int speed = 100;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT();
    private BasicEnergyContainer energyContainer = new BasicEnergyContainer(100100L);
    private final HybridEnergyStorage forgeEnergy = new HybridEnergyStorage(this.energyContainer);
    private BasicFluidHandler fluidHandler;
    private final RecipeManager.CachedCheck<Container, ChemplantRecipe> recipeChecker = RecipeManager.m_220267_((RecipeType)((RecipeType)ModRecipes.CHEMPLANT.type().get()));
    private ChemplantRecipe recipeNow = null;
    private static AudioWrapper audioWrapper;
    protected final ContainerData containerData = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> ChemplantEntity.this.getProgress();
                case 1 -> ChemplantEntity.this.maxProgress;
                case 2 -> MathUtils.clampToInt(ChemplantEntity.this.energyContainer.getEnergy());
                case 3 -> MathUtils.clampToInt(ChemplantEntity.this.energyContainer.getCapacity());
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
        }

        public int m_6499_() {
            return 4;
        }
    };

    public ChemplantEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntityType.CHEMPLANT_ENTITY.get(), pPos, pBlockState);
        this.items = NonNullList.m_122780_((int)20, (Object)ItemStack.f_41583_);
        this.slotModes = new ModeBuilder().addModes(new Object[]{4, Mode.BOTH, 4, Mode.OUTPUT, 2, Mode.INPUT, 2, Mode.OUTPUT, 6, Mode.INPUT, 2, Mode.OUTPUT}).get();
        this.fluidHandler = new BasicFluidHandler().addTanks(2, 24000, Mode.INPUT).addTanks(2, 24000, Mode.OUTPUT);
        this.capabilitiesContent.addCapability(ForgeCapabilities.FLUID_HANDLER, this.fluidHandler);
        this.capabilitiesContent.addCapability(HBMCaps.LONG_ENERGY, new ProxyEnergyHandler(this.energyContainer));
        this.capabilitiesContent.addCapability(ForgeCapabilities.ENERGY, this.forgeEnergy);
        this.multiblockData = MultiblockData.mapping.get(HBMMachine.CHEMPLANT.get());
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        TransmitUtils.dischargeItem(this, this.m_8020_(0));
        InventoryUtils.handleItems(this, itemStack -> this.fluidHandler.drainItem(0, (ItemStack)itemStack), 16, 18);
        InventoryUtils.handleItems(this, itemStack -> this.fluidHandler.drainItem(1, (ItemStack)itemStack), 17, 19);
        InventoryUtils.handleItems(this, itemStack -> this.fluidHandler.fillItem(2, (ItemStack)itemStack), 8, 10);
        InventoryUtils.handleItems(this, itemStack -> this.fluidHandler.fillItem(3, (ItemStack)itemStack), 9, 11);
        this.upgradeManager.checkSlots(this, (NonNullList<ItemStack>)this.items, 3, 3);
        int speedLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
        int powerLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER);
        int overLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE);
        this.speed = Math.max((100 - speedLevel * 25 + powerLevel * 5) / (overLevel + 1), 1);
        this.consumption = (100 + speedLevel * 300 - powerLevel * 20) * (overLevel + 1);
        if (!this.canProcess()) {
            this.progress = 0;
        } else {
            this.energyContainer.extract(this.consumption, false);
            this.maxProgress = Math.max(this.recipeNow.getDuration() * this.speed / 100, 1);
            ++this.progress;
            if (this.progress >= this.maxProgress) {
                this.recipeNow.assemble((Container)this);
                this.progress = 0;
                this.markForSave();
            }
        }
        this.sendUpdatePacket();
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        int effectRange = 100;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer == null || this.f_58857_ == null) {
            return;
        }
        double dist = localPlayer.m_20238_(this.f_58858_.m_252807_());
        if (dist < (double)effectRange && this.progress > 0 && this.f_58857_.m_46467_() % 3L == 0L) {
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockChemplant.FACING);
            Direction rot = DirectionUtils.horizRot(Direction.SOUTH, facing, Direction.EAST);
            double x = (double)this.m_58899_().m_123341_() + 0.5 + (double)facing.m_122429_() * 1.125 + (double)rot.m_122429_() * 0.125;
            double y = this.m_58899_().m_123342_() + 3;
            double z = (double)this.m_58899_().m_123343_() + 0.5 + (double)facing.m_122431_() * 1.125 + (double)rot.m_122431_() * 0.125;
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.1, 0.0);
        }
        AudioWrapper audioWrapper = ChemplantEntity.audioWrapper = ChemplantEntity.audioWrapper == null ? this.createAudioLoop() : ChemplantEntity.audioWrapper;
        if (dist < (double)ChemplantEntity.audioWrapper.range) {
            float volume = this.getVolume(1.0f);
            if (this.progress > 0 && volume > 0.0f) {
                ChemplantEntity.audioWrapper.volume = volume;
                ChemplantEntity.audioWrapper.playLoopSound(localPlayer.m_20182_(), this.f_58857_.m_213780_().m_188505_());
            } else {
                ChemplantEntity.audioWrapper.stopLoopSound();
            }
        }
    }

    protected AudioWrapper createAudioLoop() {
        return new AudioWrapper((SoundEvent)ModSounds.BLOCK_CHEMPLANT_OPERATE.get(), SoundSource.BLOCKS);
    }

    private boolean canProcess() {
        if (this.energyContainer.getEnergy() < (long)this.consumption) {
            return false;
        }
        ChemplantRecipe recipe = this.recipeChecker.m_213657_((Container)this, this.f_58857_).orElse(null);
        if (recipe == null) {
            return false;
        }
        if (!HBMRecipeMatcher.checkOutputSlots(this.items.subList(4, 8), recipe.resultItems) || !HBMRecipeMatcher.checkOutputTanks(this.fluidHandler.getFluidTanks().subList(2, 4), recipe.resultFLuids)) {
            return false;
        }
        if (this.recipeNow == null || !this.recipeNow.equals(recipe)) {
            this.recipeNow = recipe;
            this.progress = 0;
        }
        return true;
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("fluids", (Tag)this.fluidHandler.serializeNBT());
        tag.m_128405_("progress", this.progress);
        return tag;
    }

    @Override
    public void handleUpdatePacket(@NotNull CompoundTag tag) {
        super.handleUpdatePacket(tag);
        this.fluidHandler.deserializeNBT(tag.m_128469_("fluids"));
        this.progress = tag.m_128451_("progress");
    }

    @Override
    public void giveProxyCapabilities(Vec3i offset, TileProxyBase proxy, Capability<?> cap, Set<Direction> directions) {
        if (offset.equals((Object)new Vec3i(-1, 0, 1)) || offset.equals((Object)new Vec3i(-1, 0, -2))) {
            if (cap == ForgeCapabilities.FLUID_HANDLER) {
                proxy.capabilitiesContent.addCapability(cap, new VisitRestrictWrapper((IExtendedFluidHandler)this.fluidHandler, 2), directions);
                proxy.lookTooltip = Component.m_237110_((String)HBMLang.LOOKTOOLTIP_CHEMPLANT.key(), (Object[])new Object[]{2});
                proxy.sendUpdatePacket();
            } else if (cap == HBMCaps.LONG_ENERGY) {
                proxy.capabilitiesContent.addCapability(cap, this.energyContainer, directions);
            }
        } else if (offset.equals((Object)new Vec3i(0, 0, 1)) || offset.equals((Object)new Vec3i(0, 0, -2))) {
            if (cap == ForgeCapabilities.FLUID_HANDLER) {
                proxy.capabilitiesContent.addCapability(cap, new VisitRestrictWrapper((IExtendedFluidHandler)this.fluidHandler, 3), directions);
                proxy.lookTooltip = Component.m_237110_((String)HBMLang.LOOKTOOLTIP_CHEMPLANT.key(), (Object[])new Object[]{2});
                proxy.sendUpdatePacket();
            } else if (cap == HBMCaps.LONG_ENERGY) {
                proxy.capabilitiesContent.addCapability(cap, this.energyContainer, directions);
            }
        } else {
            this.getCapability(cap).ifPresent(handler -> proxy.capabilitiesContent.addCapability(cap, handler, directions));
        }
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("recipe_now")) {
            ResourceLocation resourceLocation = new ResourceLocation(nbt.m_128461_("recipe_now"));
            this.recipeNow = this.f_58857_.m_7465_().m_44043_(resourceLocation).orElse(null);
        }
        this.energyContainer.deserializeNBT(nbt.m_128469_("energy"));
        this.fluidHandler.deserializeNBT(nbt.m_128469_("fluids"));
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.recipeNow != null) {
            pTag.m_128359_("recipe_now", this.recipeNow.m_6423_().toString());
        }
        pTag.m_128365_("energy", (Tag)this.energyContainer.serializeNBT());
        pTag.m_128365_("fluids", (Tag)this.fluidHandler.serializeNBT());
    }

    public List<FluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidHandler.getFluidTanks();
    }

    @Override
    public BasicEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    protected int getProgress() {
        return Math.max(0, this.progress);
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)HBMLang.CHEMPLANT.key());
    }

    @Override
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory) {
        return new ChemplantMenu(pContainerId, pInventory, (Container)this, this.containerData);
    }
}

