/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine;

import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.BaseMachineBlockEntity;
import com.hbm.blockentity.machine.component.CondenserLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CondenserBlockEntity
extends BaseMachineBlockEntity {
    private static final int STEAM_CAPACITY = 8000;
    private static final int WATER_CAPACITY = 8000;
    private static final int CONVERSION_RATE = 200;
    private final CondenserLogic logic;

    public CondenserBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.CONDENSER_ENTITY.get(), pos, state);
        this.items = NonNullList.m_122780_((int)0, (Object)ItemStack.f_41583_);
        this.slotModes = NonNullList.m_122779_();
        this.logic = new CondenserLogic(8000, 8000, 200);
        this.capabilitiesContent.addCapability(ForgeCapabilities.FLUID_HANDLER, this.logic.handler());
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.f_58857_ != null && this.logic.tick(this.f_58857_)) {
            this.m_6596_();
            this.sendUpdatePacket();
        }
    }

    public IFluidHandler getFluidHandler() {
        return this.logic.handler();
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("fluids", (Tag)this.logic.serializeNBT());
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("fluids")) {
            this.logic.deserializeNBT(tag.m_128469_("fluids"));
        }
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag tag = super.getReducedUpdateTag();
        this.logic.writeSyncTag(tag);
        return tag;
    }

    @Override
    public void handleUpdatePacket(@NotNull CompoundTag tag) {
        super.handleUpdatePacket(tag);
        this.logic.readSyncTag(tag);
    }

    @Override
    public Component m_5446_() {
        return this.getDefaultName();
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return null;
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)"block.hbm.machine_condenser");
    }
}

