/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine;

import com.hbm.api.fluid.IExtendedFluidHandler;
import com.hbm.api.fluid.VisitRestrictWrapper;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.DummyableBlockEntity;
import com.hbm.blockentity.base2.TileProxyBase;
import com.hbm.blockentity.machine.component.CondenserLogic;
import com.hbm.registries.ModBlocks;
import com.hbm.utils.multiblock.MultiblockData;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoolingTowerBlockEntity
extends DummyableBlockEntity {
    private static final int STEAM_CAPACITY = 24000;
    private static final int WATER_CAPACITY = 24000;
    private static final int CONVERSION_RATE = 800;
    private static final Set<Vec3i> STEAM_PORTS = new HashSet<Vec3i>();
    private static final Set<Vec3i> WATER_PORTS = new HashSet<Vec3i>();
    private final CondenserLogic logic = new CondenserLogic(24000, 24000, 800);

    public CoolingTowerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.COOLING_TOWER_ENTITY.get(), pos, state);
        this.capabilitiesContent.addCapability(ForgeCapabilities.FLUID_HANDLER, this.logic.handler());
        this.multiblockData = MultiblockData.mapping.get(ModBlocks.machine_cooling_tower.get());
        this.isFormed = true;
    }

    private static void registerRing(Set<Vec3i> set, int radiusOffset, int yOffset) {
        int radius = 4 + radiusOffset;
        int inner = 3 + radiusOffset;
        set.add(new Vec3i(radius, yOffset, 0));
        set.add(new Vec3i(-radius, yOffset, 0));
        set.add(new Vec3i(0, yOffset, radius));
        set.add(new Vec3i(0, yOffset, -radius));
        set.add(new Vec3i(inner, yOffset, inner));
        set.add(new Vec3i(-inner, yOffset, inner));
        set.add(new Vec3i(inner, yOffset, -inner));
        set.add(new Vec3i(-inner, yOffset, -inner));
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.f_58857_ != null && this.logic.tick(this.f_58857_)) {
            this.m_6596_();
            this.sendUpdatePacket();
        }
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        if (this.f_58857_ == null || this.logic.getWaterTimer() <= 0) {
            return;
        }
        if (this.f_58857_.f_46441_.m_188503_(4) != 0) {
            return;
        }
        double x = (double)this.f_58858_.m_123341_() + 0.5 + (this.f_58857_.f_46441_.m_188500_() - 0.5) * 2.5;
        double y = (double)(this.f_58858_.m_123342_() + 6) + this.f_58857_.f_46441_.m_188500_() * 4.0;
        double z = (double)this.f_58858_.m_123343_() + 0.5 + (this.f_58857_.f_46441_.m_188500_() - 0.5) * 2.5;
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 0.0, 0.02, 0.0);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("fluids", (Tag)this.logic.serializeNBT());
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("fluids")) {
            this.logic.deserializeNBT(tag.m_128469_("fluids"));
        }
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag tag = super.getReducedUpdateTag();
        this.logic.writeSyncTag(tag);
        return tag;
    }

    @Override
    public void handleUpdatePacket(@NotNull CompoundTag tag) {
        super.handleUpdatePacket(tag);
        this.logic.readSyncTag(tag);
    }

    @Override
    public Component m_5446_() {
        return this.getDefaultName();
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return null;
    }

    @Override
    public void giveProxyCapabilities(Vec3i offset, TileProxyBase proxy, Capability<?> cap, Set<Direction> directions) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (STEAM_PORTS.contains(offset)) {
                proxy.capabilitiesContent.addCapability(cap, new VisitRestrictWrapper((IExtendedFluidHandler)this.logic.handler(), false, 0), directions);
                return;
            }
            if (WATER_PORTS.contains(offset)) {
                proxy.capabilitiesContent.addCapability(cap, new VisitRestrictWrapper((IExtendedFluidHandler)this.logic.handler(), false, 1), directions);
                return;
            }
        }
        super.giveProxyCapabilities(offset, proxy, cap, directions);
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)"block.hbm.machine_cooling_tower");
    }

    static {
        CoolingTowerBlockEntity.registerRing(STEAM_PORTS, 0, 0);
        CoolingTowerBlockEntity.registerRing(WATER_PORTS, 0, 1);
    }
}

