/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine;

import com.hbm.Inventory.fluid.ModFluids;
import com.hbm.Inventory.recipe.CrackingRecipes;
import com.hbm.api.Mode;
import com.hbm.api.fluid.BasicFluidHandler;
import com.hbm.api.fluid.IExtendedFluidHandler;
import com.hbm.api.fluid.VisitRestrictWrapper;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.DummyableBlockEntity;
import com.hbm.blockentity.base2.TileProxyBase;
import com.hbm.registries.ModBlocks;
import com.hbm.utils.multiblock.MultiblockData;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class CrackingTowerEntity
extends DummyableBlockEntity {
    private static final int FEED_TANK = 0;
    private static final int STEAM_TANK = 1;
    private static final int OUTPUT_PRIMARY = 2;
    private static final int OUTPUT_SECONDARY = 3;
    private static final int OUTPUT_SPENT = 4;
    private static final Vec3i PORT_FEED = new Vec3i(0, 0, -2);
    private static final Vec3i PORT_STEAM = new Vec3i(2, 0, 0);
    private static final Vec3i PORT_OUTPUT_PRIMARY = new Vec3i(0, 0, 2);
    private static final Vec3i PORT_OUTPUT_SECONDARY = new Vec3i(-2, 0, 0);
    private static final Vec3i PORT_SPENT = new Vec3i(1, 0, 2);
    private final BasicFluidHandler fluidHandler;
    private int tickCounter;

    public CrackingTowerEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.CRACKING_TOWER_ENTITY.get(), pos, state);
        this.items = NonNullList.m_122780_((int)0, (Object)ItemStack.f_41583_);
        this.slotModes = List.of();
        this.fluidHandler = new BasicFluidHandler().addTank(4000, Mode.INPUT).addTank(8000, Mode.INPUT).addTank(4000, Mode.OUTPUT).addTank(4000, Mode.OUTPUT).addTank(1000, Mode.OUTPUT);
        this.capabilitiesContent.addCapability(ForgeCapabilities.FLUID_HANDLER, this.fluidHandler);
        this.multiblockData = MultiblockData.mapping.get(ModBlocks.machine_cracking_tower.get());
        this.isFormed = true;
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (!this.isFormed || this.f_58857_ == null) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter % 5 == 0) {
            this.process();
        }
        this.sendUpdatePacket();
    }

    private void process() {
        List<FluidTank> tanks = this.fluidHandler.getFluidTanks();
        FluidTank feed = tanks.get(0);
        FluidTank steam = tanks.get(1);
        if (feed.getFluidAmount() < 100 || steam.getFluidAmount() < 200) {
            return;
        }
        Optional<CrackingRecipes.RecipeOutput> recipeOpt = CrackingRecipes.get(feed.getFluid().getFluid());
        if (recipeOpt.isEmpty()) {
            return;
        }
        CrackingRecipes.RecipeOutput recipe = recipeOpt.get();
        if (!this.hasSpace(recipe)) {
            return;
        }
        feed.drain(100, IFluidHandler.FluidAction.EXECUTE);
        steam.drain(200, IFluidHandler.FluidAction.EXECUTE);
        this.fillTank(2, recipe.left());
        this.fillTank(3, recipe.right());
        this.fillTank(4, new FluidStack((Fluid)ModFluids.SPENT_STEAM.source().get(), 2));
    }

    private boolean hasSpace(CrackingRecipes.RecipeOutput recipe) {
        return this.canAccept(2, recipe.left()) && this.canAccept(3, recipe.right()) && this.canAccept(4, new FluidStack((Fluid)ModFluids.SPENT_STEAM.source().get(), 2));
    }

    private boolean canAccept(int tankIndex, FluidStack stack) {
        if (stack.isEmpty()) {
            return true;
        }
        FluidTank tank = this.fluidHandler.getFluidTanks().get(tankIndex);
        if (tank.isEmpty()) {
            return tank.getCapacity() >= stack.getAmount();
        }
        return tank.getFluid().isFluidEqual(stack) && tank.getSpace() >= stack.getAmount();
    }

    private void fillTank(int tankIndex, FluidStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        FluidTank tank = this.fluidHandler.getFluidTanks().get(tankIndex);
        tank.fill(stack.copy(), IFluidHandler.FluidAction.EXECUTE);
    }

    public BasicFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)"block.hbm.machine_cracking_tower");
    }

    @Override
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory) {
        return null;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("fluids", (Tag)this.fluidHandler.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.fluidHandler.deserializeNBT(tag.m_128469_("fluids"));
    }

    @Override
    public CompoundTag getReducedUpdateTag() {
        CompoundTag tag = super.getReducedUpdateTag();
        tag.m_128365_("fluids", (Tag)this.fluidHandler.serializeNBT());
        return tag;
    }

    @Override
    public void handleUpdatePacket(CompoundTag tag) {
        super.handleUpdatePacket(tag);
        if (tag.m_128441_("fluids")) {
            this.fluidHandler.deserializeNBT(tag.m_128469_("fluids"));
        }
    }

    @Override
    public void giveProxyCapabilities(Vec3i offset, TileProxyBase proxy, Capability<?> cap, Set<Direction> directions) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            VisitRestrictWrapper wrapper = null;
            if (offset.equals((Object)PORT_FEED)) {
                wrapper = new VisitRestrictWrapper((IExtendedFluidHandler)this.fluidHandler, false, 0);
            } else if (offset.equals((Object)PORT_STEAM)) {
                wrapper = new VisitRestrictWrapper((IExtendedFluidHandler)this.fluidHandler, false, 1);
            } else if (offset.equals((Object)PORT_OUTPUT_PRIMARY)) {
                wrapper = new VisitRestrictWrapper((IExtendedFluidHandler)this.fluidHandler, false, 2);
            } else if (offset.equals((Object)PORT_OUTPUT_SECONDARY)) {
                wrapper = new VisitRestrictWrapper((IExtendedFluidHandler)this.fluidHandler, false, 3);
            } else if (offset.equals((Object)PORT_SPENT)) {
                wrapper = new VisitRestrictWrapper((IExtendedFluidHandler)this.fluidHandler, false, 4);
            }
            if (wrapper != null) {
                proxy.capabilitiesContent.addCapability(cap, wrapper, directions);
                return;
            }
        }
        super.giveProxyCapabilities(offset, proxy, cap, directions);
    }
}

