/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine;

import com.hbm.Inventory.recipe.BlastFurnaceRecipe;
import com.hbm.block.machine.BlockDifurnace;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.gui.menu.DifurnaceMenu;
import com.hbm.item.HBMItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class DifurnaceEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
StackedContentsCompatible {
    public int progress = 0;
    public int fuel = 0;
    public static final int maxFuel = 12800;
    public static final int maxProcess = 400;
    private static final int[] slots = new int[]{0, 1, 2, 3};
    public NonNullList<ItemStack> items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    public static Map<ItemLike, Integer> fuelPower = new HashMap<ItemLike, Integer>();
    public static final RecipeManager.CachedCheck<Container, BlastFurnaceRecipe> quickCheck = RecipeManager.m_220267_((RecipeType)BlastFurnaceRecipe.Type.INSTANCE);
    protected final ContainerData containerData = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> DifurnaceEntity.this.progress;
                case 1 -> DifurnaceEntity.this.fuel;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    DifurnaceEntity.this.progress = pValue;
                    break;
                }
                case 1: {
                    DifurnaceEntity.this.fuel = pValue;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public DifurnaceEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntityType.DIFURNACE_ENTITY.get(), pPos, pBlockState);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("progress", this.progress);
        pTag.m_128405_("fuel", this.fuel);
        ContainerHelper.m_18973_((CompoundTag)pTag, this.items);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)pTag, this.items);
        this.progress = pTag.m_128451_("progress");
        this.fuel = pTag.m_128451_("fuel");
    }

    public static void tick(Level level, BlockPos pPos, BlockState pState, BlockEntity pBlockEntity) {
        if (!(pBlockEntity instanceof DifurnaceEntity)) {
            return;
        }
        DifurnaceEntity entity = (DifurnaceEntity)pBlockEntity;
        if (!level.f_46443_) {
            boolean isChanged = false;
            boolean isWorking = false;
            ItemStack stack0 = (ItemStack)entity.items.get(0);
            ItemStack stack1 = (ItemStack)entity.items.get(1);
            ItemStack stack2 = (ItemStack)entity.items.get(2);
            Integer itemPower = DifurnaceEntity.getFuel(stack0);
            if (itemPower > 0 && itemPower <= 12800 - entity.fuel) {
                entity.fuel += itemPower.intValue();
                stack0.m_41764_(stack0.m_41613_() - 1);
                isChanged = true;
                if (stack0.m_41619_()) {
                    stack0 = ItemStack.f_41583_;
                }
            }
            boolean canProcess = false;
            ItemStack stack3 = (ItemStack)entity.items.get(3);
            ItemStack output = ItemStack.f_41583_;
            if (!((ItemStack)entity.items.get(1)).m_41619_() && !((ItemStack)entity.items.get(2)).m_41619_() && entity.fuel > 0 && stack3.m_41613_() < stack3.m_41741_()) {
                BlastFurnaceRecipe recipe = quickCheck.m_213657_((Container)entity, level).orElse(null);
                output = recipe.recipeItems.getZ();
                if (output.m_150930_(stack3.m_41720_()) || output.m_41613_() + stack3.m_41613_() <= stack3.m_41741_()) {
                    canProcess = true;
                }
            }
            if (canProcess) {
                ++entity.progress;
                --entity.fuel;
                if (entity.progress == 400) {
                    if (stack3.m_41619_()) {
                        entity.items.set(3, (Object)output.m_41777_());
                    } else {
                        stack3.m_41764_(stack3.m_41613_() + output.m_41613_());
                    }
                    stack1.m_41764_(stack1.m_41613_() - 1);
                    if (stack1.m_41619_()) {
                        stack1 = ItemStack.f_41583_;
                    }
                    stack2.m_41764_(stack2.m_41613_() - 1);
                    if (stack2.m_41619_()) {
                        stack2 = ItemStack.f_41583_;
                    }
                    entity.progress = 0;
                    pState = (BlockState)pState.m_61124_((Property)BlockDifurnace.LIT, (Comparable)Boolean.FALSE);
                    level.m_7731_(pPos, pState, 3);
                    isChanged = true;
                }
            } else {
                entity.progress = 0;
            }
            if (entity.progress == 1) {
                pState = (BlockState)pState.m_61124_((Property)BlockDifurnace.LIT, (Comparable)Boolean.TRUE);
                level.m_7731_(pPos, pState, 3);
                isChanged = true;
            }
            if (!canProcess && pState.m_61143_((Property)BlockDifurnace.LIT) == Boolean.TRUE) {
                pState = (BlockState)pState.m_61124_((Property)BlockDifurnace.LIT, (Comparable)Boolean.FALSE);
                level.m_7731_(pPos, pState, 3);
                isChanged = true;
            }
            if (isChanged) {
                DifurnaceEntity.m_155232_((Level)level, (BlockPos)pPos, (BlockState)pState);
            }
        }
    }

    public static int getFuel(ItemStack itemStack) {
        Integer fuel_power = fuelPower.get(itemStack.m_41720_());
        return fuel_power == null ? 0 : fuel_power;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"hbmxx.container.difurnace");
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        return new DifurnaceMenu(pContainerId, pInventory, (Container)this, this.containerData);
    }

    public int[] m_7071_(Direction pSide) {
        int[] nArray;
        if (pSide == Direction.DOWN) {
            return new int[]{3};
        }
        if (pSide == Direction.UP) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = 1;
            nArray = nArray2;
            nArray2[1] = 2;
        }
        return nArray;
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        if (pIndex == 3) {
            return false;
        }
        ItemStack itemStack = (ItemStack)this.items.get(pIndex);
        return pItemStack.m_150930_(itemStack.m_41720_());
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return pDirection != Direction.UP && pIndex == 3;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int pSlot) {
        return (ItemStack)this.items.get(pSlot);
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        return ContainerHelper.m_18969_(this.items, (int)pSlot, (int)pAmount);
    }

    public ItemStack m_8016_(int pSlot) {
        return ContainerHelper.m_18966_(this.items, (int)pSlot);
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        ItemStack itemStack = (ItemStack)this.items.get(pSlot);
        boolean flag = !pStack.m_41619_() && ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)pStack);
        this.items.set(pSlot, (Object)pStack);
        if (pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
        if (!(pSlot != 1 && pSlot != 2 || flag)) {
            this.progress = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player pPlayer) {
        return Container.m_272074_((BlockEntity)this, (Player)pPlayer);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public boolean m_7013_(int pIndex, ItemStack pStack) {
        return pIndex != 3;
    }

    public void m_5809_(StackedContents pContents) {
        for (ItemStack itemstack : this.items) {
            pContents.m_36491_(itemstack);
        }
    }

    static {
        fuelPower.put((ItemLike)Items.f_42413_, 200);
        fuelPower.put((ItemLike)Blocks.f_50353_, 2000);
        fuelPower.put((ItemLike)Items.f_42448_, 12800);
        fuelPower.put((ItemLike)Items.f_42585_, 1000);
        fuelPower.put((ItemLike)Items.f_42593_, 300);
        fuelPower.put((ItemLike)HBMItems.LIGNITE.get(), 150);
        fuelPower.put((ItemLike)HBMItems.POWDER_LIGNITE.get(), 150);
        fuelPower.put((ItemLike)HBMItems.POWDER_COAL.get(), 200);
        fuelPower.put((ItemLike)HBMItems.COKE_COAL.get(), 400);
        fuelPower.put((ItemLike)HBMItems.COKE_LIGNITE.get(), 400);
        fuelPower.put((ItemLike)HBMItems.COKE_PETROLEUM.get(), 400);
        fuelPower.put((ItemLike)HBMItems.SOLID_FUEL.get(), 400);
        fuelPower.put((ItemLike)HBMItems.BRIQUETTE_COAL.get(), 200);
        fuelPower.put((ItemLike)HBMItems.BRIQUETTE_LIGNITE.get(), 200);
        fuelPower.put((ItemLike)HBMItems.BRIQUETTE_WOOD.get(), 200);
    }
}

