/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine;

import com.hbm.HBMLang;
import com.hbm.Inventory.UpgradeManagerNT;
import com.hbm.api.energy.BasicEnergyContainer;
import com.hbm.api.energy.HybridEnergyStorage;
import com.hbm.api.energy.ProxyEnergyHandler;
import com.hbm.api.energy.TransmitUtils;
import com.hbm.api.math.MathUtils;
import com.hbm.block.machine.BlockElectricFurnace;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.BaseMachineBlockEntity;
import com.hbm.blockentity.interfaces.IUpgradeInfoProvider;
import com.hbm.capabilities.HBMCaps;
import com.hbm.gui.menu.ElectricFurnaceMenu;
import com.hbm.item.machine.ItemMachineUpgrade;
import com.hbm.registries.ModBlocks;
import com.hbm.registries.ModTags;
import com.hbm.utils.InventoryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.Nullable;

public class ElectricFurnaceEntity
extends BaseMachineBlockEntity
implements MenuProvider,
IUpgradeInfoProvider {
    public int progress;
    public static final long maxPower = 100000L;
    public int maxProgress = 100;
    public int consumption = 50;
    private int cooldown = 0;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT();
    private final BasicEnergyContainer energyContainer = new BasicEnergyContainer(100000L);
    private final HybridEnergyStorage forgeEnergy = new HybridEnergyStorage(this.energyContainer);
    private final RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> quickCheck;
    protected final ContainerData containerData = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> ElectricFurnaceEntity.this.progress;
                case 1 -> ElectricFurnaceEntity.this.maxProgress;
                case 2 -> MathUtils.clampToInt(ElectricFurnaceEntity.this.energyContainer.getEnergy());
                case 3 -> MathUtils.clampToInt(ElectricFurnaceEntity.this.energyContainer.getCapacity());
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
        }

        public int m_6499_() {
            return 4;
        }
    };

    public ElectricFurnaceEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntityType.ELECTRIC_FURNACE_ENTITY.get(), pPos, pBlockState);
        this.quickCheck = RecipeManager.m_220267_((RecipeType)RecipeType.f_44108_);
        this.items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
        this.capabilitiesContent.addCapability(ForgeCapabilities.ITEM_HANDLER, this);
        this.capabilitiesContent.addCapability(HBMCaps.LONG_ENERGY, new ProxyEnergyHandler(this.energyContainer));
        this.capabilitiesContent.addCapability(ForgeCapabilities.ENERGY, this.forgeEnergy);
    }

    public boolean m_7013_(int pIndex, ItemStack pStack) {
        if (pIndex == 1 && pStack.m_204117_(ModTags.Items.BATTERY)) {
            return true;
        }
        if (pIndex == 0) {
            return this.quickCheck.m_213657_((Container)this, this.f_58857_).isEmpty();
        }
        return false;
    }

    @Override
    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return super.m_7155_(pIndex, pItemStack, pDirection) && (pIndex == 1 || pIndex == 2);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.m_58904_() == null) {
            return;
        }
        boolean markDirty = false;
        if (!this.m_58904_().m_5776_()) {
            this.upgradeManager.checkSlots(this, (NonNullList<ItemStack>)this.items, 3, 3);
            int speedLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
            int powerLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER);
            this.consumption = 50 + speedLevel * 50 - powerLevel * 15;
            this.maxProgress = 100 - speedLevel * 25 + powerLevel * 10;
            TransmitUtils.dischargeItem(this, (ItemStack)this.items.get(1));
            this.addUpgradeTooltips((ItemStack)this.items.get(3));
            if (!this.hasPower()) {
                this.cooldown = 20;
            } else if (this.cooldown > 0) {
                --this.cooldown;
            }
            boolean isLit = false;
            boolean changeState = false;
            if (this.energyContainer.getEnergy() >= (long)this.consumption && this.cooldown == 0 && this.canProcess()) {
                ++this.progress;
                this.energyContainer.extract(this.consumption, false);
                if (this.progress >= this.maxProgress) {
                    this.progress = 0;
                    this.processItem();
                    markDirty = true;
                    changeState = true;
                } else if (this.progress == 1) {
                    changeState = true;
                }
            } else {
                this.progress = 0;
            }
            this.networkPackNT(50);
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            if (changeState) {
                state = (BlockState)state.m_61124_((Property)BlockElectricFurnace.LIT, (Comparable)Boolean.valueOf(isLit));
                this.f_58857_.m_7731_(this.f_58858_, state, 3);
            }
            if (markDirty) {
                ElectricFurnaceEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)state);
            }
        }
    }

    private boolean canProcess() {
        assert (this.f_58857_ != null);
        Optional recipeFor = this.quickCheck.m_213657_((Container)this, this.f_58857_);
        if (recipeFor.isEmpty()) {
            return false;
        }
        AbstractCookingRecipe recipe = (AbstractCookingRecipe)recipeFor.get();
        ItemStack resultItem = recipe.m_8043_(this.f_58857_.m_9598_());
        if (resultItem.m_41619_()) {
            return false;
        }
        ItemStack slotItem = (ItemStack)this.items.get(2);
        return InventoryUtils.canAddItemEntirely(slotItem, resultItem);
    }

    private void processItem() {
        assert (this.f_58857_ != null);
        Optional recipeFor = this.quickCheck.m_213657_((Container)this, this.f_58857_);
        if (recipeFor.isEmpty()) {
            return;
        }
        AbstractCookingRecipe recipe = (AbstractCookingRecipe)recipeFor.get();
        ItemStack resultItem = recipe.m_8043_(this.f_58857_.m_9598_());
        if (resultItem.m_41619_()) {
            return;
        }
        ItemStack slotItem = (ItemStack)this.items.get(2);
        if (!InventoryUtils.canAddItemEntirely(slotItem, resultItem)) {
            return;
        }
        ItemStack inItem = ((Ingredient)recipe.m_7527_().get(0)).m_43908_()[0];
        this.items.set(0, (Object)InventoryUtils.shrink(inItem.m_41613_(), (ItemStack)this.items.get(0)));
        this.items.set(2, (Object)InventoryUtils.growNoCheck(1, slotItem, resultItem));
    }

    private boolean hasPower() {
        return this.energyContainer.getEnergy() >= (long)this.consumption;
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.energyContainer.deserializeNBT(pTag.m_128469_("energy"));
        this.progress = pTag.m_128451_("progress");
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("energy", (Tag)this.energyContainer.serializeNBT());
        pTag.m_128405_("progress", this.progress);
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)HBMLang.ELECTRIC_FURNACE.key());
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory) {
        return new ElectricFurnaceMenu(pContainerId, pInventory, (Container)this, this.containerData);
    }

    public void addUpgradeTooltips(ItemStack stack) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        if (!(stack.m_41720_() instanceof ItemMachineUpgrade)) {
            return;
        }
        ItemMachineUpgrade machineUpgrade = (ItemMachineUpgrade)stack.m_41720_();
        if (!this.canProvideInfo(machineUpgrade.type, machineUpgrade.tier, true)) {
            return;
        }
        this.provideInfo(machineUpgrade.type, machineUpgrade.tier, tooltips, true);
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<Component> tooltips, boolean extendedInfo) {
        tooltips.add(IUpgradeInfoProvider.getStandardLabel((Block)ModBlocks.machine_electric_furnace.get()));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            tooltips.add((Component)Component.m_237110_((String)"upgrade.delay", (Object[])new Object[]{"-" + level * 25 + "%"}).m_130940_(ChatFormatting.GREEN));
            tooltips.add((Component)Component.m_237110_((String)"upgrade.consumption", (Object[])new Object[]{"-" + level * 100 + "%"}).m_130940_(ChatFormatting.RED));
        } else if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            tooltips.add((Component)Component.m_237110_((String)"upgrade.delay", (Object[])new Object[]{"-" + level * 10 + "%"}).m_130940_(ChatFormatting.GREEN));
            tooltips.add((Component)Component.m_237110_((String)"upgrade.consumption", (Object[])new Object[]{"-" + level * 30 + "%"}).m_130940_(ChatFormatting.RED));
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        return upgrades;
    }
}

