/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine;

import com.hbm.Inventory.fluid.ExtendedFluidType;
import com.hbm.Inventory.fluid.ModFluids;
import com.hbm.Inventory.fluid.trait.FT_Combustible;
import com.hbm.api.Mode;
import com.hbm.api.energy.BasicEnergyContainer;
import com.hbm.api.energy.HybridEnergyStorage;
import com.hbm.api.energy.ProxyEnergyHandler;
import com.hbm.api.energy.TransmitUtils;
import com.hbm.api.fluid.BasicFluidHandler;
import com.hbm.api.fluid.IExtendedFluidHandler;
import com.hbm.api.fluid.VisitRestrictWrapper;
import com.hbm.api.inventory.ModeBuilder;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.DummyableBlockEntity;
import com.hbm.blockentity.base2.TileProxyBase;
import com.hbm.capabilities.HBMCaps;
import com.hbm.gui.menu.GasTurbineMenu;
import com.hbm.registries.ModBlocks;
import com.hbm.utils.multiblock.MultiblockData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GasTurbineBlockEntity
extends DummyableBlockEntity {
    private static final int OUTPUT_SLOT = 0;
    private static final int FUEL_CONFIG_SLOT = 1;
    private static final int FUEL_TANK = 0;
    private static final int LUBE_TANK = 1;
    private static final int WATER_TANK = 2;
    private static final int STEAM_TANK = 3;
    public static final long CAPACITY = 1000000L;
    private static final long MAX_EXTRACT = 5000L;
    private static final int STARTUP_TIME = 580;
    private static final int SHUTDOWN_TIME = 225;
    private static final Map<String, Double> FUEL_MULTIPLIER = new HashMap<String, Double>();
    private final BasicEnergyContainer energy = new BasicEnergyContainer(1000000L, 0L, 5000L);
    private final BasicFluidHandler fluids;
    private final ContainerData containerData;
    private int rpm;
    private int temp;
    private int throttle;
    private int powerSliderPos;
    private int state;
    private int counter;
    private boolean autoMode;
    private int instantPowerOutput;
    private long powerBeforeNet;
    private double fuelRemainder;
    private double waterToBoil;

    public GasTurbineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.GAS_TURBINE_ENTITY.get(), pos, state);
        this.items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
        this.slotModes = new ModeBuilder().addMode(Mode.OUTPUT).addMode(Mode.INPUT).get();
        this.fluids = this.buildFluidHandler();
        this.capabilitiesContent.addCapability(ForgeCapabilities.FLUID_HANDLER, this.fluids);
        this.capabilitiesContent.addCapability(ForgeCapabilities.ENERGY, new HybridEnergyStorage(this.energy));
        this.capabilitiesContent.addCapability(HBMCaps.LONG_ENERGY, new ProxyEnergyHandler(this.energy));
        this.multiblockData = MultiblockData.mapping.get(ModBlocks.machine_turbine_gas.get());
        this.isFormed = true;
        this.containerData = this.createDataSlots();
        this.energy.setListener(this::m_6596_);
    }

    private BasicFluidHandler buildFluidHandler() {
        BasicFluidHandler handler = new BasicFluidHandler().addTank(100000, Mode.INPUT).addTank(16000, Mode.INPUT).addTank(16000, Mode.INPUT).addTank(160000, Mode.OUTPUT);
        handler.getFluidTanks().get(0).setValidator(stack -> this.hasGasTrait((FluidStack)stack));
        handler.getFluidTanks().get(1).setValidator(stack -> stack.getFluid() == ModFluids.OIL.source().get());
        handler.getFluidTanks().get(2).setValidator(stack -> stack.getFluid().m_6212_((Fluid)Fluids.f_76193_));
        handler.getFluidTanks().get(3).setValidator(stack -> stack.getFluid() == ModFluids.HOT_STEAM.source().get());
        return handler;
    }

    private ContainerData createDataSlots() {
        return new SimpleContainerData(13){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> (int)GasTurbineBlockEntity.this.energy.getEnergy();
                    case 1 -> (int)(GasTurbineBlockEntity.this.energy.getEnergy() >>> 32);
                    case 2 -> GasTurbineBlockEntity.this.rpm;
                    case 3 -> GasTurbineBlockEntity.this.temp;
                    case 4 -> GasTurbineBlockEntity.this.state;
                    case 5 -> {
                        if (GasTurbineBlockEntity.this.autoMode) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 6 -> GasTurbineBlockEntity.this.powerSliderPos;
                    case 7 -> GasTurbineBlockEntity.this.throttle;
                    case 8 -> GasTurbineBlockEntity.this.fluids.getFluidTanks().get(3).getFluidAmount();
                    case 9 -> GasTurbineBlockEntity.this.fluids.getFluidTanks().get(2).getFluidAmount();
                    case 10 -> GasTurbineBlockEntity.this.fluids.getFluidTanks().get(0).getFluidAmount();
                    case 11 -> GasTurbineBlockEntity.this.fluids.getFluidTanks().get(1).getFluidAmount();
                    case 12 -> GasTurbineBlockEntity.this.instantPowerOutput;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                if (index == 6) {
                    GasTurbineBlockEntity.this.setPowerSliderPos(value);
                }
            }
        };
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.powerBeforeNet = this.energy.getEnergy();
        this.updateAutoSlider();
        switch (this.state) {
            case -1: {
                this.startup();
                break;
            }
            case 1: {
                this.run();
                break;
            }
            default: {
                this.shutdown();
            }
        }
        TransmitUtils.chargeItem(this, this.getStackInSlot(0));
        TransmitUtils.outputOnly(this);
        if (this.f_58857_ != null && this.f_58857_.m_46467_() % 20L == 0L) {
            this.sendUpdatePacket();
        }
    }

    private void updateAutoSlider() {
        this.throttle = this.powerSliderPos * 100 / 60;
        if (!this.autoMode) {
            return;
        }
        FluidTank fuel = this.fluids.getFluidTanks().get(0);
        int target = fuel.getFluidAmount() * 10 > fuel.getCapacity() ? 60 - (int)(60L * this.energy.getEnergy() / 1000000L) : (int)((double)fuel.getFluidAmount() * 1.0E-4 * (double)(60 - (int)(60L * this.energy.getEnergy() / 1000000L)));
        if (target > this.powerSliderPos) {
            ++this.powerSliderPos;
        } else if (target < this.powerSliderPos) {
            --this.powerSliderPos;
        }
    }

    private void startup() {
        ++this.counter;
        if (this.counter <= 20) {
            this.rpm = 5 * this.counter;
        } else if (this.counter <= 40) {
            this.rpm = 100 - 5 * (this.counter - 20);
        } else if (this.counter > 50) {
            this.rpm = 10 + (this.counter - 50) * 90 / 530;
            this.temp = 300 + (this.counter - 50) * 500 / 530;
        }
        if (this.counter >= 580) {
            this.state = 1;
            this.counter = 0;
        }
    }

    private void shutdown() {
        this.autoMode = false;
        this.instantPowerOutput = 0;
        if (this.powerSliderPos > 0) {
            --this.powerSliderPos;
        }
        if (this.rpm > 0) {
            this.rpm = Math.max(0, this.rpm - 2);
        }
        if (this.temp > 20) {
            this.temp = Math.max(20, this.temp - 4);
        }
    }

    private void run() {
        if (!this.hasAcceptableFuel() || !this.hasLubricant()) {
            this.state = 0;
            return;
        }
        this.adjustRPM();
        this.adjustTemp();
        this.burnFuel();
        this.boilWater();
        this.pushSteam();
    }

    private void adjustRPM() {
        int target = Math.min(100, this.powerSliderPos == 0 ? 10 : 10 + this.powerSliderPos);
        if (this.rpm < target && this.f_58857_.m_46467_() % 5L == 0L) {
            ++this.rpm;
        } else if (this.rpm > target && this.f_58857_.m_46467_() % 2L == 0L) {
            --this.rpm;
        }
    }

    private void adjustTemp() {
        int maxTemp = this.getBurnTemperature();
        int target = (int)(300.0 + (double)((maxTemp - 300) * this.throttle) / 100.0);
        if (this.temp < target && this.f_58857_.m_46467_() % 2L == 0L) {
            ++this.temp;
        } else if (this.temp > target && this.f_58857_.m_46467_() % 2L == 0L) {
            --this.temp;
        }
    }

    private int getBurnTemperature() {
        FluidTank fuel = this.fluids.getFluidTanks().get(0);
        if (fuel.isEmpty()) {
            return 600;
        }
        FT_Combustible trait = this.getCombustibleTrait(fuel.getFluid());
        if (trait == null) {
            return 600;
        }
        double energy = trait.getCombustionEnergy();
        return (int)Math.floor(800.0 - Math.pow(Math.E, -energy / 100000.0) * 300.0);
    }

    private void burnFuel() {
        FluidTank fuel = this.fluids.getFluidTanks().get(0);
        if (fuel.isEmpty()) {
            this.state = 0;
            return;
        }
        double consumption = this.getMaxConsumption(fuel.getFluid()) * (double)this.throttle / 100.0;
        this.fuelRemainder += consumption;
        int whole = (int)Math.floor(this.fuelRemainder);
        if (whole > 0) {
            FluidStack drained = fuel.drain(whole, IFluidHandler.FluidAction.EXECUTE);
            if (drained.isEmpty() || drained.getAmount() < whole) {
                this.state = 0;
                return;
            }
            this.fuelRemainder -= (double)whole;
            this.fluids.getFluidTanks().get(1).drain(1, IFluidHandler.FluidAction.EXECUTE);
            long produced = this.calculateEnergy(drained, whole);
            this.instantPowerOutput = (int)produced;
            this.energy.receive(produced, false);
        }
        if (fuel.getFluidAmount() <= 0 || this.fluids.getFluidTanks().get(1).getFluidAmount() <= 0) {
            this.state = 0;
        }
    }

    private long calculateEnergy(FluidStack fuel, int amount) {
        FT_Combustible trait = this.getCombustibleTrait(fuel);
        if (trait == null) {
            return 0L;
        }
        double multiplier = (double)trait.getCombustionEnergy() / 1000.0;
        int rpmEff = Math.max(0, this.rpm - 10);
        return (long)(multiplier * (double)amount * (double)rpmEff / 90.0);
    }

    private void boilWater() {
        int waterCycles;
        FluidTank water = this.fluids.getFluidTanks().get(2);
        FluidTank steam = this.fluids.getFluidTanks().get(3);
        int heatCycles = (int)Math.floor(this.getMaxConsumption(this.fluids.getFluidTanks().get(0).getFluid()) * (double)this.throttle / 200.0);
        int cycles = Math.min(Math.min(heatCycles, waterCycles = Math.min(water.getFluidAmount(), steam.getSpace() / 10)), 100);
        if (cycles > 0) {
            water.drain(cycles, IFluidHandler.FluidAction.EXECUTE);
            steam.fill(new FluidStack((Fluid)ModFluids.HOT_STEAM.source().get(), cycles * 10), IFluidHandler.FluidAction.EXECUTE);
            this.waterToBoil = cycles;
        } else {
            this.waterToBoil = 0.0;
        }
    }

    private void pushSteam() {
    }

    private double getMaxConsumption(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return 5.0;
        }
        ResourceLocation key = BuiltInRegistries.f_257020_.m_7981_((Object)fluidStack.getFluid());
        String name = key != null ? key.toString() : "";
        return FUEL_MULTIPLIER.getOrDefault(name, 5.0);
    }

    private boolean hasGasTrait(FluidStack stack) {
        return this.hasGasTrait(stack.getFluid());
    }

    private boolean hasGasTrait(Fluid fluid) {
        FluidType type = fluid.getFluidType();
        if (type instanceof ExtendedFluidType) {
            ExtendedFluidType extended = (ExtendedFluidType)type;
            FT_Combustible trait = extended.getTrait(FT_Combustible.class);
            return trait != null && trait.getGrade() == FT_Combustible.FuelGrade.GAS;
        }
        return false;
    }

    private FT_Combustible getCombustibleTrait(FluidStack stack) {
        FluidType type = stack.getFluid().getFluidType();
        if (type instanceof ExtendedFluidType) {
            ExtendedFluidType extended = (ExtendedFluidType)type;
            return extended.getTrait(FT_Combustible.class);
        }
        return null;
    }

    private boolean hasAcceptableFuel() {
        FluidTank fuel = this.fluids.getFluidTanks().get(0);
        return !fuel.isEmpty() && this.hasGasTrait(fuel.getFluid());
    }

    private boolean hasLubricant() {
        return this.fluids.getFluidTanks().get(1).getFluidAmount() > 0;
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    public BasicEnergyContainer getEnergy() {
        return this.energy;
    }

    public BasicFluidHandler getFluids() {
        return this.fluids;
    }

    public double getWaterToBoil() {
        return this.waterToBoil;
    }

    public long getPowerBeforeNet() {
        return this.powerBeforeNet;
    }

    public void setPowerSliderPos(int value) {
        int clamped = Math.max(0, Math.min(60, value));
        if (clamped != this.powerSliderPos) {
            this.powerSliderPos = clamped;
            this.m_6596_();
        }
    }

    public void toggleAutoMode() {
        this.setAutoMode(!this.autoMode);
    }

    public void setAutoMode(boolean enabled) {
        if (this.autoMode != enabled) {
            this.autoMode = enabled;
            this.m_6596_();
        }
    }

    public boolean isAutoMode() {
        return this.autoMode;
    }

    public int getState() {
        return this.state;
    }

    public void requestStart() {
        if (this.state == 0 && this.hasAcceptableFuel() && this.hasLubricant()) {
            this.counter = 0;
            this.state = -1;
        }
    }

    public void requestStop() {
        this.state = 0;
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("fluids", (Tag)this.fluids.serializeNBT());
        tag.m_128405_("rpm", this.rpm);
        tag.m_128405_("temp", this.temp);
        tag.m_128405_("state", this.state);
        tag.m_128405_("counter", this.counter);
        tag.m_128405_("slider", this.powerSliderPos);
        tag.m_128379_("auto", this.autoMode);
        tag.m_128347_("fuelRem", this.fuelRemainder);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("energy")) {
            this.energy.deserializeNBT(tag.m_128469_("energy"));
        }
        if (tag.m_128441_("fluids")) {
            this.fluids.deserializeNBT(tag.m_128469_("fluids"));
        }
        this.rpm = tag.m_128451_("rpm");
        this.temp = tag.m_128451_("temp");
        this.state = tag.m_128451_("state");
        this.counter = tag.m_128451_("counter");
        this.powerSliderPos = tag.m_128451_("slider");
        this.autoMode = tag.m_128471_("auto");
        this.fuelRemainder = tag.m_128459_("fuelRem");
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag tag = super.getReducedUpdateTag();
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("fluids", (Tag)this.fluids.serializeNBT());
        tag.m_128405_("rpm", this.rpm);
        tag.m_128405_("temp", this.temp);
        tag.m_128405_("state", this.state);
        tag.m_128405_("slider", this.powerSliderPos);
        tag.m_128379_("auto", this.autoMode);
        return tag;
    }

    @Override
    public void handleUpdatePacket(@NotNull CompoundTag tag) {
        super.handleUpdatePacket(tag);
        if (tag.m_128441_("energy")) {
            this.energy.deserializeNBT(tag.m_128469_("energy"));
        }
        if (tag.m_128441_("fluids")) {
            this.fluids.deserializeNBT(tag.m_128469_("fluids"));
        }
        this.rpm = tag.m_128451_("rpm");
        this.temp = tag.m_128451_("temp");
        this.state = tag.m_128451_("state");
        this.powerSliderPos = tag.m_128451_("slider");
        this.autoMode = tag.m_128471_("auto");
    }

    @Override
    public Component m_5446_() {
        return this.getDefaultName();
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new GasTurbineMenu(containerId, inventory, (Container)this, this.containerData);
    }

    @Override
    public void giveProxyCapabilities(Vec3i offset, TileProxyBase proxy, Capability<?> cap, Set<Direction> directions) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (offset.equals((Object)new Vec3i(-1, 0, -1)) || offset.equals((Object)new Vec3i(-1, 0, 1))) {
                proxy.capabilitiesContent.addCapability(cap, new VisitRestrictWrapper((IExtendedFluidHandler)this.fluids, false, 0), directions);
                return;
            }
            if (offset.equals((Object)new Vec3i(-2, 0, -1)) || offset.equals((Object)new Vec3i(-2, 0, 1))) {
                proxy.capabilitiesContent.addCapability(cap, new VisitRestrictWrapper((IExtendedFluidHandler)this.fluids, false, 1), directions);
                return;
            }
            if (offset.equals((Object)new Vec3i(2, 0, -1)) || offset.equals((Object)new Vec3i(2, 0, 1))) {
                proxy.capabilitiesContent.addCapability(cap, new VisitRestrictWrapper((IExtendedFluidHandler)this.fluids, false, 2), directions);
                return;
            }
            if (offset.equals((Object)new Vec3i(3, 1, 0))) {
                proxy.capabilitiesContent.addCapability(cap, new VisitRestrictWrapper((IExtendedFluidHandler)this.fluids, false, 3), directions);
                return;
            }
        } else if ((cap == ForgeCapabilities.ENERGY || cap == HBMCaps.LONG_ENERGY) && offset.equals((Object)new Vec3i(0, 1, -1))) {
            proxy.capabilitiesContent.addCapability(cap, this.proxyCap(cap), directions);
            return;
        }
        super.giveProxyCapabilities(offset, proxy, cap, directions);
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)"block.hbm.machine_turbine_gas");
    }

    private Object proxyCap(Capability<?> cap) {
        if (cap == ForgeCapabilities.ENERGY) {
            return new HybridEnergyStorage(this.energy);
        }
        if (cap == HBMCaps.LONG_ENERGY) {
            return new ProxyEnergyHandler(this.energy);
        }
        return null;
    }

    @Override
    public int[] m_7071_(Direction side) {
        if (side == Direction.DOWN) {
            return new int[]{0};
        }
        return new int[]{0, 1};
    }

    @Override
    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return false;
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index == 0;
    }

    @Override
    public void m_6836_(int slot, ItemStack stack) {
        super.m_6836_(slot, stack);
        if (slot == 0 && stack.m_41619_()) {
            ContainerHelper.m_18969_((List)this.items, (int)slot, (int)stack.m_41613_());
        }
    }

    static {
        FUEL_MULTIPLIER.put(ModFluids.REFINERY_GAS.source().getId().toString(), 50.0);
        FUEL_MULTIPLIER.put(ModFluids.BIOGAS.source().getId().toString(), 15.0);
        FUEL_MULTIPLIER.put(ModFluids.REFORM_GAS.source().getId().toString(), 5.0);
        FUEL_MULTIPLIER.put(ModFluids.DEUTERIUM.source().getId().toString(), 30.0);
    }
}

