/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine;

import com.hbm.block.machine.generator.BlockPWR;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.machine.PWRControllerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PWRBlockEntity
extends BlockEntity {
    private static final String KEY_BLOCK = "stored_block";
    private static final String KEY_CORE = "core_pos";
    @Nullable
    private Block storedBlock;
    @Nullable
    private BlockPos corePos;
    @Nullable
    private PWRControllerBlockEntity cachedCore;

    public PWRBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.PWR_BLOCK_ENTITY.get(), pos, state);
    }

    public void setStoredBlock(@Nullable Block block) {
        this.storedBlock = block;
        this.m_6596_();
    }

    public void setCorePos(@Nullable BlockPos pos) {
        this.corePos = pos;
        this.m_6596_();
    }

    @Nullable
    public Block getStoredBlock() {
        return this.storedBlock;
    }

    @Nullable
    public PWRControllerBlockEntity getCore() {
        if (this.cachedCore != null && !this.cachedCore.m_58901_()) {
            return this.cachedCore;
        }
        if (this.f_58857_ == null || this.corePos == null || !this.f_58857_.m_46805_(this.corePos)) {
            return null;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.corePos);
        if (blockEntity instanceof PWRControllerBlockEntity) {
            PWRControllerBlockEntity controller;
            this.cachedCore = controller = (PWRControllerBlockEntity)blockEntity;
            return controller;
        }
        return null;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, PWRBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (level.m_46467_() % 20L != 0L) {
            return;
        }
        if (blockEntity.storedBlock == null || blockEntity.corePos == null) {
            return;
        }
        PWRControllerBlockEntity core = blockEntity.getCore();
        if (core == null || !core.isAssembled()) {
            blockEntity.restoreOriginal(level, pos, state);
        }
    }

    public void restoreOriginal(Level level, BlockPos pos, BlockState state) {
        PWRControllerBlockEntity core;
        if (this.storedBlock == null) {
            return;
        }
        BlockState originalState = this.storedBlock.m_49966_();
        if (!state.m_60713_(originalState.m_60734_())) {
            level.m_7731_(pos, originalState, 3);
        }
        if ((core = this.getCore()) != null) {
            core.setAssembled(false);
        }
    }

    private boolean isPort() {
        BlockState state = this.m_58900_();
        return state.m_60734_() instanceof BlockPWR && (Boolean)state.m_61143_((Property)BlockPWR.PORT) != false;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (!this.isPort()) {
            return LazyOptional.empty();
        }
        PWRControllerBlockEntity core = this.getCore();
        if (core != null) {
            return core.getCapability(cap, side);
        }
        return LazyOptional.empty();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.storedBlock != null && this.storedBlock != Blocks.f_50016_) {
            tag.m_128359_(KEY_BLOCK, BuiltInRegistries.f_256975_.m_7981_((Object)this.storedBlock).toString());
        }
        if (this.corePos != null) {
            tag.m_128385_(KEY_CORE, new int[]{this.corePos.m_123341_(), this.corePos.m_123342_(), this.corePos.m_123343_()});
        }
    }

    public void m_142466_(CompoundTag tag) {
        int[] pos;
        ResourceLocation id;
        Block block;
        super.m_142466_(tag);
        this.storedBlock = null;
        if (tag.m_128441_(KEY_BLOCK) && (block = (Block)BuiltInRegistries.f_256975_.m_7745_(id = new ResourceLocation(tag.m_128461_(KEY_BLOCK)))) != Blocks.f_50016_) {
            this.storedBlock = block;
        }
        this.corePos = null;
        if (tag.m_128441_(KEY_CORE) && (pos = tag.m_128465_(KEY_CORE)).length == 3) {
            this.corePos = new BlockPos(pos[0], pos[1], pos[2]);
        }
    }
}

