/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine;

import com.hbm.Inventory.fluid.ExtendedFluidType;
import com.hbm.Inventory.fluid.ModFluids;
import com.hbm.Inventory.fluid.trait.FT_Heatable;
import com.hbm.Inventory.fluid.trait.FT_PWRModerator;
import com.hbm.api.Mode;
import com.hbm.api.fluid.BasicFluidHandler;
import com.hbm.api.inventory.ModeBuilder;
import com.hbm.api.math.MathUtils;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.BaseMachineBlockEntity;
import com.hbm.gui.menu.PWRMenu;
import com.hbm.item.HBMItems;
import com.hbm.item.pwr.ItemPWRFuel;
import com.hbm.reactor.pwr.PWRFuelType;
import com.hbm.registries.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PWRControllerBlockEntity
extends BaseMachineBlockEntity {
    public static final int SLOT_FUEL = 0;
    public static final int SLOT_OUTPUT = 1;
    public static final int SLOT_COOLANT = 2;
    public static final int COOLANT_CAPACITY = 128000;
    public static final long CORE_HEAT_CAPACITY_BASE = 10000000L;
    public static final long HULL_HEAT_CAPACITY_BASE = 10000000L;
    private static final int DEFAULT_ROD_COUNT = 16;
    private static final int DEFAULT_CONNECTIONS = 32;
    private static final int DEFAULT_HEATEX = 8;
    private static final int DEFAULT_HEATSINK = 8;
    private static final int DEFAULT_CHANNEL = 8;
    private static final int DEFAULT_SOURCE = 1;
    public long coreHeat = 0L;
    public long coreHeatCapacity = 10000000L;
    public long hullHeat = 0L;
    public double flux = 0.0;
    public double rodLevel = 100.0;
    public double rodTarget = 100.0;
    public int typeLoaded = -1;
    public int amountLoaded = 0;
    public double progress = 0.0;
    public double processTime = 1.0;
    public int rodCount = 16;
    public int connections = 32;
    public int connectionsControlled = 32;
    public int heatexCount = 8;
    public int heatsinkCount = 8;
    public int channelCount = 8;
    public int sourceCount = 1;
    public boolean assembled = false;
    private final List<BlockPos> ports = new ArrayList<BlockPos>();
    private final List<BlockPos> rods = new ArrayList<BlockPos>();
    private final BasicFluidHandler fluidHandler = new BasicFluidHandler().addTank(128000, Mode.INPUT).addTank(128000, Mode.OUTPUT);
    private final ContainerData containerData = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> MathUtils.clampToInt(PWRControllerBlockEntity.this.coreHeat);
                case 1 -> MathUtils.clampToInt(PWRControllerBlockEntity.this.coreHeatCapacity);
                case 2 -> MathUtils.clampToInt(PWRControllerBlockEntity.this.hullHeat);
                case 3 -> MathUtils.clampToInt(10000000L);
                case 4 -> MathUtils.clampToInt(PWRControllerBlockEntity.this.flux * 10.0);
                case 5 -> MathUtils.clampToInt(PWRControllerBlockEntity.this.progress);
                case 6 -> MathUtils.clampToInt(PWRControllerBlockEntity.this.processTime);
                case 7 -> MathUtils.clampToInt(PWRControllerBlockEntity.this.rodLevel * 100.0);
                case 8 -> MathUtils.clampToInt(PWRControllerBlockEntity.this.rodTarget * 100.0);
                case 9 -> PWRControllerBlockEntity.this.typeLoaded;
                case 10 -> PWRControllerBlockEntity.this.amountLoaded;
                case 11 -> PWRControllerBlockEntity.this.rodCount;
                case 12 -> PWRControllerBlockEntity.this.fluidHandler.getFluidTanks().get(0).getFluidAmount();
                case 13 -> PWRControllerBlockEntity.this.fluidHandler.getFluidTanks().get(1).getFluidAmount();
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
        }

        public int m_6499_() {
            return 14;
        }
    };

    public PWRControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.PWR_CONTROLLER_ENTITY.get(), pos, state);
        this.items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
        this.slotModes = new ModeBuilder().addModes(new Object[]{1, Mode.INPUT, 1, Mode.OUTPUT, 1, Mode.INPUT}).get();
        this.capabilitiesContent.addCapability(ForgeCapabilities.ITEM_HANDLER, this);
        this.capabilitiesContent.addCapability(ForgeCapabilities.FLUID_HANDLER, this.fluidHandler);
        this.fluidHandler.getFluidTanks().set(0, new FluidTank(128000){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_6212_((Fluid)ModFluids.COOLANT.source().get());
            }
        });
        this.fluidHandler.getFluidTanks().set(1, new FluidTank(128000){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_6212_((Fluid)ModFluids.COOLANT_HOT.source().get());
            }
        });
        this.recalcCoreCapacity();
    }

    @Override
    protected void onUpdateServer() {
        PWRFuelType type;
        ItemStack drained;
        ItemStack coolantStack;
        super.onUpdateServer();
        boolean dirty = false;
        if (this.coreHeatCapacity < 10000000L) {
            this.recalcCoreCapacity();
        }
        if (!(coolantStack = (ItemStack)this.items.get(2)).m_41619_() && (drained = this.fluidHandler.drainItem(0, coolantStack)) != coolantStack) {
            this.items.set(2, (Object)drained);
            dirty = true;
        }
        if (!this.assembled) {
            if (this.coreHeat != 0L || this.hullHeat != 0L || this.flux != 0.0 || this.progress != 0.0) {
                this.coreHeat = 0L;
                this.hullHeat = 0L;
                this.flux = 0.0;
                this.progress = 0.0;
            }
            if (dirty) {
                this.m_6596_();
            }
            this.sendUpdatePacket();
            return;
        }
        ItemStack fuelStack = (ItemStack)this.items.get(0);
        if (this.typeLoaded == -1 || this.amountLoaded <= 0) {
            if (ItemPWRFuel.isFreshFuel(fuelStack)) {
                type = ItemPWRFuel.getFuelType(fuelStack);
                this.typeLoaded = type.ordinal();
                ++this.amountLoaded;
                fuelStack.m_41774_(1);
                dirty = true;
            }
        } else if (ItemPWRFuel.isFreshFuel(fuelStack) && (type = ItemPWRFuel.getFuelType(fuelStack)).ordinal() == this.typeLoaded && this.amountLoaded < this.rodCount) {
            ++this.amountLoaded;
            fuelStack.m_41774_(1);
            dirty = true;
        }
        if (Math.abs(this.rodLevel - this.rodTarget) < 1.0) {
            this.rodLevel = this.rodTarget;
        } else if (this.rodTarget > this.rodLevel) {
            this.rodLevel += 1.0;
        } else if (this.rodTarget < this.rodLevel) {
            this.rodLevel -= 1.0;
        }
        int newFlux = this.sourceCount * 20;
        if (this.typeLoaded != -1 && this.amountLoaded > 0 && this.rodCount > 0) {
            PWRFuelType fuel = PWRFuelType.fromIndex(this.typeLoaded);
            double usedRods = this.getTotalProcessMultiplier();
            double fluxPerRod = this.flux / (double)Math.max(this.rodCount, 1);
            double outputPerRod = fuel.outputForFlux(fluxPerRod);
            double totalOutput = outputPerRod * (double)this.amountLoaded * usedRods;
            double totalHeatOutput = totalOutput * fuel.heatEmission;
            this.coreHeat += (long)totalHeatOutput;
            newFlux = (int)((double)newFlux + totalOutput);
            this.processTime = fuel.yield;
            this.progress += totalOutput;
            if (this.progress >= this.processTime) {
                this.progress -= this.processTime;
                ItemStack out = (ItemStack)this.items.get(1);
                ItemStack produced = ItemPWRFuel.createStack((Item)HBMItems.pwr_fuel_hot.get(), fuel);
                if (out.m_41619_()) {
                    this.items.set(1, (Object)produced);
                } else if (ItemPWRFuel.isHotFuel(out) && ItemPWRFuel.getFuelType(out) == fuel && out.m_41613_() < out.m_41741_()) {
                    out.m_41769_(1);
                }
                --this.amountLoaded;
                dirty = true;
            }
        }
        if (this.amountLoaded <= 0) {
            this.typeLoaded = -1;
        }
        if (this.amountLoaded > this.rodCount) {
            this.amountLoaded = this.rodCount;
        }
        double coolingDenom = Math.max(this.getRodCountForCoolant(), 1);
        double coreCoolingApproachNum = this.getXOverE((double)this.heatexCount * 5.0 / coolingDenom, 2.0) / 2.0;
        long averageCoreHeat = (this.coreHeat + this.hullHeat) / 2L;
        this.coreHeat -= (long)((double)(this.coreHeat - averageCoreHeat) * coreCoolingApproachNum);
        this.hullHeat -= (long)((double)(this.hullHeat - averageCoreHeat) * coreCoolingApproachNum);
        this.updateCoolant();
        this.coreHeat = (long)((double)this.coreHeat * 0.999);
        this.hullHeat = (long)((double)this.hullHeat * 0.999);
        this.flux = newFlux;
        this.applyModerator();
        if (this.coreHeat > this.coreHeatCapacity) {
            this.coreHeat = this.coreHeatCapacity;
        }
        if (dirty) {
            this.m_6596_();
        }
        this.sendUpdatePacket();
    }

    private void updateCoolant() {
        int heatCycles;
        FluidTank hotTank;
        int hotCycles;
        FluidStack coolant = this.fluidHandler.getFluidTanks().get(0).getFluid();
        if (coolant.isEmpty()) {
            return;
        }
        FT_Heatable trait = null;
        FluidType fluidType = coolant.getFluid().getFluidType();
        if (fluidType instanceof ExtendedFluidType) {
            ExtendedFluidType extended = (ExtendedFluidType)fluidType;
            trait = extended.getTrait(FT_Heatable.class);
        }
        if (trait == null || trait.getEfficiency(FT_Heatable.HeatingType.PWR) <= 0.0) {
            return;
        }
        double coolingEff = (double)this.channelCount / (double)this.getRodCountForCoolant() * 0.1;
        if (coolingEff > 1.0) {
            coolingEff = 1.0;
        }
        int heatToUse = (int)Math.min(Math.min(this.hullHeat, (long)((double)this.hullHeat * coolingEff * trait.getEfficiency(FT_Heatable.HeatingType.PWR))), 2000000000L);
        FT_Heatable.HeatingStep step = trait.getFirstStep();
        int coolCycles = coolant.getAmount() / step.amountReq;
        int cycles = Math.min(coolCycles, Math.min(hotCycles = ((hotTank = this.fluidHandler.getFluidTanks().get(1)).getCapacity() - hotTank.getFluidAmount()) / step.amountProduced, heatCycles = heatToUse / step.heatReq));
        if (cycles <= 0) {
            return;
        }
        this.hullHeat -= (long)step.heatReq * (long)cycles;
        this.fluidHandler.getFluidTanks().get(0).drain(step.amountReq * cycles, IFluidHandler.FluidAction.EXECUTE);
        hotTank.fill(new FluidStack((Fluid)ModFluids.COOLANT_HOT.source().get(), step.amountProduced * cycles), IFluidHandler.FluidAction.EXECUTE);
    }

    private int getRodCountForCoolant() {
        return this.rodCount + (int)Math.ceil((double)this.heatsinkCount / 4.0);
    }

    public double getTotalProcessMultiplier() {
        double totalConnections = (double)this.connections + (double)this.connectionsControlled * (1.0 - this.rodLevel / 100.0);
        return this.connectinFunc(totalConnections);
    }

    private double connectinFunc(double connectionCount) {
        return connectionCount / 10.0 * (1.0 - this.getXOverE(connectionCount, 300.0)) + connectionCount / 150.0 * this.getXOverE(connectionCount, 300.0);
    }

    private double getXOverE(double x, double d) {
        return 1.0 - Math.pow(Math.E, -x / d);
    }

    private void recalcCoreCapacity() {
        int cappedHeatsinks = Math.min(this.heatsinkCount, 80);
        this.coreHeatCapacity = 10000000L + (long)cappedHeatsinks * 500000L;
    }

    private void applyModerator() {
        ExtendedFluidType extended;
        FT_PWRModerator moderator;
        FluidStack coolant = this.fluidHandler.getFluidTanks().get(0).getFluid();
        if (coolant.isEmpty()) {
            return;
        }
        FluidType fluidType = coolant.getFluid().getFluidType();
        if (fluidType instanceof ExtendedFluidType && (moderator = (extended = (ExtendedFluidType)fluidType).getTrait(FT_PWRModerator.class)) != null) {
            this.flux *= moderator.getMultiplier();
        }
    }

    public void setup(Map<BlockPos, Block> partMap, Map<BlockPos, Block> rodMap) {
        this.rodCount = 0;
        this.connections = 0;
        this.connectionsControlled = 0;
        this.heatexCount = 0;
        this.channelCount = 0;
        this.heatsinkCount = 0;
        this.sourceCount = 0;
        this.ports.clear();
        this.rods.clear();
        int connectionsDouble = 0;
        int connectionsControlledDouble = 0;
        for (Map.Entry<BlockPos, Block> entry : partMap.entrySet()) {
            Block block = entry.getValue();
            if (block == ModBlocks.pwr_fuel_block.get()) {
                ++this.rodCount;
            }
            if (block == ModBlocks.pwr_heatex.get()) {
                ++this.heatexCount;
            }
            if (block == ModBlocks.pwr_channel.get()) {
                ++this.channelCount;
            }
            if (block == ModBlocks.pwr_heatsink.get()) {
                ++this.heatsinkCount;
            }
            if (block == ModBlocks.pwr_neutron_source.get()) {
                ++this.sourceCount;
            }
            if (block != ModBlocks.pwr_port.get()) continue;
            this.ports.add(entry.getKey());
        }
        for (Map.Entry<BlockPos, Block> entry : rodMap.entrySet()) {
            BlockPos fuelPos = entry.getKey();
            this.rods.add(fuelPos);
            block2: for (Direction dir : Direction.values()) {
                BlockPos checkPos;
                Block atPos;
                boolean controlled = false;
                for (int i = 1; i < 16 && (atPos = partMap.get(checkPos = fuelPos.m_5484_(dir, i))) != null && atPos != ModBlocks.pwr_casing.get(); ++i) {
                    if (atPos == ModBlocks.pwr_control.get()) {
                        controlled = true;
                    }
                    if (atPos == ModBlocks.pwr_fuel_block.get()) {
                        if (controlled) {
                            ++connectionsControlledDouble;
                            continue block2;
                        }
                        ++connectionsDouble;
                        continue block2;
                    }
                    if (atPos != ModBlocks.pwr_reflector.get()) continue;
                    if (controlled) {
                        connectionsControlledDouble += 2;
                        continue block2;
                    }
                    connectionsDouble += 2;
                    continue block2;
                }
            }
        }
        this.connections = connectionsDouble / 2;
        this.connectionsControlled = connectionsControlledDouble / 2;
        this.heatsinkCount = Math.min(this.heatsinkCount, 80);
        this.recalcCoreCapacity();
        this.m_6596_();
    }

    public void setAssembled(boolean assembled) {
        this.assembled = assembled;
        this.m_6596_();
    }

    public boolean isAssembled() {
        return this.assembled;
    }

    public void setRodTarget(int target) {
        this.rodTarget = Mth.m_14045_((int)target, (int)0, (int)100);
        this.m_6596_();
    }

    @Override
    public void handleClientPacket(@NotNull CompoundTag tag) {
        if (tag.m_128441_("rodTarget")) {
            this.rodTarget = Mth.m_14008_((double)tag.m_128459_("rodTarget"), (double)0.0, (double)100.0);
        }
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("fluids", (Tag)this.fluidHandler.serializeNBT());
        tag.m_128347_("rodLevel", this.rodLevel);
        tag.m_128347_("rodTarget", this.rodTarget);
        tag.m_128405_("typeLoaded", this.typeLoaded);
        tag.m_128405_("amountLoaded", this.amountLoaded);
        tag.m_128379_("assembled", this.assembled);
        return super.getReducedUpdateTag().m_128391_(tag);
    }

    @Override
    public void handleUpdatePacket(@NotNull CompoundTag tag) {
        super.handleUpdatePacket(tag);
        this.fluidHandler.deserializeNBT(tag.m_128469_("fluids"));
        if (tag.m_128441_("rodLevel")) {
            this.rodLevel = tag.m_128459_("rodLevel");
        }
        if (tag.m_128441_("rodTarget")) {
            this.rodTarget = tag.m_128459_("rodTarget");
        }
        if (tag.m_128441_("typeLoaded")) {
            this.typeLoaded = tag.m_128451_("typeLoaded");
        }
        if (tag.m_128441_("amountLoaded")) {
            this.amountLoaded = tag.m_128451_("amountLoaded");
        }
        if (tag.m_128441_("assembled")) {
            this.assembled = tag.m_128471_("assembled");
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        BlockPos pos;
        int i;
        super.m_183515_(tag);
        tag.m_128365_("fluids", (Tag)this.fluidHandler.serializeNBT());
        tag.m_128356_("coreHeat", this.coreHeat);
        tag.m_128356_("coreHeatCapacity", this.coreHeatCapacity);
        tag.m_128356_("hullHeat", this.hullHeat);
        tag.m_128347_("flux", this.flux);
        tag.m_128347_("rodLevel", this.rodLevel);
        tag.m_128347_("rodTarget", this.rodTarget);
        tag.m_128405_("typeLoaded", this.typeLoaded);
        tag.m_128405_("amountLoaded", this.amountLoaded);
        tag.m_128347_("progress", this.progress);
        tag.m_128347_("processTime", this.processTime);
        tag.m_128405_("rodCount", this.rodCount);
        tag.m_128405_("connections", this.connections);
        tag.m_128405_("connectionsControlled", this.connectionsControlled);
        tag.m_128405_("heatexCount", this.heatexCount);
        tag.m_128405_("heatsinkCount", this.heatsinkCount);
        tag.m_128405_("channelCount", this.channelCount);
        tag.m_128405_("sourceCount", this.sourceCount);
        tag.m_128379_("assembled", this.assembled);
        tag.m_128405_("portCount", this.ports.size());
        for (i = 0; i < this.ports.size(); ++i) {
            pos = this.ports.get(i);
            tag.m_128385_("p" + i, new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
        }
        tag.m_128405_("rodListCount", this.rods.size());
        for (i = 0; i < this.rods.size(); ++i) {
            pos = this.rods.get(i);
            tag.m_128385_("r" + i, new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.fluidHandler.deserializeNBT(tag.m_128469_("fluids"));
        this.coreHeat = tag.m_128454_("coreHeat");
        this.coreHeatCapacity = tag.m_128454_("coreHeatCapacity");
        if (this.coreHeatCapacity < 10000000L) {
            this.coreHeatCapacity = 10000000L;
        }
        this.hullHeat = tag.m_128454_("hullHeat");
        this.flux = tag.m_128459_("flux");
        this.rodLevel = tag.m_128459_("rodLevel");
        this.rodTarget = tag.m_128459_("rodTarget");
        this.typeLoaded = tag.m_128451_("typeLoaded");
        this.amountLoaded = tag.m_128451_("amountLoaded");
        this.progress = tag.m_128459_("progress");
        this.processTime = tag.m_128459_("processTime");
        this.rodCount = Math.max(tag.m_128451_("rodCount"), 16);
        this.connections = tag.m_128451_("connections");
        this.connectionsControlled = tag.m_128451_("connectionsControlled");
        this.heatexCount = tag.m_128451_("heatexCount");
        this.heatsinkCount = tag.m_128451_("heatsinkCount");
        this.channelCount = tag.m_128451_("channelCount");
        this.sourceCount = tag.m_128451_("sourceCount");
        this.assembled = tag.m_128471_("assembled");
        this.ports.clear();
        int portCount = tag.m_128451_("portCount");
        for (int i = 0; i < portCount; ++i) {
            int[] port = tag.m_128465_("p" + i);
            if (port.length != 3) continue;
            this.ports.add(new BlockPos(port[0], port[1], port[2]));
        }
        this.rods.clear();
        int rodListCount = tag.m_128451_("rodListCount");
        for (int i = 0; i < rodListCount; ++i) {
            int[] rod = tag.m_128465_("r" + i);
            if (rod.length != 3) continue;
            this.rods.add(new BlockPos(rod[0], rod[1], rod[2]));
        }
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index == 0) {
            return ItemPWRFuel.isFreshFuel(stack);
        }
        if (index == 2) {
            return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
        }
        return false;
    }

    @Override
    public int[] m_7071_(Direction side) {
        return new int[]{0, 1, 2};
    }

    @Override
    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return index == 0 || index == 2;
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)"container.pwrController");
    }

    @Override
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new PWRMenu(containerId, inventory, (Container)this, this.containerData);
    }
}

