/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine;

import com.hbm.HBMLang;
import com.hbm.Inventory.recipe.ModRecipes;
import com.hbm.Inventory.recipe.ShredderRecipe;
import com.hbm.api.Mode;
import com.hbm.api.energy.BasicEnergyContainer;
import com.hbm.api.energy.HybridEnergyStorage;
import com.hbm.api.energy.ProxyEnergyHandler;
import com.hbm.api.energy.TransmitUtils;
import com.hbm.api.inventory.ModeBuilder;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.BaseMachineBlockEntity;
import com.hbm.capabilities.HBMCaps;
import com.hbm.gui.menu.ShredderMenu;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;

public class ShredderEntity
extends BaseMachineBlockEntity {
    public static final int DEFAULT_PROCESS_TICKS = 60;
    public static final long MAX_POWER = 10000L;
    private static final int POWER_PER_TICK = 5;
    private static final int INPUT_SLOTS = 9;
    private static final int OUTPUT_START = 9;
    private static final int OUTPUT_END = 26;
    private static final int LEFT_BLADE_SLOT = 27;
    private static final int RIGHT_BLADE_SLOT = 28;
    private static final int BATTERY_SLOT = 29;
    private final BasicEnergyContainer energyContainer = new BasicEnergyContainer(10000L, 10000L, 10000L);
    private final HybridEnergyStorage forgeEnergy = new HybridEnergyStorage(this.energyContainer);
    private final SimpleContainer recipeContainer = new SimpleContainer(1);
    private int progress;
    private int processTarget = 60;
    private final ContainerData containerData = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ShredderEntity.this.progress;
                case 1 -> ShredderEntity.this.processTarget;
                case 2 -> (int)Math.min(Integer.MAX_VALUE, ShredderEntity.this.energyContainer.getEnergy());
                case 3 -> (int)Math.min(Integer.MAX_VALUE, ShredderEntity.this.energyContainer.getCapacity());
                case 4 -> ShredderEntity.this.getBladeState(27);
                case 5 -> ShredderEntity.this.getBladeState(28);
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
        }

        public int m_6499_() {
            return 6;
        }
    };

    public ShredderEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.SHREDDER_ENTITY.get(), pos, state);
        this.items = NonNullList.m_122780_((int)30, (Object)ItemStack.f_41583_);
        this.slotModes = new ModeBuilder().addModes(new Object[]{9, Mode.BOTH}).addModes(new Object[]{18, Mode.OUTPUT}).addModes(new Object[]{2, Mode.BOTH}).addModes(new Object[]{1, Mode.BOTH}).get();
        this.capabilitiesContent.addCapability(HBMCaps.LONG_ENERGY, new ProxyEnergyHandler(this.energyContainer));
        this.capabilitiesContent.addCapability(ForgeCapabilities.ENERGY, this.forgeEnergy);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.f_58857_ == null) {
            return;
        }
        TransmitUtils.dischargeItem(this, (ItemStack)this.items.get(29));
        boolean canProcess = this.canProcess();
        if (canProcess && this.energyContainer.extract(5L, true) == 5L) {
            ++this.progress;
            this.energyContainer.extract(5L, false);
            if (this.progress >= this.processTarget) {
                this.progress = 0;
                this.processInputs();
                this.damageBlade(27);
                this.damageBlade(28);
            }
            ShredderEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)this.m_58900_());
        } else {
            if (this.progress != 0) {
                this.progress = 0;
                ShredderEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)this.m_58900_());
            }
            this.processTarget = 60;
        }
    }

    private boolean canProcess() {
        if (this.f_58857_ == null) {
            return false;
        }
        if (!this.hasHealthyBlades()) {
            this.processTarget = 60;
            return false;
        }
        if (this.energyContainer.getEnergy() < 5L) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            Optional<ShredderRecipe> recipe;
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.m_41619_() || (recipe = this.getRecipe(stack)).isEmpty() || !this.hasOutputSpace(recipe.get().getOutput()) || stack.m_41613_() < recipe.get().getIngredientCount()) continue;
            this.processTarget = Math.max(1, recipe.get().getProcessTime());
            return true;
        }
        this.processTarget = 60;
        return false;
    }

    private void processInputs() {
        if (this.f_58857_ == null) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack output;
            Optional<ShredderRecipe> recipeOptional;
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.m_41619_() || (recipeOptional = this.getRecipe(stack)).isEmpty()) continue;
            ShredderRecipe recipe = recipeOptional.get();
            int required = recipe.getIngredientCount();
            if (stack.m_41613_() < required || !this.hasOutputSpace(output = recipe.getOutput()) || !this.addOutput(output.m_41777_())) continue;
            stack.m_41774_(required);
            if (stack.m_41619_()) {
                this.items.set(i, (Object)ItemStack.f_41583_);
                continue;
            }
            this.items.set(i, (Object)stack);
        }
    }

    private Optional<ShredderRecipe> getRecipe(ItemStack stack) {
        if (this.f_58857_ == null || stack.m_41619_()) {
            return Optional.empty();
        }
        this.recipeContainer.m_6836_(0, stack);
        return this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipes.SHREDDER.type().get(), (Container)this.recipeContainer, this.f_58857_);
    }

    private boolean hasOutputSpace(ItemStack output) {
        for (int slot = 9; slot <= 26; ++slot) {
            ItemStack existing = (ItemStack)this.items.get(slot);
            if (existing.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_150942_((ItemStack)existing, (ItemStack)output) || existing.m_41613_() + output.m_41613_() > existing.m_41741_()) continue;
            return true;
        }
        return false;
    }

    private boolean addOutput(ItemStack output) {
        for (int slot = 9; slot <= 26; ++slot) {
            int transfer;
            ItemStack existing = (ItemStack)this.items.get(slot);
            if (existing.m_41619_()) {
                this.items.set(slot, (Object)output);
                return true;
            }
            if (!ItemStack.m_150942_((ItemStack)existing, (ItemStack)output) || (transfer = Math.min(output.m_41613_(), existing.m_41741_() - existing.m_41613_())) <= 0) continue;
            existing.m_41769_(transfer);
            output.m_41774_(transfer);
            if (!output.m_41619_()) continue;
            this.items.set(slot, (Object)existing);
            return true;
        }
        return output.m_41619_();
    }

    private boolean hasHealthyBlades() {
        int leftState = this.getBladeState(27);
        int rightState = this.getBladeState(28);
        return leftState > 0 && leftState < 3 && rightState > 0 && rightState < 3;
    }

    private void damageBlade(int slot) {
        ItemStack blade = (ItemStack)this.items.get(slot);
        if (blade.m_41619_() || !blade.m_41763_()) {
            return;
        }
        int damage = blade.m_41773_() + 1;
        if (damage >= blade.m_41776_()) {
            this.items.set(slot, (Object)ItemStack.f_41583_);
        } else {
            blade.m_41721_(damage);
            this.items.set(slot, (Object)blade);
        }
    }

    private int getBladeState(int slot) {
        ItemStack blade = (ItemStack)this.items.get(slot);
        if (blade.m_41619_()) {
            return 0;
        }
        if (!blade.m_41763_() || blade.m_41776_() == 0) {
            return 1;
        }
        if (blade.m_41773_() < blade.m_41776_() / 2) {
            return 1;
        }
        if (blade.m_41773_() < blade.m_41776_()) {
            return 2;
        }
        return 3;
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("progress");
        int n = this.processTarget = tag.m_128441_("duration") ? tag.m_128451_("duration") : 60;
        if (tag.m_128441_("energy")) {
            this.energyContainer.deserializeNBT(tag.m_128469_("energy"));
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("progress", this.progress);
        tag.m_128405_("duration", this.processTarget);
        tag.m_128365_("energy", (Tag)this.energyContainer.serializeNBT());
    }

    @Override
    public BasicEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)HBMLang.SHREDDER.key());
    }

    @Override
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new ShredderMenu(containerId, inventory, (Container)this, this.containerData);
    }
}

