/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine;

import com.hbm.api.Mode;
import com.hbm.api.energy.BasicEnergyContainer;
import com.hbm.api.energy.HybridEnergyStorage;
import com.hbm.api.energy.IEnergyContainer;
import com.hbm.api.energy.ProxyEnergyHandler;
import com.hbm.api.energy.TransmitUtils;
import com.hbm.api.inventory.ModeBuilder;
import com.hbm.block.machine.WoodBurnerBlock;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.BaseMachineBlockEntity;
import com.hbm.capabilities.HBMCaps;
import com.hbm.gui.menu.WoodBurnerMenu;
import com.hbm.item.HBMItems;
import com.hbm.registries.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoodBurnerBlockEntity
extends BaseMachineBlockEntity {
    private static final int FUEL_SLOT = 0;
    private static final int ASH_SLOT = 1;
    private static final int CHARGE_SLOT = 2;
    private static final int[] TOP_SLOTS = new int[]{0};
    private static final int[] SIDE_SLOTS = new int[]{2};
    private static final int[] BOTTOM_SLOTS = new int[]{1, 2};
    private static final long CAPACITY = 100000L;
    private static final long GENERATION_RATE = 50L;
    private static final long MAX_EXTRACT = 100L;
    private final BasicEnergyContainer energy = new BasicEnergyContainer(100000L, 0L, 100L);
    private final ContainerData containerData = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> WoodBurnerBlockEntity.this.burnTime;
                case 1 -> WoodBurnerBlockEntity.this.maxBurnTime;
                case 2 -> (int)WoodBurnerBlockEntity.this.energy.getEnergy();
                case 3 -> (int)(WoodBurnerBlockEntity.this.energy.getEnergy() >>> 32);
                case 4 -> (int)WoodBurnerBlockEntity.this.energy.getCapacity();
                case 5 -> (int)(WoodBurnerBlockEntity.this.energy.getCapacity() >>> 32);
                case 6 -> {
                    if (WoodBurnerBlockEntity.this.enabled) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            if (index == 6) {
                WoodBurnerBlockEntity.this.enabled = value != 0;
            }
        }

        public int m_6499_() {
            return 7;
        }
    };
    private int burnTime;
    private int maxBurnTime;
    private boolean enabled = true;

    public WoodBurnerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.WOOD_BURNER_ENTITY.get(), pos, state);
        this.items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
        this.slotModes = new ModeBuilder().addMode(Mode.INPUT).addMode(Mode.OUTPUT).addMode(Mode.BOTH).get();
        this.energy.setListener(this::m_6596_);
        this.capabilitiesContent.addCapability(HBMCaps.LONG_ENERGY, new ProxyEnergyHandler(this.energy));
        this.capabilitiesContent.addCapability(ForgeCapabilities.ENERGY, new HybridEnergyStorage(this.energy));
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        boolean wasBurning = this.isBurning();
        if (this.enabled && this.burnTime <= 0 && this.canStartBurn()) {
            this.startBurning();
        }
        if (this.enabled && this.burnTime > 0) {
            --this.burnTime;
            this.energy.receive(50L, false);
            TransmitUtils.chargeItem(this, this.getStackInSlot(2));
            if (this.burnTime == 0) {
                this.finishBurnCycle();
            }
        }
        TransmitUtils.outputOnly(this);
        if (wasBurning != this.isBurning()) {
            this.updateLitState();
        }
    }

    private void updateLitState() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (!(state.m_60734_() instanceof WoodBurnerBlock)) {
            return;
        }
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)WoodBurnerBlock.LIT, (Comparable)Boolean.valueOf(this.isBurning())), 3);
    }

    private boolean canStartBurn() {
        ItemStack fuel = this.getStackInSlot(0);
        return !fuel.m_41619_() && this.energy.getEnergy() < this.energy.getCapacity() && ForgeHooks.getBurnTime((ItemStack)fuel, (RecipeType)RecipeType.f_44108_) > 0;
    }

    private void startBurning() {
        ItemStack fuel = this.getStackInSlot(0);
        int ticks = ForgeHooks.getBurnTime((ItemStack)fuel, (RecipeType)RecipeType.f_44108_);
        if (ticks <= 0) {
            return;
        }
        this.burnTime = ticks;
        this.maxBurnTime = ticks;
        if (fuel.m_150930_(Items.f_42448_)) {
            this.m_6836_(0, new ItemStack((ItemLike)Items.f_42446_));
        } else {
            fuel.m_41774_(1);
        }
        this.m_6596_();
    }

    private void finishBurnCycle() {
        RandomSource random;
        RandomSource randomSource = random = this.f_58857_ != null ? this.f_58857_.f_46441_ : RandomSource.m_216327_();
        if (random.m_188501_() < 0.5f) {
            ItemStack ash = this.getStackInSlot(1);
            if (ash.m_41619_()) {
                this.m_6836_(1, new ItemStack((ItemLike)HBMItems.WOOD_ASH_POWDER.get()));
            } else if (ash.m_150930_((Item)HBMItems.WOOD_ASH_POWDER.get()) && ash.m_41613_() < ash.m_41741_()) {
                ash.m_41769_(1);
                this.m_6596_();
            }
        }
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void toggleEnabled() {
        this.enabled = !this.enabled;
        this.m_6596_();
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("BurnTime", this.burnTime);
        tag.m_128405_("MaxBurnTime", this.maxBurnTime);
        tag.m_128379_("Enabled", this.enabled);
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.burnTime = tag.m_128451_("BurnTime");
        this.maxBurnTime = tag.m_128451_("MaxBurnTime");
        boolean bl = this.enabled = tag.m_128441_("Enabled") ? tag.m_128471_("Enabled") : true;
        if (tag.m_128441_("energy")) {
            this.energy.deserializeNBT(tag.m_128469_("energy"));
        }
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)"container.hbm.machine_wood_burner");
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new WoodBurnerMenu(containerId, inventory, this, this.containerData);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index == 0) {
            return ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0;
        }
        if (index == 2) {
            return this.isChargeable(stack);
        }
        return false;
    }

    private boolean isChargeable(ItemStack stack) {
        return stack.m_204117_(ModTags.Items.CHARGEABLE) || stack.getCapability(HBMCaps.LONG_ENERGY).isPresent() || stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        if (index == 1) {
            return direction == Direction.DOWN;
        }
        if (index == 2) {
            return direction != Direction.UP;
        }
        return index == 0 && direction == Direction.DOWN;
    }

    @Override
    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        if (index == 0) {
            return direction == Direction.UP && ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0;
        }
        if (index == 2) {
            return direction != Direction.DOWN && this.isChargeable(stack);
        }
        return false;
    }

    @Override
    public int @NotNull [] m_7071_(Direction side) {
        if (side == Direction.DOWN) {
            return BOTTOM_SLOTS;
        }
        if (side == Direction.UP) {
            return TOP_SLOTS;
        }
        return SIDE_SLOTS;
    }

    @Override
    public IEnergyContainer getEnergyContainer() {
        return this.energy;
    }
}

