/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine;

import com.hbm.Inventory.fluid.ModFluids;
import com.hbm.api.Mode;
import com.hbm.api.fluid.BasicFluidHandler;
import com.hbm.block.machine.BlockZirnoxReactor;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.DummyableBlockEntity;
import com.hbm.gui.menu.ZirnoxMenu;
import com.hbm.item.HBMItems;
import com.hbm.item.zirnox.ItemZirnoxRod;
import com.hbm.registries.ModBlocks;
import com.hbm.utils.InventoryUtils;
import com.hbm.utils.multiblock.DummableHelper;
import com.hbm.utils.multiblock.MultiblockData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class ZirnoxReactorBlockEntity
extends DummyableBlockEntity {
    public static final int MAX_HEAT = 100000;
    public static final int MAX_PRESSURE = 100000;
    public static final int STEAM_CAPACITY = 8000;
    public static final int CO2_CAPACITY = 16000;
    public static final int WATER_CAPACITY = 32000;
    private static final int SLOT_ROD_END = 24;
    private static final int SLOT_CO2_IN = 24;
    private static final int SLOT_WATER_IN = 25;
    private static final int SLOT_CO2_OUT = 26;
    private static final int SLOT_WATER_OUT = 27;
    public int heat;
    public int pressure;
    public boolean isOn;
    private int output;
    private final BasicFluidHandler fluidHandler = new BasicFluidHandler().addTank(8000, Mode.BOTH).addTank(16000, Mode.INPUT).addTank(32000, Mode.INPUT);
    private final ContainerData containerData = new SimpleContainerData(6){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ZirnoxReactorBlockEntity.this.heat;
                case 1 -> ZirnoxReactorBlockEntity.this.pressure;
                case 2 -> ZirnoxReactorBlockEntity.this.fluidHandler.getFluidTanks().get(0).getFluidAmount();
                case 3 -> ZirnoxReactorBlockEntity.this.fluidHandler.getFluidTanks().get(1).getFluidAmount();
                case 4 -> ZirnoxReactorBlockEntity.this.fluidHandler.getFluidTanks().get(2).getFluidAmount();
                case 5 -> {
                    if (ZirnoxReactorBlockEntity.this.isOn) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }
    };

    public ZirnoxReactorBlockEntity(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)ModBlockEntityType.ZIRNOX_REACTOR_ENTITY.get(), pPos, pState);
        this.items = NonNullList.m_122780_((int)28, (Object)ItemStack.f_41583_);
        this.multiblockData = MultiblockData.mapping.get(ModBlocks.machine_zirnox.get());
        this.capabilitiesContent.addCapability(ForgeCapabilities.FLUID_HANDLER, this.fluidHandler);
        this.fluidHandler.getFluidTanks().set(0, new FluidTank(8000){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_6212_((Fluid)ModFluids.SUPERHOT_STEAM.source().get());
            }
        });
        this.fluidHandler.getFluidTanks().set(1, new FluidTank(16000){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_6212_((Fluid)ModFluids.CARBON_DIOXIDE.source().get());
            }
        });
        this.fluidHandler.getFluidTanks().set(2, new FluidTank(32000){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_6212_((Fluid)Fluids.f_76193_);
            }
        });
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot < 24) {
            return stack.m_41720_() instanceof ItemZirnoxRod;
        }
        if (slot == 24) {
            return this.isFluidContainer(stack, (Fluid)ModFluids.CARBON_DIOXIDE.source().get());
        }
        if (slot == 25) {
            return this.isFluidContainer(stack, (Fluid)Fluids.f_76193_);
        }
        return false;
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.f_58857_ == null) {
            return;
        }
        this.output = 0;
        InventoryUtils.handleItems(this, stack -> this.fluidHandler.drainItem(1, (ItemStack)stack), 24, 26);
        InventoryUtils.handleItems(this, stack -> this.fluidHandler.drainItem(2, (ItemStack)stack), 25, 27);
        if (this.isOn) {
            for (int i = 0; i < 24; ++i) {
                ItemStack stack2 = (ItemStack)this.items.get(i);
                if (stack2.m_41619_() || !(stack2.m_41720_() instanceof ItemZirnoxRod)) continue;
                this.decay(i);
            }
        }
        int co2Fill = this.fluidHandler.getFluidTanks().get(1).getFluidAmount();
        this.pressure = co2Fill * 2 + (int)((float)this.heat * ((float)co2Fill / 16000.0f));
        if (this.heat > 0 && this.heat < 100000) {
            if (this.fluidHandler.getFluidTanks().get(2).getFluidAmount() > 0 && co2Fill > 0 && this.fluidHandler.getFluidTanks().get(0).getFluidAmount() < 8000) {
                this.generateSteam();
                this.heat -= (int)((float)this.heat * (float)this.pressure / 1000000.0f);
            } else {
                this.heat -= 10;
            }
        }
        if (this.heat < 0) {
            this.heat = 0;
        }
        this.checkIfMeltdown();
        this.sendUpdatePacket();
    }

    private void generateSteam() {
        int cycle;
        if (this.heat <= 10256) {
            return;
        }
        int co2Fill = this.fluidHandler.getFluidTanks().get(1).getFluidAmount();
        int waterFill = this.fluidHandler.getFluidTanks().get(2).getFluidAmount();
        int steamFill = this.fluidHandler.getFluidTanks().get(0).getFluidAmount();
        this.output = cycle = (int)(((float)this.heat - 10256.0f) / 100000.0f * Math.min((float)co2Fill / 14000.0f, 1.0f) * 25.0f * 5.0f);
        int drained = Math.min(cycle, waterFill);
        int space = 8000 - steamFill;
        int produced = Math.min(drained, space);
        this.fluidHandler.getFluidTanks().get(2).drain(produced, IFluidHandler.FluidAction.EXECUTE);
        this.fluidHandler.getFluidTanks().get(0).fill(new FluidStack((Fluid)ModFluids.SUPERHOT_STEAM.source().get(), produced), IFluidHandler.FluidAction.EXECUTE);
    }

    private boolean hasFuelRod(int id) {
        ItemStack stack = (ItemStack)this.items.get(id);
        if (!stack.m_41619_() && stack.m_41720_() instanceof ItemZirnoxRod) {
            ItemZirnoxRod.ZirnoxRodType type = ItemZirnoxRod.getRodType(stack);
            return !type.breeding;
        }
        return false;
    }

    private int getNeighbourCount(int id) {
        int[] neighbours = this.getNeighbouringSlots(id);
        if (neighbours == null) {
            return 0;
        }
        int count = 0;
        for (int neighbour : neighbours) {
            if (!this.hasFuelRod(neighbour)) continue;
            ++count;
        }
        return count;
    }

    private void decay(int id) {
        ItemStack stack = (ItemStack)this.items.get(id);
        if (stack.m_41619_() || !(stack.m_41720_() instanceof ItemZirnoxRod)) {
            return;
        }
        ItemZirnoxRod.ZirnoxRodType type = ItemZirnoxRod.getRodType(stack);
        int decay = this.getNeighbourCount(id);
        if (!type.breeding) {
            ++decay;
        }
        for (int i = 0; i < decay; ++i) {
            this.heat += type.heat;
            ItemZirnoxRod.incrementLifeTime(stack);
            if (ItemZirnoxRod.getLifeTime(stack) <= type.maxLife) continue;
            this.items.set(id, (Object)this.getDepletedStack(type));
            break;
        }
    }

    private ItemStack getDepletedStack(ItemZirnoxRod.ZirnoxRodType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ItemZirnoxRod.ZirnoxRodType.NATURAL_URANIUM_FUEL -> new ItemStack((ItemLike)HBMItems.rod_zirnox_natural_uranium_fuel_depleted.get());
            case ItemZirnoxRod.ZirnoxRodType.URANIUM_FUEL -> new ItemStack((ItemLike)HBMItems.rod_zirnox_uranium_fuel_depleted.get());
            case ItemZirnoxRod.ZirnoxRodType.TH232 -> ItemZirnoxRod.createStack((Item)HBMItems.rod_zirnox.get(), ItemZirnoxRod.ZirnoxRodType.THORIUM_FUEL);
            case ItemZirnoxRod.ZirnoxRodType.THORIUM_FUEL -> new ItemStack((ItemLike)HBMItems.rod_zirnox_thorium_fuel_depleted.get());
            case ItemZirnoxRod.ZirnoxRodType.MOX_FUEL -> new ItemStack((ItemLike)HBMItems.rod_zirnox_mox_fuel_depleted.get());
            case ItemZirnoxRod.ZirnoxRodType.PLUTONIUM_FUEL -> new ItemStack((ItemLike)HBMItems.rod_zirnox_plutonium_fuel_depleted.get());
            case ItemZirnoxRod.ZirnoxRodType.U233_FUEL -> new ItemStack((ItemLike)HBMItems.rod_zirnox_u233_fuel_depleted.get());
            case ItemZirnoxRod.ZirnoxRodType.U235_FUEL -> new ItemStack((ItemLike)HBMItems.rod_zirnox_u235_fuel_depleted.get());
            case ItemZirnoxRod.ZirnoxRodType.LES_FUEL -> new ItemStack((ItemLike)HBMItems.rod_zirnox_les_fuel_depleted.get());
            case ItemZirnoxRod.ZirnoxRodType.LITHIUM -> new ItemStack((ItemLike)HBMItems.rod_zirnox_tritium.get());
            case ItemZirnoxRod.ZirnoxRodType.ZFB_MOX -> new ItemStack((ItemLike)HBMItems.rod_zirnox_zfb_mox_depleted.get());
        };
    }

    private void checkIfMeltdown() {
        if (this.pressure > 100000 || this.heat > 100000) {
            this.meltdown();
        }
    }

    private boolean isFluidContainer(ItemStack stack, Fluid fluid) {
        Item item = stack.m_41720_();
        if (item instanceof BucketItem) {
            BucketItem bucket = (BucketItem)item;
            return bucket.getFluid().m_6212_(fluid);
        }
        FluidStack contained = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
        return !contained.isEmpty() && contained.getFluid().m_6212_(fluid);
    }

    private void meltdown() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.set(i, (Object)ItemStack.f_41583_);
        }
        BlockState state = this.m_58900_();
        DummableHelper.clearSpace(this.f_58857_, this.f_58858_, state, (Direction)state.m_61143_((Property)BlockZirnoxReactor.FACING));
        this.f_58857_.m_7731_(this.f_58858_, ((Block)ModBlocks.zirnox_destroyed.get()).m_49966_(), 3);
        this.f_58857_.m_254849_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 2.5, (double)this.f_58858_.m_123343_() + 0.5, 12.0f, Level.ExplosionInteraction.BLOCK);
        this.m_6596_();
    }

    public void toggleActive() {
        this.isOn = !this.isOn;
        this.m_6596_();
    }

    public void ventCarbonDioxide() {
        FluidTank tank = this.fluidHandler.getFluidTanks().get(1);
        tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        this.m_6596_();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.heat = tag.m_128451_("heat");
        this.pressure = tag.m_128451_("pressure");
        this.isOn = tag.m_128471_("running");
        if (tag.m_128441_("fluids")) {
            this.fluidHandler.deserializeNBT(tag.m_128469_("fluids"));
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("heat", this.heat);
        tag.m_128405_("pressure", this.pressure);
        tag.m_128379_("running", this.isOn);
        tag.m_128365_("fluids", (Tag)this.fluidHandler.serializeNBT());
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)"container.zirnox");
    }

    @Override
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory) {
        return new ZirnoxMenu(pContainerId, pInventory, (Container)this, this.containerData);
    }

    private int[] getNeighbouringSlots(int id) {
        int[] nArray;
        switch (id) {
            case 0: {
                int[] nArray2 = new int[2];
                nArray2[0] = 1;
                nArray = nArray2;
                nArray2[1] = 7;
                break;
            }
            case 1: {
                int[] nArray3 = new int[3];
                nArray3[0] = 0;
                nArray3[1] = 2;
                nArray = nArray3;
                nArray3[2] = 8;
                break;
            }
            case 2: {
                int[] nArray4 = new int[2];
                nArray4[0] = 1;
                nArray = nArray4;
                nArray4[1] = 9;
                break;
            }
            case 3: {
                int[] nArray5 = new int[2];
                nArray5[0] = 4;
                nArray = nArray5;
                nArray5[1] = 10;
                break;
            }
            case 4: {
                int[] nArray6 = new int[3];
                nArray6[0] = 3;
                nArray6[1] = 5;
                nArray = nArray6;
                nArray6[2] = 11;
                break;
            }
            case 5: {
                int[] nArray7 = new int[3];
                nArray7[0] = 4;
                nArray7[1] = 6;
                nArray = nArray7;
                nArray7[2] = 12;
                break;
            }
            case 6: {
                int[] nArray8 = new int[2];
                nArray8[0] = 5;
                nArray = nArray8;
                nArray8[1] = 13;
                break;
            }
            case 7: {
                int[] nArray9 = new int[3];
                nArray9[0] = 0;
                nArray9[1] = 8;
                nArray = nArray9;
                nArray9[2] = 14;
                break;
            }
            case 8: {
                int[] nArray10 = new int[4];
                nArray10[0] = 1;
                nArray10[1] = 7;
                nArray10[2] = 9;
                nArray = nArray10;
                nArray10[3] = 15;
                break;
            }
            case 9: {
                int[] nArray11 = new int[3];
                nArray11[0] = 2;
                nArray11[1] = 8;
                nArray = nArray11;
                nArray11[2] = 16;
                break;
            }
            case 10: {
                int[] nArray12 = new int[3];
                nArray12[0] = 3;
                nArray12[1] = 11;
                nArray = nArray12;
                nArray12[2] = 17;
                break;
            }
            case 11: {
                int[] nArray13 = new int[4];
                nArray13[0] = 4;
                nArray13[1] = 10;
                nArray13[2] = 12;
                nArray = nArray13;
                nArray13[3] = 18;
                break;
            }
            case 12: {
                int[] nArray14 = new int[4];
                nArray14[0] = 5;
                nArray14[1] = 11;
                nArray14[2] = 13;
                nArray = nArray14;
                nArray14[3] = 19;
                break;
            }
            case 13: {
                int[] nArray15 = new int[3];
                nArray15[0] = 6;
                nArray15[1] = 12;
                nArray = nArray15;
                nArray15[2] = 20;
                break;
            }
            case 14: {
                int[] nArray16 = new int[3];
                nArray16[0] = 7;
                nArray16[1] = 15;
                nArray = nArray16;
                nArray16[2] = 21;
                break;
            }
            case 15: {
                int[] nArray17 = new int[4];
                nArray17[0] = 8;
                nArray17[1] = 14;
                nArray17[2] = 16;
                nArray = nArray17;
                nArray17[3] = 22;
                break;
            }
            case 16: {
                int[] nArray18 = new int[3];
                nArray18[0] = 9;
                nArray18[1] = 15;
                nArray = nArray18;
                nArray18[2] = 23;
                break;
            }
            case 17: {
                int[] nArray19 = new int[2];
                nArray19[0] = 10;
                nArray = nArray19;
                nArray19[1] = 18;
                break;
            }
            case 18: {
                int[] nArray20 = new int[3];
                nArray20[0] = 11;
                nArray20[1] = 17;
                nArray = nArray20;
                nArray20[2] = 19;
                break;
            }
            case 19: {
                int[] nArray21 = new int[3];
                nArray21[0] = 12;
                nArray21[1] = 18;
                nArray = nArray21;
                nArray21[2] = 20;
                break;
            }
            case 20: {
                int[] nArray22 = new int[2];
                nArray22[0] = 13;
                nArray = nArray22;
                nArray22[1] = 19;
                break;
            }
            case 21: {
                int[] nArray23 = new int[2];
                nArray23[0] = 14;
                nArray = nArray23;
                nArray23[1] = 22;
                break;
            }
            case 22: {
                int[] nArray24 = new int[3];
                nArray24[0] = 15;
                nArray24[1] = 21;
                nArray = nArray24;
                nArray24[2] = 23;
                break;
            }
            case 23: {
                int[] nArray25 = new int[2];
                nArray25[0] = 16;
                nArray = nArray25;
                nArray25[1] = 22;
                break;
            }
            default: {
                nArray = null;
            }
        }
        return nArray;
    }
}

