/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine.component;

import com.hbm.Inventory.fluid.ModFluids;
import com.hbm.api.Mode;
import com.hbm.api.fluid.BasicFluidHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public final class CondenserLogic {
    private static final String TAG_FLUIDS = "Fluids";
    private static final String TAG_TIMER = "WaterTimer";
    private static final String TAG_THROUGHPUT = "Throughput";
    private final BasicFluidHandler fluidHandler;
    private final int conversionRate;
    private final int steamTankIndex;
    private final int waterTankIndex;
    private int waterTimer;
    private int throughput;

    public CondenserLogic(int steamCapacity, int waterCapacity, int conversionRate) {
        this.conversionRate = conversionRate;
        this.steamTankIndex = 0;
        this.waterTankIndex = 1;
        this.fluidHandler = new BasicFluidHandler().addTank(steamCapacity, Mode.INPUT).addTank(waterCapacity, Mode.OUTPUT);
        this.configureTanks();
    }

    private void configureTanks() {
        FluidTank steamTank = this.fluidHandler.getFluidTanks().get(this.steamTankIndex);
        steamTank.setValidator(stack -> stack.getFluid() == ModFluids.SPENT_STEAM.source().get());
        steamTank.setFluid(new FluidStack((Fluid)ModFluids.SPENT_STEAM.source().get(), 0));
        FluidTank waterTank = this.fluidHandler.getFluidTanks().get(this.waterTankIndex);
        waterTank.setValidator(stack -> stack.getFluid().m_6212_((Fluid)Fluids.f_76193_));
        waterTank.setFluid(new FluidStack((Fluid)Fluids.f_76193_, 0));
    }

    public BasicFluidHandler handler() {
        return this.fluidHandler;
    }

    public boolean tick(Level level) {
        if (this.waterTimer > 0) {
            --this.waterTimer;
        }
        this.throughput = 0;
        FluidTank steam = this.fluidHandler.getFluidTanks().get(this.steamTankIndex);
        FluidTank water = this.fluidHandler.getFluidTanks().get(this.waterTankIndex);
        if (steam.isEmpty()) {
            return false;
        }
        int space = water.getSpace();
        if (space <= 0) {
            return false;
        }
        int toConvert = this.conversionRate <= 0 ? steam.getFluidAmount() : Math.min(this.conversionRate, steam.getFluidAmount());
        if ((toConvert = Math.min(toConvert, space)) <= 0) {
            return false;
        }
        FluidStack drained = steam.drain(toConvert, IFluidHandler.FluidAction.EXECUTE);
        if (drained.isEmpty()) {
            return false;
        }
        FluidStack fillStack = new FluidStack((Fluid)Fluids.f_76193_, drained.getAmount());
        water.fill(fillStack, IFluidHandler.FluidAction.EXECUTE);
        this.waterTimer = 20;
        this.throughput = drained.getAmount();
        return true;
    }

    public int getWaterTimer() {
        return this.waterTimer;
    }

    public int getThroughput() {
        return this.throughput;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(TAG_FLUIDS, (Tag)this.fluidHandler.serializeNBT());
        tag.m_128405_(TAG_TIMER, this.waterTimer);
        tag.m_128405_(TAG_THROUGHPUT, this.throughput);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128441_(TAG_FLUIDS)) {
            this.fluidHandler.deserializeNBT(tag.m_128469_(TAG_FLUIDS));
        } else {
            this.configureTanks();
        }
        this.waterTimer = tag.m_128451_(TAG_TIMER);
        this.throughput = tag.m_128451_(TAG_THROUGHPUT);
    }

    public void appendToTag(CompoundTag tag) {
        tag.m_128365_(TAG_FLUIDS, (Tag)this.fluidHandler.serializeNBT());
        tag.m_128405_(TAG_TIMER, this.waterTimer);
        tag.m_128405_(TAG_THROUGHPUT, this.throughput);
    }

    public void readFromTag(CompoundTag tag) {
        if (tag.m_128441_(TAG_FLUIDS)) {
            this.fluidHandler.deserializeNBT(tag.m_128469_(TAG_FLUIDS));
        } else {
            this.configureTanks();
        }
        if (tag.m_128441_(TAG_TIMER)) {
            this.waterTimer = tag.m_128451_(TAG_TIMER);
        }
        if (tag.m_128441_(TAG_THROUGHPUT)) {
            this.throughput = tag.m_128451_(TAG_THROUGHPUT);
        }
    }

    public void writeSyncTag(CompoundTag tag) {
        tag.m_128365_(TAG_FLUIDS, (Tag)this.fluidHandler.serializeNBT());
        tag.m_128405_("waterTimer", this.waterTimer);
    }

    public void readSyncTag(CompoundTag tag) {
        if (tag.m_128441_(TAG_FLUIDS)) {
            this.fluidHandler.deserializeNBT(tag.m_128469_(TAG_FLUIDS));
        }
        if (tag.m_128441_("waterTimer")) {
            this.waterTimer = tag.m_128451_("waterTimer");
        }
    }
}

