/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine.icf;

import com.hbm.HBMLang;
import com.hbm.api.energy.BasicEnergyContainer;
import com.hbm.api.energy.HybridEnergyStorage;
import com.hbm.api.energy.ProxyEnergyHandler;
import com.hbm.api.energy.TransmitUtils;
import com.hbm.block.base.BaseMachineBlock;
import com.hbm.block.machine.icf.BlockICFReactor;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.BaseMachineBlockEntity;
import com.hbm.blockentity.machine.icf.ICFReactorBlockEntity;
import com.hbm.capabilities.HBMCaps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ICFControllerBlockEntity
extends BaseMachineBlockEntity {
    private static final long MAX_ENERGY = 50000000L;
    private static final long LASER_TRANSFER = 400000L;
    private static final int MAX_DISTANCE = 48;
    private final BasicEnergyContainer energy = new BasicEnergyContainer(50000000L, 50000000L, 400000L);
    private final HybridEnergyStorage forgeEnergy = new HybridEnergyStorage(this.energy);
    private BlockPos targetCore;
    private int beamLength;
    private boolean enabled = true;
    private int scanCooldown = 10;

    public ICFControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.ICF_CONTROLLER_ENTITY.get(), pos, state);
        this.items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
        this.capabilitiesContent.addCapability(ForgeCapabilities.ITEM_HANDLER, this);
        this.capabilitiesContent.addCapability(HBMCaps.LONG_ENERGY, new ProxyEnergyHandler(this.energy));
        this.capabilitiesContent.addCapability(ForgeCapabilities.ENERGY, this.forgeEnergy);
        this.energy.setListener(this);
    }

    @Override
    protected void onUpdateServer() {
        ICFReactorBlockEntity reactor;
        block9: {
            block8: {
                super.onUpdateServer();
                if (this.f_58857_ == null) {
                    return;
                }
                TransmitUtils.dischargeItem(this, (ItemStack)this.items.get(0));
                if (--this.scanCooldown <= 0 || this.targetCore == null) {
                    this.rescanTarget(false);
                    this.scanCooldown = 20;
                }
                if (!this.enabled || this.targetCore == null) {
                    this.beamLength = 0;
                    return;
                }
                BlockEntity target = this.f_58857_.m_7702_(this.targetCore);
                if (!(target instanceof ICFReactorBlockEntity)) break block8;
                reactor = (ICFReactorBlockEntity)target;
                if (((ICFReactorBlockEntity)target).isFormed) break block9;
            }
            this.targetCore = null;
            this.beamLength = 0;
            return;
        }
        if (!this.isLineClear(reactor)) {
            this.targetCore = null;
            this.beamLength = 0;
            return;
        }
        long available = this.energy.getEnergy();
        if (available <= 0L) {
            this.beamLength = 0;
            return;
        }
        long toSend = Math.min(400000L, available);
        this.energy.extract(toSend, false);
        reactor.receiveLaser(toSend, this.energy.getCapacity());
        this.beamLength = Math.max(this.beamLength, 1);
        this.spawnBeamParticles();
    }

    private boolean isLineClear(ICFReactorBlockEntity reactor) {
        if (this.f_58857_ == null) {
            return false;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BaseMachineBlock.FACING);
        int max = this.beamLength == 0 ? 48 : this.beamLength;
        for (int i = 1; i < max; ++i) {
            BlockPos current = this.f_58858_.m_5484_(facing, i);
            if (current.equals((Object)reactor.m_58899_())) {
                this.beamLength = i;
                return true;
            }
            BlockState state = this.f_58857_.m_8055_(current);
            if (state.m_60795_()) continue;
            Block block = state.m_60734_();
            if (block instanceof BlockICFReactor) {
                this.beamLength = i;
                return true;
            }
            float hardness = state.m_60800_((BlockGetter)this.f_58857_, current);
            if (hardness >= 0.0f && hardness < 10.0f) {
                this.f_58857_.m_46961_(current, false);
                continue;
            }
            return false;
        }
        return false;
    }

    private void spawnBeamParticles() {
        if (this.f_58857_ == null || this.beamLength <= 0) {
            return;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BaseMachineBlock.FACING);
        Vec3 start = Vec3.m_82512_((Vec3i)this.f_58858_);
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        for (int i = 1; i < this.beamLength; i += 3) {
            Vec3 pos = start.m_82520_((double)(facing.m_122429_() * i), (double)(facing.m_122430_() * i), (double)(facing.m_122431_() * i));
            server.m_8767_((ParticleOptions)ParticleTypes.f_123810_, pos.f_82479_, pos.f_82480_ + 0.2, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void forceRescan(boolean notify) {
        this.rescanTarget(true);
        if (notify && this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundEvents.f_12210_.m_203334_(), SoundSource.BLOCKS, 0.4f, 1.2f);
        }
    }

    private void rescanTarget(boolean reset) {
        if (this.f_58857_ == null) {
            return;
        }
        if (reset) {
            this.targetCore = null;
            this.beamLength = 0;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BaseMachineBlock.FACING);
        for (int i = 1; i <= 48; ++i) {
            BlockICFReactor reactorBlock;
            BlockPos core;
            BlockPos current = this.f_58858_.m_5484_(facing, i);
            BlockState state = this.f_58857_.m_8055_(current);
            Block block = state.m_60734_();
            if (!(block instanceof BlockICFReactor) || (core = (reactorBlock = (BlockICFReactor)block).getCore(state, (LevelReader)this.f_58857_, current)) == null) continue;
            this.targetCore = core;
            this.beamLength = i;
            return;
        }
    }

    public void toggleEnabled() {
        this.enabled = !this.enabled;
        this.m_6596_();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        int[] coords;
        super.m_142466_(tag);
        this.energy.deserializeNBT(tag.m_128469_("energy"));
        if (tag.m_128441_("target") && (coords = tag.m_128465_("target")).length == 3) {
            this.targetCore = new BlockPos(coords[0], coords[1], coords[2]);
        }
        this.enabled = tag.m_128471_("enabled");
        this.beamLength = tag.m_128451_("beamLength");
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        if (this.targetCore != null) {
            tag.m_128385_("target", new int[]{this.targetCore.m_123341_(), this.targetCore.m_123342_(), this.targetCore.m_123343_()});
        }
        tag.m_128379_("enabled", this.enabled);
        tag.m_128405_("beamLength", this.beamLength);
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)HBMLang.ICF_CONTROLLER.key());
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return null;
    }
}

