/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine.icf;

import com.hbm.HBMLang;
import com.hbm.api.Mode;
import com.hbm.api.fluid.BasicFluidHandler;
import com.hbm.api.inventory.ModeBuilder;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.BaseMachineBlockEntity;
import com.hbm.gui.menu.ICFPressMenu;
import com.hbm.item.HBMComponent;
import com.hbm.item.HBMItems;
import com.hbm.item.icf.ItemICFPellet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class ICFPressBlockEntity
extends BaseMachineBlockEntity
implements MenuProvider {
    public static final int SLOT_EMPTY = 0;
    public static final int SLOT_OUTPUT = 1;
    public static final int SLOT_MUON = 2;
    public static final int SLOT_MUON_RETURN = 3;
    public static final int SLOT_FUEL_LEFT = 4;
    public static final int SLOT_FUEL_RIGHT = 5;
    public static final int SLOT_LEFT_BUFFER = 6;
    public static final int SLOT_RIGHT_BUFFER = 7;
    private static final int MUON_CAPACITY = 16;
    private static final int TANK_CAPACITY = 16000;
    private static final int FLUID_PER_PELLET = 1000;
    private int muonCharge = 0;
    private final BasicFluidHandler fluids;
    private final FluidTank leftTank;
    private final FluidTank rightTank;
    private final ContainerData containerData = new SimpleContainerData(3){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ICFPressBlockEntity.this.muonCharge;
                case 1 -> ICFPressBlockEntity.this.leftTank.getFluidAmount();
                case 2 -> ICFPressBlockEntity.this.rightTank.getFluidAmount();
                default -> 0;
            };
        }
    };

    public ICFPressBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.ICF_PRESS_ENTITY.get(), pos, state);
        this.items = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
        this.slotModes = new ModeBuilder().addModes(new Object[]{1, Mode.INPUT, 1, Mode.OUTPUT, 2, Mode.INPUT, 2, Mode.OUTPUT, 2, Mode.INPUT}).get();
        this.capabilitiesContent.addCapability(ForgeCapabilities.ITEM_HANDLER, this);
        this.fluids = new BasicFluidHandler().addTank(16000, Mode.INPUT).addTank(16000, Mode.INPUT);
        this.leftTank = this.createFuelTank();
        this.rightTank = this.createFuelTank();
        this.fluids.getFluidTanks().set(0, this.leftTank);
        this.fluids.getFluidTanks().set(1, this.rightTank);
        this.capabilitiesContent.addCapability(ForgeCapabilities.FLUID_HANDLER, this.fluids);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        boolean changed = false;
        changed |= this.chargeMuon();
        this.refillBuffers();
        if (changed |= this.tryAssemble()) {
            this.m_6596_();
        }
    }

    private boolean chargeMuon() {
        ItemStack muon = (ItemStack)this.items.get(2);
        if (this.muonCharge >= 16 || muon.m_41619_() || !muon.m_150930_((Item)HBMComponent.PARTICLE_MUON.get())) {
            return false;
        }
        ItemStack container = new ItemStack((ItemLike)HBMComponent.PARTICLE_EMPTY.get());
        ItemStack returnSlot = (ItemStack)this.items.get(3);
        if (!(returnSlot.m_41619_() || ItemStack.m_150942_((ItemStack)returnSlot, (ItemStack)container) && returnSlot.m_41613_() < returnSlot.m_41741_())) {
            return false;
        }
        muon.m_41774_(1);
        if (muon.m_41619_()) {
            this.items.set(2, (Object)ItemStack.f_41583_);
        }
        this.addToSlot(3, container);
        this.muonCharge = 16;
        return true;
    }

    private void refillBuffers() {
        this.moveReserve(4, 6);
        this.moveReserve(5, 7);
    }

    private void moveReserve(int bufferSlot, int reserveSlot) {
        ItemStack buffer = (ItemStack)this.items.get(bufferSlot);
        if (!buffer.m_41619_()) {
            return;
        }
        ItemStack reserve = (ItemStack)this.items.get(reserveSlot);
        if (reserve.m_41619_()) {
            return;
        }
        if (ItemICFPellet.fuelFromStack(reserve) == null) {
            return;
        }
        ItemStack single = reserve.m_41620_(1);
        this.items.set(bufferSlot, (Object)single);
        if (reserve.m_41619_()) {
            this.items.set(reserveSlot, (Object)ItemStack.f_41583_);
        }
    }

    private boolean tryAssemble() {
        boolean muonCatalysed;
        ItemStack empty = (ItemStack)this.items.get(0);
        if (empty.m_41619_() || !empty.m_150930_((Item)HBMItems.icf_pellet_empty.get())) {
            return false;
        }
        ItemStack output = (ItemStack)this.items.get(1);
        if (!output.m_41619_()) {
            return false;
        }
        FuelPair pair = this.findFuels();
        if (pair == null) {
            return false;
        }
        boolean bl = muonCatalysed = this.muonCharge > 0;
        if (muonCatalysed) {
            --this.muonCharge;
        }
        ItemStack pellet = ItemICFPellet.createStack(pair.primary.type(), pair.secondary.type(), muonCatalysed);
        this.items.set(1, (Object)pellet);
        this.consumeSlot(0);
        this.consumeSource(pair.primary);
        this.consumeSource(pair.secondary);
        return true;
    }

    private void consumeSlot(int slot) {
        ItemStack stack = (ItemStack)this.items.get(slot);
        stack.m_41774_(1);
        if (stack.m_41619_()) {
            this.items.set(slot, (Object)ItemStack.f_41583_);
        }
    }

    private FuelPair findFuels() {
        FuelSource left = this.resolveFuel(4, this.leftTank);
        FuelSource right = this.resolveFuel(5, this.rightTank);
        if (left == null || right == null || left.type() == right.type()) {
            return null;
        }
        return new FuelPair(left, right);
    }

    private FuelSource resolveFuel(int slot, FluidTank tank) {
        ItemStack stack = (ItemStack)this.items.get(slot);
        ItemICFPellet.FuelType type = ItemICFPellet.fuelFromStack(stack);
        if (type != null) {
            return new FuelSource(type, slot, null);
        }
        ItemICFPellet.FuelType fluid = ItemICFPellet.fuelFromFluid(tank.getFluid());
        if (fluid != null && tank.getFluidAmount() >= 1000) {
            return new FuelSource(fluid, -1, tank);
        }
        return null;
    }

    private void consumeSource(FuelSource source) {
        if (source == null) {
            return;
        }
        if (source.usesFluid()) {
            source.tank().drain(1000, IFluidHandler.FluidAction.EXECUTE);
        } else if (source.slot() >= 0) {
            this.consumeSlot(source.slot());
        }
    }

    private void addToSlot(int slot, ItemStack addition) {
        ItemStack existing = (ItemStack)this.items.get(slot);
        if (existing.m_41619_()) {
            this.items.set(slot, (Object)addition);
        } else if (ItemStack.m_150942_((ItemStack)existing, (ItemStack)addition)) {
            existing.m_41769_(addition.m_41613_());
        }
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index == 0) {
            return stack.m_150930_((Item)HBMItems.icf_pellet_empty.get());
        }
        if (index == 2) {
            return stack.m_150930_((Item)HBMComponent.PARTICLE_MUON.get());
        }
        if (index == 6 || index == 4) {
            return ItemICFPellet.fuelFromStack(stack) != null;
        }
        if (index == 7 || index == 5) {
            return ItemICFPellet.fuelFromStack(stack) != null;
        }
        return false;
    }

    @Override
    public boolean m_7155_(int index, ItemStack stack, Direction direction) {
        return this.m_7013_(index, stack);
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index == 1 || index == 3;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.muonCharge = tag.m_128451_("progress");
        if (tag.m_128441_("fluids")) {
            this.fluids.deserializeNBT(tag.m_128469_("fluids"));
        }
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("progress", this.muonCharge);
        tag.m_128365_("fluids", (Tag)this.fluids.serializeNBT());
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)HBMLang.ICF_PRESS.key());
    }

    @Override
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new ICFPressMenu(containerId, inventory, (Container)this, this.containerData);
    }

    public Container getContainer() {
        return this;
    }

    private FluidTank createFuelTank() {
        return new FluidTank(16000){

            public boolean isFluidValid(FluidStack stack) {
                return stack != null && !stack.isEmpty() && ItemICFPellet.fuelFromFluid(stack) != null;
            }

            protected void onContentsChanged() {
                super.onContentsChanged();
                ICFPressBlockEntity.this.m_6596_();
            }
        };
    }

    public int getLeftTankAmount() {
        return this.leftTank.getFluidAmount();
    }

    public int getRightTankAmount() {
        return this.rightTank.getFluidAmount();
    }

    public BasicFluidHandler getFluids() {
        return this.fluids;
    }

    private record FuelPair(FuelSource primary, FuelSource secondary) {
    }

    private record FuelSource(ItemICFPellet.FuelType type, int slot, FluidTank tank) {
        boolean usesFluid() {
            return this.tank != null;
        }
    }
}

