/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine.icf;

import com.hbm.HBMLang;
import com.hbm.Inventory.fluid.ModFluids;
import com.hbm.api.Mode;
import com.hbm.api.fluid.BasicFluidHandler;
import com.hbm.api.inventory.ModeBuilder;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.DummyableBlockEntity;
import com.hbm.gui.menu.ICFMenu;
import com.hbm.item.HBMItems;
import com.hbm.item.icf.ItemICFPellet;
import com.hbm.registries.ModBlocks;
import com.hbm.utils.multiblock.MultiblockData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class ICFReactorBlockEntity
extends DummyableBlockEntity
implements MenuProvider {
    public static final int SLOT_INPUT_START = 0;
    public static final int SLOT_INPUT_END = 4;
    public static final int SLOT_ACTIVE = 5;
    public static final int SLOT_OUTPUT_START = 6;
    public static final int SLOT_OUTPUT_END = 10;
    public static final int SLOT_COOLANT = 11;
    private static final long MAX_HEAT = 1000000000000L;
    private static final long HEAT_PER_MB = 25000L;
    private static final long PASSIVE_DECAY = 250000L;
    private static final int COOLANT_CAPACITY = 512000;
    private long heat;
    private long laserInput;
    private long maxLaserInput;
    private long lastLaserInput;
    private final BasicFluidHandler fluids = new BasicFluidHandler().addTank(512000, Mode.INPUT).addTank(512000, Mode.OUTPUT);
    private final ContainerData containerData = new SimpleContainerData(4){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> (int)Math.min(Integer.MAX_VALUE, ICFReactorBlockEntity.this.heat / 1000L);
                case 1 -> ICFReactorBlockEntity.this.fluids.getFluidTanks().get(0).getFluidAmount();
                case 2 -> ICFReactorBlockEntity.this.fluids.getFluidTanks().get(1).getFluidAmount();
                case 3 -> (int)Math.min(Integer.MAX_VALUE, ICFReactorBlockEntity.this.lastLaserInput / 1000L);
                default -> 0;
            };
        }
    };

    public ICFReactorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.ICF_REACTOR_ENTITY.get(), pos, state);
        this.items = NonNullList.m_122780_((int)12, (Object)ItemStack.f_41583_);
        this.slotModes = new ModeBuilder().addModes(new Object[]{5, Mode.INPUT, 1, Mode.NONE, 5, Mode.OUTPUT, 1, Mode.BOTH}).get();
        this.multiblockData = MultiblockData.mapping.get(ModBlocks.machine_icf.get());
        this.capabilitiesContent.addCapability(ForgeCapabilities.FLUID_HANDLER, this.fluids);
        this.capabilitiesContent.addCapability(ForgeCapabilities.ITEM_HANDLER, this);
        this.fluids.getFluidTanks().set(0, new FluidTank(512000){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_6212_((Fluid)ModFluids.COOLANT.source().get()) || stack.getFluid().m_6212_((Fluid)Fluids.f_76193_);
            }
        });
        this.fluids.getFluidTanks().set(1, new FluidTank(512000){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_6212_((Fluid)ModFluids.COOLANT_HOT.source().get());
            }
        });
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.heat = tag.m_128454_("heat");
        if (tag.m_128441_("fluids")) {
            this.fluids.deserializeNBT(tag.m_128469_("fluids"));
        }
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128356_("heat", this.heat);
        tag.m_128365_("fluids", (Tag)this.fluids.serializeNBT());
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (!this.isFormed) {
            this.laserInput = 0L;
            this.maxLaserInput = 0L;
            return;
        }
        this.tickFluidSlot();
        this.handlePelletTransfer();
        this.processActivePellet();
        this.convertHeatToCoolant();
        this.passiveCooldown();
        this.lastLaserInput = this.laserInput;
        this.laserInput = 0L;
        this.maxLaserInput = 0L;
        if (this.heat > 1000000000000L) {
            this.triggerMeltdown();
        }
    }

    private void tickFluidSlot() {
        ItemStack stack = (ItemStack)this.items.get(11);
        if (stack.m_41619_()) {
            return;
        }
        FluidTank coldTank = this.fluids.getFluidTanks().get(0);
        FluidTank hotTank = this.fluids.getFluidTanks().get(1);
        Item item = stack.m_41720_();
        if (item instanceof BucketItem) {
            FluidStack drained;
            BucketItem bucket = (BucketItem)item;
            if (bucket.getFluid().m_6212_((Fluid)ModFluids.COOLANT.source().get())) {
                if (coldTank.fill(new FluidStack(bucket.getFluid(), 1000), IFluidHandler.FluidAction.SIMULATE) == 1000) {
                    coldTank.fill(new FluidStack(bucket.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
                    this.items.set(11, (Object)Items.f_42446_.m_7968_());
                    this.m_6596_();
                }
            } else if (bucket.getFluid().m_6212_((Fluid)ModFluids.COOLANT_HOT.source().get())) {
                if (hotTank.fill(new FluidStack(bucket.getFluid(), 1000), IFluidHandler.FluidAction.SIMULATE) == 1000) {
                    hotTank.fill(new FluidStack(bucket.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
                    this.items.set(11, (Object)Items.f_42446_.m_7968_());
                    this.m_6596_();
                }
            } else if (bucket == Items.f_42446_ && !(drained = hotTank.drain(1000, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && drained.getAmount() == 1000) {
                hotTank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                this.items.set(11, (Object)drained.getFluid().m_6859_().m_7968_());
                this.m_6596_();
            }
        }
    }

    private void handlePelletTransfer() {
        ItemStack active = (ItemStack)this.items.get(5);
        if (!active.m_41619_() && active.m_150930_((Item)HBMItems.icf_pellet_depleted.get())) {
            this.pushToOutputs(active.m_41777_());
            this.items.set(5, (Object)ItemStack.f_41583_);
            this.m_6596_();
        }
        if (((ItemStack)this.items.get(5)).m_41619_()) {
            for (int i = 0; i <= 4; ++i) {
                ItemStack stack = (ItemStack)this.items.get(i);
                if (stack.m_41619_() || !stack.m_150930_((Item)HBMItems.icf_pellet.get())) continue;
                this.items.set(5, (Object)stack.m_41777_());
                this.items.set(i, (Object)ItemStack.f_41583_);
                this.m_6596_();
                break;
            }
        }
    }

    private void pushToOutputs(ItemStack stack) {
        for (int i = 6; i <= 10; ++i) {
            ItemStack current = (ItemStack)this.items.get(i);
            if (!current.m_41619_()) continue;
            this.items.set(i, (Object)stack);
            return;
        }
    }

    private void processActivePellet() {
        ItemStack active = (ItemStack)this.items.get(5);
        if (active.m_41619_() || !active.m_150930_((Item)HBMItems.icf_pellet.get())) {
            return;
        }
        long difficulty = ItemICFPellet.getFusingDifficulty(active);
        if (this.laserInput <= 0L) {
            return;
        }
        if (this.laserInput < difficulty) {
            this.heat = Math.min(1000000000000L, this.heat + Math.max(1L, this.laserInput / 4L));
            return;
        }
        long produced = ItemICFPellet.react(active, this.laserInput);
        this.heat = Math.min(1000000000000L, this.heat + produced);
        if (ItemICFPellet.isSpent(active)) {
            ItemStack depleted = new ItemStack((ItemLike)HBMItems.icf_pellet_depleted.get());
            this.items.set(5, (Object)depleted);
        }
        this.m_6596_();
    }

    private void convertHeatToCoolant() {
        if (this.heat <= 25000L) {
            return;
        }
        FluidTank cold = this.fluids.getFluidTanks().get(0);
        FluidTank hot = this.fluids.getFluidTanks().get(1);
        if (cold.getFluidAmount() <= 0) {
            return;
        }
        int space = hot.getCapacity() - hot.getFluidAmount();
        if (space <= 0) {
            return;
        }
        long maxByHeat = this.heat / 25000L;
        int transferable = (int)Math.min(Math.min(maxByHeat, (long)cold.getFluidAmount()), (long)space);
        if (transferable <= 0) {
            return;
        }
        FluidStack drained = cold.drain(transferable, IFluidHandler.FluidAction.EXECUTE);
        if (drained.isEmpty()) {
            return;
        }
        hot.fill(new FluidStack((Fluid)ModFluids.COOLANT_HOT.source().get(), drained.getAmount()), IFluidHandler.FluidAction.EXECUTE);
        this.heat = Math.max(0L, this.heat - (long)transferable * 25000L);
        this.m_6596_();
    }

    private void passiveCooldown() {
        if (this.heat <= 0L) {
            this.heat = 0L;
            return;
        }
        this.heat = Math.max(0L, this.heat - 250000L);
    }

    private void triggerMeltdown() {
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        BlockPos pos = this.m_58899_();
        level.m_254849_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 10.0f, Level.ExplosionInteraction.TNT);
        level.m_46597_(pos, Blocks.f_49991_.m_49966_());
        this.heat = 0L;
    }

    public void receiveLaser(long energy, long maxEnergy) {
        if (energy <= 0L) {
            return;
        }
        this.laserInput = Math.min(1000000000000L, this.laserInput + energy);
        this.maxLaserInput = Math.max(this.maxLaserInput, maxEnergy);
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)HBMLang.ICF.key());
    }

    @Override
    public Component m_5446_() {
        return this.getDefaultName();
    }

    @Override
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new ICFMenu(containerId, inventory, (Container)this, this.containerData);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot >= 0 && slot <= 4) {
            return stack.m_150930_((Item)HBMItems.icf_pellet.get());
        }
        if (slot >= 6 && slot <= 10) {
            return false;
        }
        if (slot == 5) {
            return false;
        }
        if (slot == 11) {
            return stack.m_41720_() instanceof BucketItem;
        }
        return super.isItemValid(slot, stack);
    }

    public long getHeat() {
        return this.heat;
    }

    public Container getContainer() {
        return this;
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }
}

