/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine.pile;

import com.hbm.block.machine.pile.ChicagoPileStateProperties;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.machine.pile.ChicagoPileBlockEntity;
import com.hbm.item.research.ItemPileRod;
import com.hbm.registries.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ChicagoBreederBlockEntity
extends ChicagoPileBlockEntity {
    private static final String TAG_ROD = "Rod";
    private static final String TAG_PROGRESS = "Progress";
    private static final String TAG_NEUTRONS = "Neutrons";
    private ItemStack rod = ItemStack.f_41583_;
    private int progress;
    private int neutrons;
    private int lastNeutrons;

    public ChicagoBreederBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.CHICAGO_BREEDER.get(), pos, state);
    }

    public void setBaseItem(ItemStack stack) {
        this.rod = stack.m_41777_();
        this.rod.m_41764_(1);
        Item item = this.rod.m_41720_();
        if (item instanceof ItemPileRod) {
            ItemPileRod rodItem = (ItemPileRod)item;
            this.progress = rodItem.getLifetime(this.rod);
        } else {
            this.progress = 0;
        }
        this.neutrons = 0;
        this.lastNeutrons = 0;
        this.m_6596_();
    }

    public ItemStack extractRod() {
        if (this.rod.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = this.rod.m_41777_();
        this.rod = ItemStack.f_41583_;
        this.progress = 0;
        this.neutrons = 0;
        this.lastNeutrons = 0;
        this.m_6596_();
        return result;
    }

    public ItemStack getRodSnapshot() {
        return this.rod.m_41777_();
    }

    public boolean hasRod() {
        return !this.rod.m_41619_();
    }

    public int getMaxProgress() {
        Item item = this.rod.m_41720_();
        if (item instanceof ItemPileRod) {
            ItemPileRod rodItem = (ItemPileRod)item;
            return rodItem.getSpec().maxLife();
        }
        return 0;
    }

    @Override
    protected void serverTick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.rod.m_41619_()) {
            this.neutrons = 0;
            return;
        }
        Item item = this.rod.m_41720_();
        if (!(item instanceof ItemPileRod)) {
            this.rod = ItemStack.f_41583_;
            this.neutrons = 0;
            return;
        }
        ItemPileRod rodItem = (ItemPileRod)item;
        this.lastNeutrons = this.neutrons;
        if (this.lastNeutrons > 0) {
            rodItem.addLifetime(this.rod, this.lastNeutrons);
            this.progress = rodItem.getLifetime(this.rod);
            this.emitNeutrons(1, 2);
            this.m_6596_();
        }
        this.neutrons = 0;
        int max = rodItem.getSpec().maxLife();
        if (max > 0 && this.progress >= max) {
            this.finishBreeding();
        }
    }

    private void finishBreeding() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState current = this.m_58900_();
        BlockState replacement = ((Block)ModBlocks.chicago_graphite_tritium.get()).m_49966_();
        if (current.m_61138_((Property)RotatedPillarBlock.f_55923_)) {
            replacement = (BlockState)replacement.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)current.m_61143_((Property)RotatedPillarBlock.f_55923_)));
        }
        if (current.m_61138_((Property)ChicagoPileStateProperties.SHIELDED)) {
            replacement = (BlockState)replacement.m_61124_((Property)ChicagoPileStateProperties.SHIELDED, (Comparable)((Boolean)current.m_61143_((Property)ChicagoPileStateProperties.SHIELDED)));
        }
        this.f_58857_.m_7731_(this.f_58858_, replacement, 3);
        this.rod = ItemStack.f_41583_;
        this.progress = 0;
        this.lastNeutrons = 0;
        this.neutrons = 0;
    }

    @Override
    public void receiveNeutrons(int amount) {
        this.neutrons += amount;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.rod.m_41619_()) {
            tag.m_128365_(TAG_ROD, (Tag)this.rod.m_41739_(new CompoundTag()));
        }
        tag.m_128405_(TAG_PROGRESS, this.progress);
        tag.m_128405_(TAG_NEUTRONS, this.neutrons);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.rod = tag.m_128441_(TAG_ROD) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_ROD)) : ItemStack.f_41583_;
        this.progress = tag.m_128451_(TAG_PROGRESS);
        this.neutrons = tag.m_128451_(TAG_NEUTRONS);
    }

    public int getLastNeutrons() {
        return this.lastNeutrons;
    }

    public int getProgress() {
        return this.progress;
    }
}

