/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine.pile;

import com.hbm.block.machine.pile.ChicagoPileStateProperties;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.machine.pile.ChicagoPileBlockEntity;
import com.hbm.item.HBMItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ChicagoDetectorBlockEntity
extends ChicagoPileBlockEntity {
    private static final String TAG_ROD = "Rod";
    private static final String TAG_THRESHOLD = "Threshold";
    private static final String TAG_NEUTRONS = "Neutrons";
    private static final int MIN_THRESHOLD = 1;
    private static final int MAX_THRESHOLD = 64;
    private static final int DEFAULT_THRESHOLD = 10;
    private ItemStack rod = ItemStack.f_41583_;
    private int threshold = 10;
    private int neutrons;

    public ChicagoDetectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.CHICAGO_DETECTOR.get(), pos, state);
    }

    public void insertRod(ItemStack stack) {
        this.rod = stack.m_41777_();
        this.rod.m_41764_(1);
        this.threshold = 10;
        this.neutrons = 0;
        this.setTriggered(false);
        this.m_6596_();
    }

    public ItemStack extractRod() {
        if (this.rod.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = this.rod.m_41777_();
        this.rod = ItemStack.f_41583_;
        this.neutrons = 0;
        this.setTriggered(false);
        this.m_6596_();
        return stack;
    }

    public int adjustThreshold(int delta) {
        this.threshold = Mth.m_14045_((int)(this.threshold + delta), (int)1, (int)64);
        this.m_6596_();
        return this.threshold;
    }

    public boolean hasRod() {
        return !this.rod.m_41619_();
    }

    public ItemStack getRodSnapshot() {
        return this.rod.m_41777_();
    }

    public int getThresholdValue() {
        return this.threshold;
    }

    public Component thresholdMessage(int value) {
        return Component.m_237110_((String)"message.hbm.chicago_detector.threshold", (Object[])new Object[]{value});
    }

    public void reset() {
        this.insertRod(new ItemStack((ItemLike)HBMItems.PILE_ROD_DETECTOR.get()));
    }

    @Override
    protected void serverTick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.rod.m_41619_()) {
            this.neutrons = 0;
            this.setTriggered(false);
            return;
        }
        boolean active = this.neutrons >= this.threshold;
        this.neutrons = 0;
        this.setTriggered(active);
    }

    private void setTriggered(boolean active) {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState state = this.m_58900_();
        if (!state.m_61138_((Property)ChicagoPileStateProperties.TRIGGERED)) {
            return;
        }
        if ((Boolean)state.m_61143_((Property)ChicagoPileStateProperties.TRIGGERED) == active) {
            return;
        }
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)ChicagoPileStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(active)), 3);
        this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
    }

    @Override
    public void receiveNeutrons(int amount) {
        this.neutrons += amount;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.rod.m_41619_()) {
            tag.m_128365_(TAG_ROD, (Tag)this.rod.m_41739_(new CompoundTag()));
        }
        tag.m_128405_(TAG_THRESHOLD, this.threshold);
        tag.m_128405_(TAG_NEUTRONS, this.neutrons);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.rod = tag.m_128441_(TAG_ROD) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_ROD)) : ItemStack.f_41583_;
        this.threshold = tag.m_128441_(TAG_THRESHOLD) ? tag.m_128451_(TAG_THRESHOLD) : 10;
        this.neutrons = tag.m_128451_(TAG_NEUTRONS);
    }
}

