/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine.pile;

import com.hbm.block.machine.pile.ChicagoPileStateProperties;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.machine.pile.ChicagoPileBlockEntity;
import com.hbm.blockentity.machine.pile.ChicagoSourceBlockEntity;
import com.hbm.item.HBMItems;
import com.hbm.item.research.ItemPileRod;
import com.hbm.registries.ModBlocks;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ChicagoFuelBlockEntity
extends ChicagoPileBlockEntity {
    private static final double MELTDOWN_HEAT = 1000.0;
    private FuelVariant variant;
    private int rodLife;
    private int incomingNeutrons;
    private double heat;

    public ChicagoFuelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.CHICAGO_FUEL.get(), pos, state);
    }

    public void loadFromItem(FuelVariant variant, ItemStack stack) {
        this.variant = variant;
        Item item = stack.m_41720_();
        if (item instanceof ItemPileRod) {
            ItemPileRod rod = (ItemPileRod)item;
            this.rodLife = rod.getLifetime(stack);
        } else {
            this.rodLife = 0;
        }
        this.heat = 0.0;
        this.incomingNeutrons = 0;
        this.m_6596_();
    }

    public ItemStack extractRod() {
        if (this.variant == null) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = new ItemStack((ItemLike)this.variant.item.get());
        Item item = stack.m_41720_();
        if (item instanceof ItemPileRod) {
            ItemPileRod rod = (ItemPileRod)item;
            rod.addLifetime(stack, this.rodLife);
        }
        this.variant = null;
        this.rodLife = 0;
        this.heat = 0.0;
        this.incomingNeutrons = 0;
        this.m_6596_();
        return stack;
    }

    @Override
    public void receiveNeutrons(int amount) {
        this.incomingNeutrons += amount;
    }

    @Override
    protected void serverTick() {
        if (this.variant == null || this.f_58857_ == null) {
            this.incomingNeutrons = 0;
            return;
        }
        this.dissipateHeat();
        int reaction = (int)((double)this.incomingNeutrons * this.reactivityModifier());
        this.incomingNeutrons = 0;
        if (reaction <= 0) {
            return;
        }
        this.heat += (double)reaction * this.variant.heatFactor;
        this.rodLife += reaction;
        this.emitNeutrons(Math.max(1, (int)Math.round((double)reaction * this.variant.fluxFactor)), 12);
        this.m_6596_();
        if (this.heat >= 1000.0) {
            this.meltdown();
            return;
        }
        if (this.rodLife >= this.variant.maxLife) {
            this.turnIntoPlutonium();
        }
    }

    private double reactivityModifier() {
        double clamp = Math.min(this.heat / 1000.0, 1.0);
        return Math.max(0.0, 1.0 - clamp * 0.5);
    }

    private void dissipateHeat() {
        this.heat *= 0.95;
        if (this.heat < 0.01) {
            this.heat = 0.0;
        }
    }

    private void meltdown() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_254849_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, 4.0f, Level.ExplosionInteraction.BLOCK);
        this.f_58857_.m_7471_(this.f_58858_, false);
    }

    private void turnIntoPlutonium() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState replacement = ((Block)ModBlocks.chicago_graphite_source.get()).m_49966_();
        replacement = (BlockState)replacement.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)((Direction.Axis)this.m_58900_().m_61143_((Property)RotatedPillarBlock.f_55923_)));
        replacement = (BlockState)replacement.m_61124_((Property)ChicagoPileStateProperties.SHIELDED, (Comparable)((Boolean)this.m_58900_().m_61143_((Property)ChicagoPileStateProperties.SHIELDED)));
        this.f_58857_.m_7731_(this.f_58858_, replacement, 3);
        BlockEntity be = this.f_58857_.m_7702_(this.f_58858_);
        if (be instanceof ChicagoSourceBlockEntity) {
            ChicagoSourceBlockEntity source = (ChicagoSourceBlockEntity)be;
            source.setType(ChicagoSourceBlockEntity.SourceType.PLUTONIUM);
        }
    }

    public FuelVariant getVariant() {
        return this.variant;
    }

    public int getRodLife() {
        return this.rodLife;
    }

    public double getHeatLevel() {
        return this.heat;
    }

    public double getMeltdownHeat() {
        return 1000.0;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.variant != null) {
            tag.m_128359_("Variant", this.variant.name());
            tag.m_128405_("RodLife", this.rodLife);
            tag.m_128347_("Heat", this.heat);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Variant")) {
            try {
                this.variant = FuelVariant.valueOf(tag.m_128461_("Variant").toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ignored) {
                this.variant = FuelVariant.URANIUM;
            }
            this.rodLife = tag.m_128451_("RodLife");
            this.heat = tag.m_128459_("Heat");
        } else {
            this.variant = null;
            this.rodLife = 0;
            this.heat = 0.0;
        }
    }

    public static enum FuelVariant {
        URANIUM((Supplier<? extends Item>)HBMItems.PILE_ROD_URANIUM, 50000, 0.8, 0.25),
        PU239((Supplier<? extends Item>)HBMItems.PILE_ROD_PU239, 40000, 1.0, 0.3);

        public final Supplier<? extends Item> item;
        public final int maxLife;
        public final double fluxFactor;
        public final double heatFactor;

        private FuelVariant(Supplier<? extends Item> item, int maxLife, double fluxFactor, double heatFactor) {
            this.item = item;
            this.maxLife = maxLife;
            this.fluxFactor = fluxFactor;
            this.heatFactor = heatFactor;
        }
    }
}

