/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine.rbmk;

import com.hbm.Inventory.fluid.ModFluids;
import com.hbm.api.Mode;
import com.hbm.api.energy.BasicEnergyContainer;
import com.hbm.api.energy.HybridEnergyStorage;
import com.hbm.api.energy.ProxyEnergyHandler;
import com.hbm.api.energy.TransmitUtils;
import com.hbm.api.fluid.BasicFluidHandler;
import com.hbm.block.machine.rbmk.BlockRBMKBase;
import com.hbm.block.machine.rbmk.BlockRBMKControlRod;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.DummyableBlockEntity;
import com.hbm.blockentity.machine.rbmk.RBMKControlRodEntity;
import com.hbm.capabilities.HBMCaps;
import com.hbm.gui.menu.RBMKBaseMenu;
import com.hbm.reactor.rbmk.RBMKColumnState;
import com.hbm.reactor.rbmk.RBMKLevelContext;
import com.hbm.reactor.rbmk.RBMKLidType;
import com.hbm.reactor.rbmk.RBMKManager;
import com.hbm.reactor.rbmk.RBMKSettings;
import com.hbm.registries.ModBlocks;
import com.hbm.registries.ModSounds;
import com.hbm.utils.multiblock.MultiblockData;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class RBMKBaseEntity
extends DummyableBlockEntity {
    private static final double TARGET_HEAT = 100.0;
    private static final double MAX_HEAT_CONVERSION_PER_TICK = 2.0;
    private static final double ENERGY_PER_HEAT = 10000.0;
    private static final int WATER_TANK_CAPACITY = 16000;
    private static final int STEAM_TANK_CAPACITY = 16000;
    private static final double HEAT_PER_MB = 5.0;
    private final BasicEnergyContainer energy = new BasicEnergyContainer(10000000L, 10000000L, 50000L);
    private final BasicFluidHandler fluidHandler = new BasicFluidHandler().addTank(16000, Mode.INPUT).addTank(16000, Mode.OUTPUT);
    private final int[] dataSlots = new int[8];
    private final ContainerData containerData = new ContainerData(){

        public int m_6413_(int index) {
            return index >= 0 && index < RBMKBaseEntity.this.dataSlots.length ? RBMKBaseEntity.this.dataSlots[index] : 0;
        }

        public void m_8050_(int index, int value) {
            if (index >= 0 && index < RBMKBaseEntity.this.dataSlots.length) {
                RBMKBaseEntity.this.dataSlots[index] = value;
            }
        }

        public int m_6499_() {
            return RBMKBaseEntity.this.dataSlots.length;
        }
    };

    public RBMKBaseEntity(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)ModBlockEntityType.RBMK_BASE_ENTITY.get(), pPos, pState);
        this.items = NonNullList.m_122780_((int)0, (Object)ItemStack.f_41583_);
        this.slotModes = List.of();
        this.multiblockData = MultiblockData.mapping.get(ModBlocks.machine_rbmk_base.get());
        this.capabilitiesContent.addCapability(ForgeCapabilities.ITEM_HANDLER, this);
        this.capabilitiesContent.addCapability(HBMCaps.LONG_ENERGY, new ProxyEnergyHandler(this.energy));
        this.capabilitiesContent.addCapability(ForgeCapabilities.ENERGY, new HybridEnergyStorage(this.energy));
        this.capabilitiesContent.addCapability(ForgeCapabilities.FLUID_HANDLER, this.fluidHandler);
        this.fluidHandler.getFluidTanks().set(0, new FluidTank(16000){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_6212_((Fluid)Fluids.f_76193_) || stack.getFluid().m_6212_((Fluid)ModFluids.IRRADIATED_WATER.source().get());
            }
        });
        this.energy.setListener(this);
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RBMKLevelContext context = RBMKManager.context(serverLevel);
            RBMKLidType lidType = this.getLidType();
            context.registerColumn(this.m_58899_(), RBMKSettings.forLevel(serverLevel)).setLidType(lidType);
        }
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        RBMKLevelContext context = RBMKManager.context(serverLevel);
        Optional<RBMKColumnState> columnOpt = context.column(this.f_58858_);
        if (columnOpt.isEmpty()) {
            this.updateClientData(context, null);
            return;
        }
        RBMKColumnState column = columnOpt.get();
        if (this.energy.getNeeded() > 0L && column.heat() > 100.0) {
            long accepted;
            double heatAvailable = Math.min(column.heat() - 100.0, 2.0);
            long energyToProduce = (long)Math.min((double)this.energy.getNeeded(), heatAvailable * 10000.0);
            if (energyToProduce > 0L && (accepted = this.energy.receive(energyToProduce, false)) > 0L) {
                double heatUsed = (double)accepted / 10000.0;
                context.addHeat(this.f_58858_, -heatUsed);
                this.m_6596_();
            }
        }
        this.coolAndBoil(context, column);
        TransmitUtils.outputOnly(this);
        this.updateClientData(context, column);
    }

    private void coolAndBoil(RBMKLevelContext context, RBMKColumnState column) {
        int maxByWater;
        FluidTank water = this.fluidHandler.getFluidTanks().get(0);
        FluidTank steam = this.fluidHandler.getFluidTanks().get(1);
        if (water.isEmpty() || column.heat() <= 0.0) {
            return;
        }
        int steamSpace = steam.getCapacity() - steam.getFluidAmount();
        if (steamSpace <= 0) {
            return;
        }
        int maxByHeat = (int)Math.floor(column.heat() / 5.0);
        int mbToConvert = Math.min(Math.min(maxByHeat, maxByWater = water.getFluidAmount()), steamSpace);
        if (mbToConvert <= 0) {
            return;
        }
        water.drain(mbToConvert, IFluidHandler.FluidAction.EXECUTE);
        steam.fill(new FluidStack((Fluid)ModFluids.STEAM.source().get(), mbToConvert), IFluidHandler.FluidAction.EXECUTE);
        context.addHeat(this.f_58858_, (double)(-mbToConvert) * 5.0);
        this.m_6596_();
    }

    public void onChunkUnloaded() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RBMKManager.context(serverLevel).removeColumn(this.m_58899_());
        }
        super.onChunkUnloaded();
    }

    public void m_7651_() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RBMKManager.context(serverLevel).removeColumn(this.m_58899_());
        }
        super.m_7651_();
    }

    public RBMKLidType getLidType() {
        BlockState state = this.m_58900_();
        if (state.m_61138_(BlockRBMKBase.LID)) {
            return (RBMKLidType)((Object)state.m_61143_(BlockRBMKBase.LID));
        }
        return RBMKLidType.NONE;
    }

    public void setLidType(RBMKLidType type) {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (state.m_61138_(BlockRBMKBase.LID) && state.m_61143_(BlockRBMKBase.LID) != type) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_(BlockRBMKBase.LID, (Comparable)((Object)type)), 3);
        }
        RBMKManager.context(serverLevel).setLidState(this.f_58858_, type);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("energy")) {
            this.energy.deserializeNBT(tag.m_128469_("energy"));
        }
        if (tag.m_128441_("fluids")) {
            this.fluidHandler.deserializeNBT(tag.m_128469_("fluids"));
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("fluids", (Tag)this.fluidHandler.serializeNBT());
    }

    @Override
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new RBMKBaseMenu(containerId, inventory, (Container)this, this.getContainerData());
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)"block.hbm.machine_rbmk_base");
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    public long getEnergyStored() {
        return this.energy.getEnergy();
    }

    public long getEnergyCapacity() {
        return this.energy.getCapacity();
    }

    public int getWaterAmount() {
        return this.fluidHandler.getFluidTanks().get(0).getFluidAmount();
    }

    public int getSteamAmount() {
        return this.fluidHandler.getFluidTanks().get(1).getFluidAmount();
    }

    public void triggerAz5() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos controlPos = this.f_58858_.m_7494_();
        BlockState stateAbove = this.f_58857_.m_8055_(controlPos);
        BlockEntity blockEntity = this.f_58857_.m_7702_(controlPos);
        if (blockEntity instanceof RBMKControlRodEntity) {
            RBMKControlRodEntity controlRodEntity = (RBMKControlRodEntity)blockEntity;
            controlRodEntity.engageAz5();
        } else {
            blockEntity = stateAbove.m_60734_();
            if (blockEntity instanceof BlockRBMKControlRod) {
                BlockRBMKControlRod controlRod = (BlockRBMKControlRod)blockEntity;
                if ((Integer)stateAbove.m_61143_((Property)BlockRBMKControlRod.INSERTION) != 4) {
                    this.f_58857_.m_7731_(controlPos, (BlockState)stateAbove.m_61124_((Property)BlockRBMKControlRod.INSERTION, (Comparable)Integer.valueOf(4)), 3);
                }
                this.f_58857_.m_5594_(null, controlPos, (SoundEvent)ModSounds.BLOCK_RBMK_AZ5_COVER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.BLOCK_RBMK_AZ5_COVER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        RBMKManager.context(serverLevel).setControlRodInsertion(this.f_58858_, 1.0);
    }

    private void updateClientData(RBMKLevelContext context, RBMKColumnState column) {
        this.dataSlots[2] = (int)Math.min(Integer.MAX_VALUE, this.energy.getEnergy());
        this.dataSlots[3] = (int)Math.min(Integer.MAX_VALUE, this.energy.getCapacity());
        this.dataSlots[4] = this.fluidHandler.getFluidTanks().get(0).getFluidAmount();
        this.dataSlots[5] = this.fluidHandler.getFluidTanks().get(1).getFluidAmount();
        if (column != null && context != null) {
            this.dataSlots[0] = (int)Math.round(column.heat() * 10.0);
            this.dataSlots[1] = (int)Math.round(column.settings().meltdownHeat() * 10.0);
            this.dataSlots[6] = (int)Math.round(column.controlRodInsertion() * 100.0);
            this.dataSlots[7] = (int)Math.round(context.controlRodAverage() * 100.0);
        } else {
            this.dataSlots[0] = 0;
            this.dataSlots[1] = 0;
            this.dataSlots[6] = 0;
            this.dataSlots[7] = 0;
        }
    }
}

